/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.helpers.generators;

import com.google.common.reflect.TypeToken;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ssblur.scriptor.helpers.generators.TokenGenerator;
import java.lang.reflect.Type;
import java.util.Random;
import org.jetbrains.annotations.Nullable;

public class MixedGroupGenerator
extends TokenGenerator {
    static Type PARAMETERS_TYPE = new TypeToken<MixedGroupParameters>(){}.getType();
    static Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    static Random RANDOM = new Random();
    int totalWeight;
    MixedGroupParameters parameters;

    public MixedGroupGenerator(JsonObject object) {
        this.parameters = (MixedGroupParameters)GSON.fromJson((JsonElement)object, PARAMETERS_TYPE);
        for (TokenGroup group : this.parameters.groups()) {
            this.totalWeight += group.weight();
        }
    }

    protected MixedGroupGenerator() {
    }

    @Override
    public boolean canBeDefault() {
        return true;
    }

    @Override
    public String generateToken(String key, @Nullable JsonObject parameters) {
        int maxTokens = this.parameters.maxTokens;
        int minTokens = this.parameters.minTokens;
        int maxConsecutiveGroups = this.parameters.maxConsecutiveGroups;
        if (this.parameters.groups.length <= 1) {
            maxConsecutiveGroups = 0;
        }
        if (parameters != null) {
            if (parameters.has("max_tokens")) {
                maxTokens = parameters.get("max_tokens").getAsInt();
            }
            if (parameters.has("min_tokens")) {
                minTokens = parameters.get("min_tokens").getAsInt();
            }
        }
        int tokens = RANDOM.nextInt(minTokens, maxTokens + 1);
        StringBuilder builder = new StringBuilder();
        TokenGroup lastGroup = null;
        int consecutiveGroups = 0;
        for (int i = 0; i < tokens; ++i) {
            TokenGroup tokenGroup = null;
            block1: do {
                int random = RANDOM.nextInt(this.totalWeight);
                for (TokenGroup group : this.parameters.groups()) {
                    if (random < group.weight) {
                        tokenGroup = group;
                        continue block1;
                    }
                    random -= group.weight;
                }
            } while (tokenGroup == null || maxConsecutiveGroups > 0 && lastGroup == tokenGroup && consecutiveGroups >= maxConsecutiveGroups);
            if (lastGroup != tokenGroup) {
                consecutiveGroups = 0;
                lastGroup = tokenGroup;
            }
            ++consecutiveGroups;
            String[] groupTokens = tokenGroup.tokens;
            builder.append(groupTokens[RANDOM.nextInt(groupTokens.length)]);
        }
        return builder.toString();
    }

    public record MixedGroupParameters(TokenGroup[] groups, int maxConsecutiveGroups, int minTokens, int maxTokens) {
    }

    public record TokenGroup(String[] tokens, int weight) {
    }
}

