/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.helpers.resource;

import com.ssblur.scriptor.api.word.Action;
import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Subject;
import com.ssblur.scriptor.error.WordNotFoundException;
import com.ssblur.scriptor.registry.words.WordRegistry;
import com.ssblur.scriptor.word.PartialSpell;
import com.ssblur.scriptor.word.Spell;
import java.util.ArrayList;
import java.util.List;

public class TomeResource {
    String name;
    String author;
    SpellResource spell;
    String item;
    int tier;

    public String getAuthor() {
        return this.author;
    }

    public String getName() {
        return this.name;
    }

    public int getTier() {
        return this.tier;
    }

    public String getItem() {
        return this.item;
    }

    public Spell getSpell() {
        ArrayList<PartialSpell> spells = new ArrayList<PartialSpell>();
        for (PartialSpellResource spell : this.spell.spells) {
            Action action = (Action)WordRegistry.INSTANCE.actionRegistry.get((Object)spell.action);
            if (action == null) {
                throw new WordNotFoundException(spell.action);
            }
            ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>();
            for (String string : spell.descriptors) {
                Descriptor descriptor = (Descriptor)WordRegistry.INSTANCE.descriptorRegistry.get((Object)string);
                if (descriptor == null) {
                    throw new WordNotFoundException(string);
                }
                descriptors.add(descriptor);
            }
            spells.add(new PartialSpell(action, (Descriptor[])descriptors.toArray(Descriptor[]::new)));
        }
        Subject subject = (Subject)WordRegistry.INSTANCE.subjectRegistry.get((Object)this.spell.subject);
        if (subject == null) {
            throw new WordNotFoundException(this.spell.subject);
        }
        return new Spell(subject, (PartialSpell[])spells.toArray(PartialSpell[]::new));
    }

    public static class SpellResource {
        String subject;
        List<PartialSpellResource> spells;

        public SpellResource(String subject, List<PartialSpellResource> spells) {
            this.subject = subject;
            this.spells = spells;
        }
    }

    public static class PartialSpellResource {
        String action;
        List<String> descriptors;

        public PartialSpellResource(String action, List<String> descriptors) {
            this.action = action;
            this.descriptors = descriptors;
        }
    }
}

