/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.helpers.targetable;

import java.util.function.Predicate;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface InventoryTargetable {
    @Nullable
    public Container getContainer();

    public int getTargetedSlot();

    public void setTargetedSlot(int var1);

    default public boolean shouldIgnoreTargetedSlot() {
        return this.getTargetedSlot() == -1 && this.getContainer() != null;
    }

    default public void useFirstMatchingSlot(Predicate<ItemStack> predicate) {
        int slot = this.getFirstMatchingSlot(predicate);
        if (slot >= 0) {
            this.setTargetedSlot(slot);
        }
    }

    default public int getFirstMatchingSlot(Predicate<ItemStack> predicate) {
        if (this.getContainer() != null) {
            for (int i = 0; i < this.getContainer().m_6643_(); ++i) {
                if (!predicate.test(this.getContainer().m_8020_(i))) continue;
                return i;
            }
        }
        return -1;
    }

    default public int getFirstFilledSlot() {
        return this.getFirstMatchingSlot((ItemStack item) -> !item.m_41619_());
    }

    default public int getFirstMatchingSlot(ItemStack itemStack) {
        return this.getFirstMatchingSlot((ItemStack item) -> item.m_41619_() || ItemStack.m_150942_((ItemStack)item, (ItemStack)itemStack) && item.m_41613_() + itemStack.m_41613_() <= item.m_41741_());
    }

    default public int getFirstMatchingSlotNotEmpty(ItemStack itemStack) {
        return this.getFirstMatchingSlot((ItemStack item) -> ItemStack.m_150942_((ItemStack)item, (ItemStack)itemStack) && item.m_41613_() + itemStack.m_41613_() <= item.m_41741_());
    }

    default public void useFirstFilledSlot() {
        int slot = this.getFirstFilledSlot();
        if (slot >= 0) {
            this.setTargetedSlot(slot);
        }
    }
}

