/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.helpers.targetable;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class Targetable {
    Vec3 targetPos;
    BlockPos origin;
    Level level;
    Direction direction = null;
    Targetable finalTargetable;

    public Targetable(Level level, Vec3 pos) {
        this.targetPos = pos;
        this.level = level;
    }

    public Targetable(Level level, Vector3f pos) {
        this.targetPos = new Vec3((double)pos.x(), (double)pos.y(), (double)pos.z());
        this.level = level;
    }

    public Targetable(Level level, BlockPos pos) {
        this.targetPos = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        this.level = level;
    }

    public Vec3 getTargetPos() {
        return this.targetPos;
    }

    public void setTargetPos(Vec3 targetPos) {
        this.targetPos = targetPos;
    }

    public void setTargetPos(Vector3f targetPos) {
        this.targetPos = new Vec3((double)targetPos.x(), (double)targetPos.y(), (double)targetPos.z());
    }

    public BlockPos getTargetBlockPos() {
        return new BlockPos((int)Math.floor(this.targetPos.f_82479_), (int)Math.floor(this.targetPos.f_82480_), (int)Math.floor(this.targetPos.f_82481_));
    }

    public Level getLevel() {
        return this.level;
    }

    public Direction getFacing() {
        if (this.direction != null) {
            return this.direction;
        }
        return Direction.UP;
    }

    public Targetable setFacing(@Nullable Direction direction) {
        this.direction = direction;
        return this;
    }

    public BlockPos getOffsetBlockPos() {
        if (this.direction != null) {
            return this.getTargetBlockPos().m_121945_(this.direction.m_122424_());
        }
        return this.getTargetBlockPos();
    }

    public BlockPos getOrigin() {
        return this.origin;
    }

    public void setOrigin(BlockPos origin) {
        this.origin = origin;
    }

    public void setFinalTargetable(Targetable targetable) {
        this.finalTargetable = targetable;
    }

    public Targetable getFinalTargetable() {
        if (this.finalTargetable != null) {
            return this.finalTargetable;
        }
        return this;
    }

    public Targetable simpleCopy() {
        Targetable out = new Targetable(this.level, this.targetPos);
        out.setFacing(this.getFacing());
        return out;
    }
}

