/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.ssblur.scriptor.helpers.SpellbookHelper;
import com.ssblur.scriptor.item.Spellbook;
import com.ssblur.scriptor.item.interfaces.ItemWithCustomRenderer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BookOfBooks
extends Item
implements ItemWithCustomRenderer {
    int capacity;

    public BookOfBooks(Item.Properties properties, int capacity) {
        super(properties);
        this.capacity = capacity;
        SpellbookHelper.SPELLBOOKS.add(this);
    }

    public boolean m_142305_(ItemStack book, ItemStack itemStack, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        if (clickAction != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        if (itemStack.m_41619_()) {
            BookOfBooks.remove(book, slotAccess);
        } else if (itemStack.m_41720_() instanceof Spellbook && BookOfBooks.getInventory(book).size() < this.capacity) {
            BookOfBooks.add(book, itemStack);
        } else {
            return false;
        }
        return true;
    }

    public Component m_7626_(ItemStack itemStack) {
        ItemStack item = BookOfBooks.getActiveItem(itemStack);
        if (!item.m_41619_()) {
            return Component.m_237110_((String)"item.scriptor.book_of_books_2", (Object[])new Object[]{item.m_41786_().getString()});
        }
        return super.m_7626_(itemStack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        InteractionResultHolder result = super.m_7203_(level, player, interactionHand);
        ItemStack book = player.m_21120_(interactionHand);
        boolean castResult = SpellbookHelper.castFromItem(BookOfBooks.getActiveItem(book), player);
        if (castResult) {
            return result;
        }
        return InteractionResultHolder.m_19100_((Object)player.m_21120_(interactionHand));
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, list, tooltipFlag);
        List<ItemStack> inventory = BookOfBooks.getInventory(itemStack);
        if (inventory.size() == 0) {
            list.add((Component)Component.m_237115_((String)"lore.scriptor.empty_book_1").m_130940_(ChatFormatting.GRAY));
            list.add((Component)Component.m_237115_((String)"lore.scriptor.empty_book_2").m_130940_(ChatFormatting.GRAY));
        }
        for (int i = 0; i < inventory.size(); ++i) {
            if (i == BookOfBooks.getActiveSlot(itemStack)) {
                list.add((Component)Component.m_237110_((String)"lore.scriptor.active_book", (Object[])new Object[]{inventory.get(i).m_41786_().getString()}).m_130940_(ChatFormatting.GREEN));
                continue;
            }
            list.add((Component)Component.m_237113_((String)inventory.get(i).m_41786_().getString()).m_130940_(ChatFormatting.GRAY));
        }
        list.add((Component)Component.m_237115_((String)"lore.scriptor.book_scroll").m_130940_(ChatFormatting.GRAY));
    }

    static List<ItemStack> getInventory(ItemStack book) {
        CompoundTag tag = book.m_41784_().m_128469_("scriptor");
        if (tag == null) {
            tag = new CompoundTag();
            book.m_41784_().m_128365_("scriptor", (Tag)tag);
        }
        if (!tag.m_128441_("items")) {
            tag.m_128365_("items", (Tag)new ListTag());
        }
        ListTag list = tag.m_128437_("items", 10);
        ArrayList<ItemStack> out = new ArrayList<ItemStack>();
        for (Tag item : list) {
            out.add(ItemStack.m_41712_((CompoundTag)((CompoundTag)item)));
        }
        return out;
    }

    static int getActiveSlot(ItemStack book) {
        CompoundTag tag = book.m_41737_("scriptor");
        if (tag == null) {
            return 0;
        }
        return tag.m_128451_("active_slot");
    }

    static ItemStack getActiveItem(ItemStack book) {
        int slot = BookOfBooks.getActiveSlot(book);
        List<ItemStack> inventory = BookOfBooks.getInventory(book);
        if (inventory.size() == 0) {
            return ItemStack.f_41583_;
        }
        if (inventory.size() <= slot) {
            return inventory.get(inventory.size() - 1);
        }
        return inventory.get(slot);
    }

    static void remove(ItemStack book, SlotAccess slotAccess) {
        ListTag list;
        if (!slotAccess.m_142196_().m_41619_()) {
            return;
        }
        CompoundTag tag = book.m_41784_().m_128469_("scriptor");
        if (tag == null) {
            tag = new CompoundTag();
            book.m_41784_().m_128365_("scriptor", (Tag)tag);
        }
        if (!tag.m_128441_("items")) {
            tag.m_128365_("items", (Tag)new ListTag());
        }
        if ((list = tag.m_128437_("items", 10)).size() == 0) {
            return;
        }
        Tag item = list.remove(list.size() - 1);
        slotAccess.m_142104_(ItemStack.m_41712_((CompoundTag)((CompoundTag)item)));
    }

    static void add(ItemStack book, ItemStack item) {
        if (item.m_41619_()) {
            return;
        }
        CompoundTag tag = book.m_41784_().m_128469_("scriptor");
        if (tag == null) {
            tag = new CompoundTag();
        }
        if (!tag.m_128441_("items")) {
            tag.m_128365_("items", (Tag)new ListTag());
        }
        ListTag list = tag.m_128437_("items", 10);
        CompoundTag compound = new CompoundTag();
        item.m_41739_(compound);
        list.add((Object)compound);
        item.m_41764_(0);
        book.m_41784_().m_128365_("scriptor", (Tag)tag);
    }

    @Override
    public boolean render(AbstractClientPlayer player, float i, float pitch, InteractionHand hand, float swingProgress, ItemStack itemStack, float readyProgress, PoseStack matrix, MultiBufferSource buffer, int lightLevel) {
        Item item = BookOfBooks.getActiveItem(player.m_21120_(hand)).m_41720_();
        if (item instanceof ItemWithCustomRenderer) {
            ItemWithCustomRenderer renderer = (ItemWithCustomRenderer)item;
            return renderer.render(player, i, pitch, hand, swingProgress, BookOfBooks.getActiveItem(player.m_21120_(hand)), readyProgress, matrix, buffer, lightLevel);
        }
        return false;
    }
}

