/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.ssblur.scriptor.ScriptorMod;
import com.ssblur.scriptor.events.network.EnchantNetwork;
import com.ssblur.scriptor.helpers.ComponentHelper;
import com.ssblur.scriptor.helpers.LimitedBookSerializer;
import com.ssblur.scriptor.helpers.SpellbookHelper;
import com.ssblur.scriptor.item.BookOfBooks;
import com.ssblur.scriptor.item.interfaces.ItemWithCustomRenderer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class Spellbook
extends WrittenBookItem
implements ItemWithCustomRenderer {
    public Spellbook(Item.Properties properties) {
        super(properties);
        SpellbookHelper.SPELLBOOKS.add((Item)this);
    }

    public Component m_7626_(ItemStack itemStack) {
        String string;
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null && !StringUtil.m_14408_((String)(string = tag.m_128461_("title")))) {
            return Component.m_237115_((String)string);
        }
        return super.m_7626_(itemStack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        InteractionResultHolder result = super.m_7203_(level, player, interactionHand);
        ItemStack item = player.m_21120_(interactionHand);
        boolean castResult = SpellbookHelper.castFromItem(item, player);
        if (castResult) {
            return result;
        }
        return InteractionResultHolder.m_19100_((Object)player.m_21120_(interactionHand));
    }

    public boolean m_142207_(ItemStack itemStack, Slot slot, ClickAction clickAction, Player player) {
        if (clickAction == ClickAction.SECONDARY && !slot.m_7993_().m_41619_() && !(slot.m_7993_().m_41720_() instanceof BookOfBooks)) {
            if (player.m_36335_().m_41519_((Item)this)) {
                return true;
            }
            Level level = player.m_9236_();
            if (!level.f_46443_) {
                return true;
            }
            if (player.m_7500_()) {
                EnchantNetwork.clientUseBookCreative(itemStack, slot.f_40219_);
            } else {
                EnchantNetwork.clientUseBook(slot.f_40219_);
            }
            return true;
        }
        return false;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, list, tooltipFlag);
        if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128469_("scriptor") != null) {
            CompoundTag tag = itemStack.m_41783_();
            CompoundTag scriptor = tag.m_128469_("scriptor");
            if (scriptor.m_128441_("identified")) {
                if (Screen.m_96638_()) {
                    for (String key : scriptor.m_128469_("identified").m_128431_()) {
                        String[] parts = key.split(":", 2);
                        if (parts.length == 2) {
                            ComponentHelper.updateTooltipWith(list, parts[0] + ".scriptor." + parts[1], new Object[0]);
                            continue;
                        }
                        ScriptorMod.LOGGER.error("Invalid Identify entry: " + key);
                    }
                } else {
                    list.add((Component)Component.m_237115_((String)"extra.scriptor.tome_identified"));
                }
            }
            ComponentHelper.addCommunityDisclaimer(list, itemStack);
        }
    }

    @Override
    public boolean render(AbstractClientPlayer player, float i, float pitch, InteractionHand hand, float swingProgress, ItemStack itemStack, float readyProgress, PoseStack matrix, MultiBufferSource buffer, int lightLevel) {
        matrix.m_85836_();
        boolean inRightHand = hand == InteractionHand.MAIN_HAND ^ player.m_5737_() == HumanoidArm.LEFT;
        int v = inRightHand ? 1 : -1;
        matrix.m_252880_((float)v * 0.56f, -0.52f + readyProgress * -0.6f, -0.72f);
        float g = Mth.m_14031_((float)(swingProgress * swingProgress * (float)Math.PI));
        matrix.m_252781_(Axis.f_252436_.m_252977_(i * (45.0f + g * -20.0f)));
        float h = Mth.m_14031_((float)(Mth.m_14116_((float)swingProgress) * (float)Math.PI));
        matrix.m_252781_(Axis.f_252403_.m_252977_(i * h * -20.0f));
        matrix.m_252781_(Axis.f_252529_.m_252977_(h * -80.0f));
        matrix.m_252781_(Axis.f_252436_.m_252977_(i * -45.0f));
        if (inRightHand) {
            matrix.m_85836_();
            matrix.m_85837_((double)-0.3f, (double)0.4f, 0.05);
            matrix.m_85841_(0.003f, 0.003f, 0.003f);
            matrix.m_252781_(Axis.f_252403_.m_252977_(183.0f));
            matrix.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            matrix.m_252781_(Axis.f_252529_.m_252977_(-48.5f));
            matrix.m_252781_(Axis.f_252436_.m_252977_(-25.0f));
            this.drawPage(itemStack, 0, matrix, buffer, lightLevel);
            matrix.m_85849_();
            matrix.m_85836_();
            matrix.m_252880_(-0.07f, 0.37f, 0.0f);
            matrix.m_85841_(0.003f, 0.003f, 0.003f);
            matrix.m_252781_(Axis.f_252403_.m_252977_(183.0f));
            matrix.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            matrix.m_252781_(Axis.f_252529_.m_252977_(-49.75f));
            matrix.m_252781_(Axis.f_252436_.m_252977_(20.0f));
            this.drawPage(itemStack, 1, matrix, buffer, lightLevel);
            matrix.m_85849_();
        } else {
            matrix.m_252880_(0.31f, 0.0f, 0.0f);
            matrix.m_85836_();
            matrix.m_85837_((double)-0.31f, (double)0.4f, 0.05);
            matrix.m_85841_(0.003f, 0.003f, 0.003f);
            matrix.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            matrix.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            matrix.m_252781_(Axis.f_252529_.m_252977_(-48.5f));
            matrix.m_252781_(Axis.f_252436_.m_252977_(-25.0f));
            this.drawPage(itemStack, 0, matrix, buffer, lightLevel);
            matrix.m_85849_();
            matrix.m_85836_();
            matrix.m_252880_(-0.07f, 0.38f, 0.0f);
            matrix.m_85841_(0.003f, 0.003f, 0.003f);
            matrix.m_252781_(Axis.f_252403_.m_252977_(183.0f));
            matrix.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            matrix.m_252781_(Axis.f_252529_.m_252977_(-49.75f));
            matrix.m_252781_(Axis.f_252436_.m_252977_(20.0f));
            this.drawPage(itemStack, 1, matrix, buffer, lightLevel);
            matrix.m_85849_();
        }
        matrix.m_85849_();
        return false;
    }

    public void drawPage(ItemStack itemStack, int page, PoseStack matrix, MultiBufferSource buffer, int lightLevel) {
        Font font = Minecraft.m_91087_().f_91062_;
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null && tag.m_128441_("pages")) {
            ListTag pages = tag.m_128437_("pages", 8);
            List sequence = new ArrayList();
            if (page >= pages.size()) {
                if (tag.m_128441_("title")) {
                    if (I18n.m_118936_((String)tag.m_128461_("title"))) {
                        sequence.addAll(font.m_92923_(FormattedText.m_130775_((String)I18n.m_118938_((String)tag.m_128461_("title"), (Object[])new Object[0])), 80));
                    } else {
                        sequence.addAll(font.m_92923_(FormattedText.m_130775_((String)tag.m_128461_("title")), 80));
                    }
                }
                if (tag.m_128441_("author")) {
                    sequence.addAll(font.m_92923_(FormattedText.m_130775_((String)("By " + tag.m_128461_("author"))), 80));
                }
            } else {
                sequence = font.m_92923_(FormattedText.m_130775_((String)LimitedBookSerializer.decodeText(pages.m_128778_(page))), 80);
            }
            for (int iter = 0; iter < sequence.size(); ++iter) {
                Minecraft.m_91087_().f_91062_.m_272191_((FormattedCharSequence)sequence.get(iter), -17.0f, (float)(-45 + 8 * iter), 0, false, matrix.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, lightLevel);
            }
        }
    }

    public boolean m_5812_(ItemStack itemStack) {
        return itemStack.m_41793_();
    }
}

