/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.item.casters;

import com.ssblur.scriptor.events.network.TraceNetwork;
import com.ssblur.scriptor.helpers.ComponentHelper;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.item.casters.CasterCrystal;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class CoordinateCasterCrystal
extends CasterCrystal {
    public CoordinateCasterCrystal(Item.Properties properties) {
        super(properties);
    }

    @Override
    public List<Targetable> getTargetables(ItemStack itemStack, Level level) {
        ArrayList<Targetable> list = new ArrayList<Targetable>();
        if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("coordinates")) {
            ListTag coords = itemStack.m_41783_().m_128437_("coordinates", 12);
            for (Tag tag : coords) {
                if (!(tag instanceof LongArrayTag)) continue;
                LongArrayTag array = (LongArrayTag)tag;
                list.add(new Targetable(level, new BlockPos(array.get(0).m_7047_(), array.get(1).m_7047_(), array.get(2).m_7047_())));
            }
        }
        return list;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, list, tooltipFlag);
        Font font = Minecraft.m_91087_().f_91062_;
        List<BlockPosDirection> coordinates = CoordinateCasterCrystal.getCoordinates(itemStack);
        for (BlockPosDirection pair : coordinates) {
            BlockPos coordinate = pair.getLeft();
            ComponentHelper.updateTooltipWith(ChatFormatting.GRAY, list, "lore.scriptor.coordinate_crystal_3", coordinate.m_123341_(), coordinate.m_123342_(), coordinate.m_123343_());
        }
        if (coordinates.isEmpty()) {
            list.add((Component)Component.m_237115_((String)"lore.scriptor.coordinate_crystal_1").m_130940_(ChatFormatting.GRAY));
        } else {
            if (coordinates.size() < 4) {
                list.add((Component)Component.m_237115_((String)"lore.scriptor.coordinate_crystal_2").m_130940_(ChatFormatting.GRAY));
            }
            list.add((Component)Component.m_237115_((String)"lore.scriptor.crystal_reset").m_130940_(ChatFormatting.GRAY));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        InteractionResultHolder result = super.m_7203_(level, player, interactionHand);
        if (!level.f_46443_) {
            ServerLevel server = (ServerLevel)level;
            ItemStack itemStack = player.m_21120_(interactionHand);
            TraceNetwork.requestTraceData(player, target -> CoordinateCasterCrystal.addCoordinate(itemStack, target.getTargetBlockPos(), target.getFacing()));
        }
        return result;
    }

    public static void addCoordinate(ItemStack itemStack, BlockPos pos, Direction direction) {
        ListTag list;
        CompoundTag tag = itemStack.m_41784_();
        if (!tag.m_128441_("coordinates")) {
            tag.m_128365_("coordinates", (Tag)new ListTag());
        }
        if ((list = tag.m_128437_("coordinates", 12)).size() < 4) {
            list.add((Object)new LongArrayTag(new long[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), direction.ordinal()}));
        }
    }

    public static List<BlockPosDirection> getCoordinates(ItemStack itemStack) {
        ArrayList<BlockPosDirection> list = new ArrayList<BlockPosDirection>();
        if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("coordinates")) {
            ListTag coords = itemStack.m_41783_().m_128437_("coordinates", 12);
            for (Tag tag : coords) {
                LongArrayTag array;
                if (!(tag instanceof LongArrayTag) || (array = (LongArrayTag)tag).size() != 4) continue;
                list.add(new BlockPosDirection(new BlockPos(array.get(0).m_7047_(), array.get(1).m_7047_(), array.get(2).m_7047_()), Direction.values()[array.get(3).m_7047_()]));
            }
        }
        return list;
    }

    public static class BlockPosDirection
    extends Pair<BlockPos, Direction> {
        BlockPos left;
        Direction right;

        public BlockPosDirection(BlockPos left, Direction right) {
            this.left = left;
            this.right = right;
        }

        public BlockPos getLeft() {
            return this.left;
        }

        public Direction getRight() {
            return this.right;
        }

        public Direction setValue(Direction value) {
            this.right = value;
            return this.right;
        }
    }
}

