/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.recipe;

import com.ssblur.scriptor.item.ScriptorItems;
import com.ssblur.scriptor.item.Spellbook;
import com.ssblur.scriptor.recipe.ScriptorRecipes;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class SpellbookCloningRecipe
extends CustomRecipe {
    public SpellbookCloningRecipe(ResourceLocation resourceLocation, CraftingBookCategory category) {
        super(resourceLocation, category);
    }

    public boolean matches(CraftingContainer container, Level level) {
        int paperCount = 0;
        int binderCount = 0;
        int spellbookCount = 0;
        for (int slot = 0; slot < container.m_6643_(); ++slot) {
            if (container.m_8020_(slot).m_41619_()) continue;
            if (container.m_8020_(slot).m_41720_() == Items.f_42516_) {
                ++paperCount;
                continue;
            }
            if (container.m_8020_(slot).m_41720_() instanceof Spellbook) {
                ItemStack item = container.m_8020_(slot);
                CompoundTag tag = item.m_41783_();
                if (tag == null || tag.m_128451_("generation") >= 2) continue;
                ++spellbookCount;
                continue;
            }
            if (container.m_8020_(slot).m_41720_() != ScriptorItems.SPELLBOOK_BINDER.get()) continue;
            ++binderCount;
        }
        return spellbookCount == 1 && binderCount == 1 && paperCount == 3;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess access) {
        ItemStack spellbook = ItemStack.f_41583_;
        for (int slot = 0; slot < container.m_6643_(); ++slot) {
            if (!(container.m_8020_(slot).m_41720_() instanceof Spellbook)) continue;
            spellbook = container.m_8020_(slot);
        }
        ItemStack copy = spellbook.m_41777_();
        CompoundTag tag = copy.m_41783_();
        if (tag != null) {
            tag.m_128405_("generation", tag.m_128451_("generation") + 1);
        }
        return copy;
    }

    public boolean m_8004_(int i, int j) {
        return i * j >= 6;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ScriptorRecipes.SPELLBOOK_CLONING.get();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer craftingContainer) {
        NonNullList nonNullList = NonNullList.m_122780_((int)craftingContainer.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonNullList.size(); ++i) {
            ItemStack itemStack = craftingContainer.m_8020_(i);
            if (itemStack.m_41720_().m_41470_()) {
                Item remainingItem = itemStack.m_41720_().m_41469_();
                if (remainingItem == null) continue;
                nonNullList.set(i, (Object)new ItemStack((ItemLike)remainingItem));
                continue;
            }
            if (!(itemStack.m_41720_() instanceof Spellbook)) continue;
            ItemStack itemStack2 = itemStack.m_41777_();
            itemStack2.m_41764_(itemStack.m_41613_());
            nonNullList.set(i, (Object)itemStack2);
        }
        return nonNullList;
    }
}

