/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.recipe;

import com.google.gson.JsonObject;
import com.ssblur.scriptor.item.ObfuscatedSpellbook;
import com.ssblur.scriptor.item.ScriptorItems;
import com.ssblur.scriptor.item.Spellbook;
import com.ssblur.scriptor.recipe.ScriptorRecipes;
import java.util.Objects;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class SpellbookDyeingRecipe
extends CustomRecipe {
    Item addition;
    Item result;

    public SpellbookDyeingRecipe(ResourceLocation resourceLocation, Item addition, Item result) {
        super(resourceLocation, CraftingBookCategory.MISC);
        this.result = result;
        this.addition = addition;
    }

    public SpellbookDyeingRecipe(ResourceLocation resourceLocation, String addition, String result) {
        super(resourceLocation, CraftingBookCategory.MISC);
        this.result = (Item)ScriptorItems.ITEMS.getRegistrar().get(new ResourceLocation(result));
        this.addition = (Item)ScriptorItems.ITEMS.getRegistrar().get(new ResourceLocation(addition));
    }

    public boolean matches(CraftingContainer container, Level level) {
        return container.m_216874_(itemStack -> itemStack.m_41720_() instanceof Spellbook && !(itemStack.m_41720_() instanceof ObfuscatedSpellbook)) && container.m_216874_(itemStack -> itemStack.m_41720_() == this.addition);
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess access) {
        ItemStack craftingBase = null;
        for (ItemStack item : container.m_280657_()) {
            if (!(item.m_41720_() instanceof Spellbook) || item.m_41720_() instanceof ObfuscatedSpellbook) continue;
            if (craftingBase == null) {
                craftingBase = item;
                continue;
            }
            return ItemStack.f_41583_;
        }
        if (craftingBase == null) {
            return ItemStack.f_41583_;
        }
        ItemStack craftingResult = new ItemStack((ItemLike)this.result);
        craftingResult.m_41751_(craftingBase.m_41783_());
        return craftingResult;
    }

    public boolean m_8004_(int i, int j) {
        return i * j >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ScriptorRecipes.SPELLBOOK_DYEING.get();
    }

    public static class Serializer
    implements RecipeSerializer<SpellbookDyeingRecipe> {
        public SpellbookDyeingRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            Item result = (Item)ScriptorItems.ITEMS.getRegistrar().get(new ResourceLocation(jsonObject.get("result").getAsString()));
            Item addition = (Item)ScriptorItems.ITEMS.getRegistrar().get(new ResourceLocation(jsonObject.get("addition").getAsString()));
            assert (result != null && addition != null);
            return new SpellbookDyeingRecipe(resourceLocation, addition, result);
        }

        public SpellbookDyeingRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf buf) {
            CompoundTag nbt = buf.m_130260_();
            assert (nbt != null);
            Item result = (Item)ScriptorItems.ITEMS.getRegistrar().get(new ResourceLocation(nbt.m_128461_("r")));
            Item base = (Item)ScriptorItems.ITEMS.getRegistrar().get(new ResourceLocation(nbt.m_128461_("b")));
            Item addition = (Item)ScriptorItems.ITEMS.getRegistrar().get(new ResourceLocation(nbt.m_128461_("a")));
            assert (result != null && base != null && addition != null);
            return new SpellbookDyeingRecipe(resourceLocation, addition, result);
        }

        public void toNetwork(FriendlyByteBuf buf, SpellbookDyeingRecipe craftingRecipe) {
            CompoundTag compound = new CompoundTag();
            compound.m_128359_("r", Objects.requireNonNull(ScriptorItems.ITEMS.getRegistrar().getId((Object)craftingRecipe.result)).toString());
            compound.m_128359_("a", Objects.requireNonNull(ScriptorItems.ITEMS.getRegistrar().getId((Object)craftingRecipe.addition)).toString());
            buf.m_130079_(compound);
        }
    }
}

