/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.registry;

import com.google.gson.JsonObject;
import com.ssblur.scriptor.helpers.generators.CommunityModeGenerator;
import com.ssblur.scriptor.helpers.generators.DebugGenerator;
import com.ssblur.scriptor.helpers.generators.MixedGroupGenerator;
import com.ssblur.scriptor.helpers.generators.StaticTokenGenerator;
import com.ssblur.scriptor.helpers.generators.TokenGenerator;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class TokenGeneratorRegistry {
    public static TokenGeneratorRegistry INSTANCE = new TokenGeneratorRegistry();
    public static final TokenGenerator.TokenGeneratorGenerator MIXED_GROUP = INSTANCE.registerGeneratorGenerator("mixed_groups", MixedGroupGenerator::new);
    public static final TokenGenerator.TokenGeneratorGenerator STATIC_TOKEN = INSTANCE.registerGeneratorGenerator("static_token", StaticTokenGenerator::new);
    public static final TokenGenerator.TokenGeneratorGenerator COMMUNITY = INSTANCE.registerGeneratorGenerator("community", CommunityModeGenerator::new);
    public static final TokenGenerator.TokenGeneratorGenerator DEBUG = INSTANCE.registerGeneratorGenerator("debug", DebugGenerator::new);
    HashMap<ResourceLocation, TokenGenerator> generators = new HashMap();
    HashMap<String, ResourceLocation> generatorBindings = new HashMap();
    HashMap<String, JsonObject> generatorBindingConfig = new HashMap();
    HashMap<String, TokenGenerator.TokenGeneratorGenerator> generatorGenerators = new HashMap();
    ResourceLocation defaultGenerator;

    public TokenGenerator.TokenGeneratorGenerator registerGeneratorGenerator(String key, TokenGenerator.TokenGeneratorGenerator generatorGenerator) {
        this.generatorGenerators.put(key, generatorGenerator);
        return generatorGenerator;
    }

    public TokenGenerator.TokenGeneratorGenerator getGeneratorGenerator(String key) {
        return this.generatorGenerators.get(key);
    }

    public void registerGenerator(ResourceLocation key, TokenGenerator generator) {
        this.generators.put(key, generator);
    }

    public TokenGenerator getGenerator(ResourceLocation key) {
        return this.generators.get(key);
    }

    public void registerBinding(String word, ResourceLocation generator, @Nullable JsonObject parameters) {
        this.generatorBindings.put(word, generator);
        this.generatorBindingConfig.put(word, parameters);
    }

    public ResourceLocation getBinding(String word) {
        return this.generatorBindings.getOrDefault(word, this.defaultGenerator);
    }

    public void registerDefaultGenerator(ResourceLocation generator) {
        this.defaultGenerator = generator;
    }

    public ResourceLocation getDefaultGenerator() {
        return this.defaultGenerator;
    }

    public String generateWord(String word, @Nullable JsonObject object) {
        return this.getGenerator(this.getBinding(word)).generateToken(word, object);
    }

    public String generateWord(String word) {
        return this.generateWord(word, this.generatorBindingConfig.get(word));
    }
}

