/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word;

import com.ssblur.scriptor.ScriptorMod;
import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Subject;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.effect.ScriptorEffects;
import com.ssblur.scriptor.events.network.ParticleNetwork;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.word.PartialSpell;
import com.ssblur.scriptor.word.descriptor.AfterCastDescriptor;
import com.ssblur.scriptor.word.descriptor.CastDescriptor;
import com.ssblur.scriptor.word.descriptor.focus.FocusDescriptor;
import com.ssblur.scriptor.word.descriptor.target.TargetDescriptor;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public record Spell(Subject subject, PartialSpell[] spells) {
    void castOnTargets(Targetable caster, List<Targetable> targets) {
        assert (this.spells.length >= 1);
        for (PartialSpell spell : this.spells) {
            List<Targetable> spellTargets = targets;
            Targetable spellCaster = caster;
            for (Descriptor descriptor : spell.deduplicatedDescriptors()) {
                if (descriptor instanceof TargetDescriptor) {
                    TargetDescriptor cast = (TargetDescriptor)((Object)descriptor);
                    spellTargets = cast.modifyTargets(spellTargets);
                }
                if (!(descriptor instanceof FocusDescriptor)) continue;
                FocusDescriptor focus = (FocusDescriptor)((Object)descriptor);
                spellCaster = focus.modifyFocus(spellCaster);
            }
            for (Targetable target : spellTargets) {
                spell.action().apply(spellCaster, target, spell.deduplicatedDescriptors());
            }
        }
    }

    public CompletableFuture<List<Targetable>> createFuture(Targetable caster) {
        CompletableFuture<List<Targetable>> targetFuture = new CompletableFuture<List<Targetable>>();
        targetFuture.whenComplete((targets, throwable) -> {
            if (throwable != null) {
                ScriptorMod.LOGGER.warn(throwable);
            } else {
                this.castOnTargets(caster, (List<Targetable>)targets);
            }
        });
        return targetFuture;
    }

    public void cast(Targetable caster) {
        LivingEntity living;
        Object entity;
        Entity entity2;
        if (caster instanceof EntityTargetable && (entity2 = ((EntityTargetable)(entity = (EntityTargetable)caster)).getTargetEntity()) instanceof LivingEntity && (living = (LivingEntity)entity2).m_21023_((MobEffect)ScriptorEffects.MUTE.get())) {
            if (living instanceof Player) {
                Player player = (Player)living;
                player.m_213846_((Component)Component.m_237115_((String)"extra.scriptor.mute"));
            }
            return;
        }
        assert (this.spells.length >= 1);
        for (Object descriptor : Arrays.stream(this.spells).flatMap(it -> Arrays.stream(it.deduplicatedDescriptors())).toList()) {
            CastDescriptor cast;
            if (descriptor instanceof CastDescriptor && (cast = (CastDescriptor)descriptor).cannotCast(caster)) {
                EntityTargetable entityTargetable;
                Entity entity3;
                if (caster instanceof EntityTargetable && (entity3 = (entityTargetable = (EntityTargetable)caster).getTargetEntity()) instanceof Player) {
                    Player player = (Player)entity3;
                    player.m_213846_((Component)Component.m_237115_((String)"extra.scriptor.condition_not_met"));
                }
                if (!caster.getLevel().f_46443_) {
                    ParticleNetwork.fizzle(caster.getLevel(), caster.getTargetBlockPos());
                }
                return;
            }
            if (!(descriptor instanceof FocusDescriptor)) continue;
            FocusDescriptor focus = (FocusDescriptor)descriptor;
            caster = focus.modifyFocus(caster);
        }
        CompletableFuture<List<Targetable>> targetFuture = this.subject.getTargets(caster, this);
        for (Descriptor descriptor : Arrays.stream(this.spells).flatMap(it -> Arrays.stream(it.deduplicatedDescriptors())).toList()) {
            if (!(descriptor instanceof AfterCastDescriptor)) continue;
            AfterCastDescriptor afterCastDescriptor = (AfterCastDescriptor)((Object)descriptor);
            afterCastDescriptor.afterCast(caster);
        }
        Targetable finalCaster = caster.getFinalTargetable();
        if (targetFuture.isDone()) {
            try {
                List<Targetable> targets2 = targetFuture.get();
                this.castOnTargets(finalCaster, targets2);
            }
            catch (InterruptedException | ExecutionException e) {
                ScriptorMod.LOGGER.warn((Object)e);
            }
        } else {
            targetFuture.whenComplete((targets, throwable) -> {
                if (throwable != null) {
                    ScriptorMod.LOGGER.warn(throwable);
                } else {
                    this.castOnTargets(finalCaster, (List<Targetable>)targets);
                }
            });
        }
    }

    public void cast(Targetable caster, Targetable ... targetables) {
        this.castOnTargets(caster, Arrays.stream(targetables).toList());
    }

    public double cost() {
        double sum = 0.0;
        double scalar = 1.0;
        double discount = 0.0;
        double subCount = 0.0;
        double sub = 0.0;
        block5: for (Word d : this.words()) {
            Word.Cost cost = d.cost();
            switch (cost.type()) {
                case ADDITIVE: {
                    if (sum < 0.0) {
                        subCount += 1.0;
                        sub += cost.cost();
                        continue block5;
                    }
                    sum += cost.cost();
                    continue block5;
                }
                case MULTIPLICATIVE: {
                    scalar *= cost.cost();
                    continue block5;
                }
                case ADDITIVE_POST: {
                    discount += cost.cost();
                }
            }
        }
        if (subCount > 0.0) {
            double squeeze = 0.5;
            double denominator = Math.pow(squeeze, subCount);
            denominator = squeeze - denominator;
            denominator = 1.0 - denominator;
            sum -= (sub /= denominator);
        }
        double out = sum * scalar;
        return out += discount;
    }

    private Word[] words() {
        int length = 1;
        int index = 1;
        for (PartialSpell spell : this.spells) {
            length += spell.deduplicatedDescriptors().length + 1;
        }
        Word[] words = new Word[length];
        words[0] = this.subject;
        for (PartialSpell spell : this.spells) {
            words[index] = spell.action();
            Descriptor[] descriptors = spell.deduplicatedDescriptors();
            System.arraycopy(descriptors, 0, words, ++index, descriptors.length);
            index += descriptors.length;
        }
        return words;
    }

    public Descriptor[] deduplicatedDescriptorsForSubjects() {
        assert (this.spells.length >= 1);
        return this.spells[0].deduplicatedDescriptors();
    }

    public Descriptor[] deduplicatedDescriptorsForAccumulation() {
        int length = 0;
        int index = 0;
        for (PartialSpell spell : this.spells) {
            length += spell.deduplicatedDescriptors().length;
        }
        Descriptor[] descriptors = new Descriptor[length];
        for (PartialSpell spell : this.spells) {
            System.arraycopy(spell.deduplicatedDescriptors(), 0, descriptors, index, descriptors.length);
            index += descriptors.length;
        }
        return descriptors;
    }
}

