/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word.action;

import com.ssblur.scriptor.api.word.Action;
import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.helpers.ItemTargetableHelper;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.word.descriptor.power.StrengthDescriptor;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BreakBlockAction
extends Action {
    static HashMap<String, Integer> toolLevelsList = new HashMap();

    @Override
    public void apply(Targetable caster, Targetable targetable, Descriptor[] descriptors) {
        if (targetable.getLevel().f_46443_) {
            return;
        }
        double strength = 1.0;
        for (Descriptor d : descriptors) {
            if (!(d instanceof StrengthDescriptor)) continue;
            StrengthDescriptor strengthDescriptor = (StrengthDescriptor)((Object)d);
            strength += strengthDescriptor.strengthModifier();
        }
        ItemStack itemTarget = ItemTargetableHelper.getTargetItemStack(targetable, false, itemStack -> !itemStack.m_41619_() && itemStack.m_41763_());
        if (!itemTarget.m_41619_() && itemTarget.m_41763_()) {
            itemTarget.m_41721_(itemTarget.m_41773_() + (int)Math.round(strength));
            return;
        }
        BlockPos pos = targetable.getOffsetBlockPos();
        BlockState state = targetable.getLevel().m_8055_(pos);
        if (state.m_60734_().m_155943_() < 0.0f) {
            return;
        }
        Level level = targetable.getLevel();
        Set tags = state.m_60734_().arch$holder().m_203616_().collect(Collectors.toSet());
        int neededStrength = 0;
        for (TagKey tag : tags) {
            if (!toolLevelsList.containsKey(tag.f_203868_().toString())) continue;
            neededStrength = toolLevelsList.get(tag.f_203868_().toString());
        }
        if (strength > (double)neededStrength) {
            if (caster instanceof EntityTargetable) {
                EntityTargetable entityTargetable = (EntityTargetable)caster;
                Entity entity = entityTargetable.getTargetEntity();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    state.m_60734_().m_6240_(level, player, pos, state, level.m_7702_(pos), new ItemStack((ItemLike)Items.f_42395_));
                }
                level.m_7740_(pos, false, entityTargetable.getTargetEntity(), (int)Math.round(strength));
            } else {
                level.m_7740_(pos, true, null, (int)Math.round(strength));
            }
        }
    }

    @Override
    public Word.Cost cost() {
        return new Word.Cost(1.0, Word.COSTTYPE.ADDITIVE);
    }

    static {
        toolLevelsList.put("minecraft:needs_stone_tool", 1);
        toolLevelsList.put("minecraft:needs_iron_tool", 2);
        toolLevelsList.put("minecraft:needs_diamond_tool", 3);
        toolLevelsList.put("minecraft:needs_netherite_tool", 4);
    }
}

