/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word.action;

import com.ssblur.scriptor.api.word.Action;
import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.block.ScriptorBlocks;
import com.ssblur.scriptor.blockentity.LightBlockEntity;
import com.ssblur.scriptor.color.CustomColors;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.word.descriptor.duration.DurationDescriptor;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class LightAction
extends Action {
    @Override
    public void apply(Targetable caster, Targetable targetable, Descriptor[] descriptors) {
        EntityTargetable entityTargetable;
        Entity entity;
        int seconds = 6;
        for (Descriptor d : descriptors) {
            if (!(d instanceof DurationDescriptor)) continue;
            DurationDescriptor durationDescriptor = (DurationDescriptor)((Object)d);
            seconds = (int)((double)seconds + 3.0 * durationDescriptor.durationModifier());
        }
        if (targetable instanceof EntityTargetable && (entity = (entityTargetable = (EntityTargetable)targetable).getTargetEntity()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.m_7292_(new MobEffectInstance(MobEffects.f_19619_, seconds));
            return;
        }
        int color = CustomColors.getColor(descriptors);
        BlockPos pos = targetable.getTargetBlockPos();
        Level level = targetable.getLevel();
        if (!level.m_8055_(pos).m_247087_()) {
            return;
        }
        BlockState blockState2 = ((Block)ScriptorBlocks.LIGHT.get()).m_49966_();
        level.m_7731_(pos, blockState2, 11);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof LightBlockEntity) {
            LightBlockEntity lightBlockEntity = (LightBlockEntity)blockEntity;
            lightBlockEntity.setColor(color);
        }
        level.m_5594_(null, pos, SoundEvents.f_12642_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
    }

    @Override
    public Word.Cost cost() {
        return new Word.Cost(2.0, Word.COSTTYPE.ADDITIVE);
    }
}

