/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word.action.bound;

import com.ssblur.scriptor.api.word.Action;
import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.color.CustomColors;
import com.ssblur.scriptor.helpers.ItemTargetableHelper;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.word.descriptor.duration.DurationDescriptor;
import com.ssblur.scriptor.word.descriptor.power.StrengthDescriptor;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class BoundToolAction
extends Action {
    Supplier<Item> item;

    public BoundToolAction(Supplier<Item> item) {
        this.item = item;
    }

    @Override
    public void apply(Targetable caster, Targetable targetable, Descriptor[] descriptors) {
        float strength = 6.0f;
        double duration = 4.0;
        for (Descriptor d : descriptors) {
            if (d instanceof StrengthDescriptor) {
                StrengthDescriptor strengthDescriptor = (StrengthDescriptor)((Object)d);
                strength += (float)strengthDescriptor.strengthModifier();
            }
            if (!(d instanceof DurationDescriptor)) continue;
            DurationDescriptor durationDescriptor = (DurationDescriptor)((Object)d);
            duration += durationDescriptor.durationModifier();
        }
        ItemStack itemStack = new ItemStack((ItemLike)this.item.get());
        CompoundTag tag = new CompoundTag();
        CompoundTag display = new CompoundTag();
        display.m_128405_("color", CustomColors.getColor(descriptors));
        tag.m_128365_("display", (Tag)display);
        CompoundTag scriptor = new CompoundTag();
        scriptor.m_128356_("expire", caster.getLevel().m_46467_() + (long)Math.floor(duration * 80.0));
        scriptor.m_128350_("efficiency", strength * 0.666f);
        tag.m_128365_("scriptor", (Tag)scriptor);
        itemStack.m_41751_(tag);
        ItemTargetableHelper.depositItemStack(targetable, itemStack);
    }

    @Override
    public Word.Cost cost() {
        return new Word.Cost(6.0, Word.COSTTYPE.ADDITIVE);
    }
}

