/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word.action.potions;

import com.ssblur.scriptor.api.word.Action;
import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.word.descriptor.duration.DurationDescriptor;
import com.ssblur.scriptor.word.descriptor.power.StrengthDescriptor;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class PotionAction
extends Action {
    MobEffect mobEffect;
    double durationScale;
    double strengthScale;
    Word.Cost cost;

    public PotionAction(MobEffect mobEffect, double durationScale, double strengthScale, Word.Cost cost) {
        this.mobEffect = mobEffect;
        this.durationScale = durationScale;
        this.strengthScale = strengthScale;
        this.cost = cost;
    }

    @Override
    public void apply(Targetable caster, Targetable targetable, Descriptor[] descriptors) {
        EntityTargetable entityTargetable;
        Entity entity;
        double strength = 0.0;
        double duration = 2.0;
        for (Descriptor d : descriptors) {
            if (d instanceof StrengthDescriptor) {
                StrengthDescriptor strengthDescriptor = (StrengthDescriptor)((Object)d);
                strength += strengthDescriptor.strengthModifier();
            }
            if (!(d instanceof DurationDescriptor)) continue;
            DurationDescriptor durationDescriptor = (DurationDescriptor)((Object)d);
            duration += durationDescriptor.durationModifier();
        }
        strength = Math.max(strength, 0.0);
        strength *= this.strengthScale;
        duration *= this.durationScale;
        if (targetable instanceof EntityTargetable && (entity = (entityTargetable = (EntityTargetable)targetable).getTargetEntity()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.m_7292_(new MobEffectInstance(this.mobEffect, (int)Math.round(duration), (int)Math.floor(strength)));
        } else {
            this.applyToPosition(caster, targetable, descriptors, strength, duration);
        }
    }

    public void applyToPosition(Targetable caster, Targetable targetable, Descriptor[] descriptors, double strength, double duration) {
    }

    @Override
    public Word.Cost cost() {
        return this.cost;
    }
}

