/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word.descriptor.target;

import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.word.descriptor.target.TargetDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;

public class OffsetDescriptor
extends Descriptor
implements TargetDescriptor {
    List<BiConsumer<Targetable, List<Targetable>>> transforms = new ArrayList<BiConsumer<Targetable, List<Targetable>>>();

    @Override
    public Word.Cost cost() {
        return new Word.Cost(1.25, Word.COSTTYPE.MULTIPLICATIVE);
    }

    @Override
    public List<Targetable> modifyTargets(List<Targetable> targetables) {
        ArrayList<Targetable> output = new ArrayList<Targetable>();
        for (Targetable targetable : targetables) {
            for (BiConsumer<Targetable, List<Targetable>> transform : this.transforms) {
                transform.accept(targetable, output);
            }
        }
        return output;
    }

    @Override
    public boolean replacesSubjectCost() {
        return false;
    }

    @Override
    public boolean allowsDuplicates() {
        return true;
    }

    public OffsetDescriptor right() {
        this.transforms.add((targetable, output) -> {
            targetable = targetable.simpleCopy();
            Direction direction = targetable.getFacing();
            Vec3 pos = targetable.getTargetPos();
            pos = direction.m_122434_() != Direction.Axis.Y ? pos.m_82549_(Vec3.m_82528_((Vec3i)direction.m_122427_().m_122436_())) : pos.m_82549_(Vec3.m_82528_((Vec3i)Direction.EAST.m_122436_()));
            targetable.setTargetPos(pos);
            output.add(targetable);
        });
        return this;
    }

    public OffsetDescriptor left() {
        this.transforms.add((targetable, output) -> {
            targetable = targetable.simpleCopy();
            Direction direction = targetable.getFacing();
            Vec3 pos = targetable.getTargetPos();
            pos = direction.m_122434_() != Direction.Axis.Y ? pos.m_82549_(Vec3.m_82528_((Vec3i)direction.m_122428_().m_122436_())) : pos.m_82549_(Vec3.m_82528_((Vec3i)Direction.WEST.m_122436_()));
            targetable.setTargetPos(pos);
            output.add(targetable);
        });
        return this;
    }

    public OffsetDescriptor up() {
        this.transforms.add((targetable, output) -> {
            targetable = targetable.simpleCopy();
            Direction direction = targetable.getFacing();
            Vec3 pos = targetable.getTargetPos();
            pos = direction.m_122434_() != Direction.Axis.Y ? pos.m_82549_(Vec3.m_82528_((Vec3i)Direction.UP.m_122436_())) : pos.m_82549_(Vec3.m_82528_((Vec3i)Direction.NORTH.m_122436_()));
            targetable.setTargetPos(pos);
            output.add(targetable);
        });
        return this;
    }

    public OffsetDescriptor down() {
        this.transforms.add((targetable, output) -> {
            targetable = targetable.simpleCopy();
            Direction direction = targetable.getFacing();
            Vec3 pos = targetable.getTargetPos();
            pos = direction.m_122434_() != Direction.Axis.Y ? pos.m_82549_(Vec3.m_82528_((Vec3i)Direction.DOWN.m_122436_())) : pos.m_82549_(Vec3.m_82528_((Vec3i)Direction.SOUTH.m_122436_()));
            targetable.setTargetPos(pos);
            output.add(targetable);
        });
        return this;
    }

    public OffsetDescriptor forward() {
        this.transforms.add((targetable, output) -> {
            targetable = targetable.simpleCopy();
            Direction direction = targetable.getFacing();
            Vec3 pos = targetable.getTargetPos();
            pos = pos.m_82549_(Vec3.m_82528_((Vec3i)direction.m_122436_()));
            targetable.setTargetPos(pos);
            output.add(targetable);
        });
        return this;
    }

    public OffsetDescriptor backwards() {
        this.transforms.add((targetable, output) -> {
            targetable = targetable.simpleCopy();
            Direction direction = targetable.getFacing();
            Vec3 pos = targetable.getTargetPos();
            pos = pos.m_82549_(Vec3.m_82528_((Vec3i)direction.m_122424_().m_122436_()));
            targetable.setTargetPos(pos);
            output.add(targetable);
        });
        return this;
    }

    public OffsetDescriptor duplicate() {
        this.transforms.add((targetable, output) -> output.add(targetable.simpleCopy()));
        return this;
    }
}

