/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word.subject;

import com.ssblur.scriptor.api.word.Subject;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.color.CustomColors;
import com.ssblur.scriptor.events.network.ParticleNetwork;
import com.ssblur.scriptor.events.network.TraceNetwork;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.LecternTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.word.Spell;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class HitscanSubject
extends Subject {
    @Override
    public CompletableFuture<List<Targetable>> getTargets(Targetable caster, Spell spell) {
        EntityTargetable entityTargetable;
        Entity entity;
        CompletableFuture<List<Targetable>> result = new CompletableFuture<List<Targetable>>();
        if (caster instanceof EntityTargetable && (entity = (entityTargetable = (EntityTargetable)caster).getTargetEntity()) instanceof Player) {
            Player player = (Player)entity;
            TraceNetwork.requestExtendedTraceData(player, target -> {
                int color = CustomColors.getColor(spell.deduplicatedDescriptorsForSubjects());
                ParticleNetwork.magicTrail(target.getLevel(), color, player.m_146892_(), target.getTargetPos());
                result.complete(List.of(target));
            });
        } else if (caster instanceof LecternTargetable) {
            BlockPos pos = caster.getTargetBlockPos().m_121945_(caster.getFacing());
            Vec3i normal = caster.getFacing().m_122436_();
            int x = normal.m_123341_() * 19;
            int z = normal.m_123343_() * 19;
            List entities = caster.getLevel().m_45976_(LivingEntity.class, AABB.m_165882_((Vec3)new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), (double)(1 + x), (double)1.0, (double)(1 + z)));
            if (entities.isEmpty()) {
                x = caster.getFacing().m_122429_();
                z = caster.getFacing().m_122431_();
                for (int i = 0; i < 19; ++i) {
                    if (caster.getLevel().m_8055_(pos.m_7918_(x * i, 0, z * i)).m_60795_()) continue;
                    result.complete(List.of(new Targetable(caster.getLevel(), pos.m_7918_(x * i, 0, z * i))));
                    return result;
                }
            } else {
                result.complete(entities.stream().map(living -> new EntityTargetable((Entity)living)).toList());
            }
        } else {
            result.complete(List.of(caster.simpleCopy()));
        }
        return result;
    }

    @Override
    public Word.Cost cost() {
        return new Word.Cost(8.0, Word.COSTTYPE.ADDITIVE);
    }
}

