/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word.subject;

import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Subject;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.color.CustomColors;
import com.ssblur.scriptor.entity.ScriptorEntities;
import com.ssblur.scriptor.entity.ScriptorProjectile;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.word.Spell;
import com.ssblur.scriptor.word.descriptor.SpeedDescriptor;
import com.ssblur.scriptor.word.descriptor.duration.DurationDescriptor;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.Vec3;

public class ProjectileSubject
extends Subject {
    @Override
    public Word.Cost cost() {
        return new Word.Cost(3.0, Word.COSTTYPE.ADDITIVE);
    }

    @Override
    public CompletableFuture<List<Targetable>> getTargets(Targetable caster, Spell spell) {
        CompletableFuture<List<Targetable>> future = new CompletableFuture<List<Targetable>>();
        int color = CustomColors.getColor(spell.deduplicatedDescriptorsForSubjects());
        double duration = 12.0;
        double speed = 1.0;
        for (Descriptor d : spell.deduplicatedDescriptorsForSubjects()) {
            Object descriptor;
            if (d instanceof DurationDescriptor) {
                descriptor = (DurationDescriptor)((Object)d);
                duration += descriptor.durationModifier();
            }
            if (!(d instanceof SpeedDescriptor)) continue;
            descriptor = (SpeedDescriptor)((Object)d);
            speed *= descriptor.speedModifier();
        }
        speed *= 0.8;
        ScriptorProjectile projectile = (ScriptorProjectile)((EntityType)ScriptorEntities.PROJECTILE_TYPE.get()).m_20615_(caster.getLevel());
        assert (projectile != null);
        if (caster instanceof EntityTargetable) {
            EntityTargetable entityTargetable = (EntityTargetable)caster;
            Entity entity = entityTargetable.getTargetEntity();
            projectile.m_146884_(entity.m_146892_());
            projectile.m_20256_(entity.m_20154_().m_82541_().m_82490_(speed));
            projectile.setOwner(entity);
        } else {
            projectile.m_146884_(caster.getTargetPos());
            Vec3i normal = caster.getFacing().m_122436_();
            projectile.m_20256_(new Vec3((double)normal.m_123341_(), (double)normal.m_123342_(), (double)normal.m_123343_()).m_82490_(speed));
        }
        projectile.setOrigin(caster.getOrigin());
        projectile.setDuration((int)Math.round(10.0 * duration));
        projectile.setColor(color);
        projectile.setCompletable(future);
        caster.getLevel().m_7967_((Entity)projectile);
        return future;
    }
}

