/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word.subject;

import com.ssblur.scriptor.api.word.Subject;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.block.ScriptorBlocks;
import com.ssblur.scriptor.blockentity.RuneBlockEntity;
import com.ssblur.scriptor.color.CustomColors;
import com.ssblur.scriptor.events.network.TraceNetwork;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.word.Spell;
import com.ssblur.scriptor.word.subject.InventorySubject;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RuneSubject
extends Subject
implements InventorySubject {
    @Override
    public CompletableFuture<List<Targetable>> getTargets(Targetable caster, Spell spell) {
        EntityTargetable entityTargetable;
        Entity entity;
        CompletableFuture<List<Targetable>> result = new CompletableFuture<List<Targetable>>();
        if (caster instanceof EntityTargetable && (entity = (entityTargetable = (EntityTargetable)caster).getTargetEntity()) instanceof Player) {
            Player player = (Player)entity;
            TraceNetwork.requestTraceData(player, target -> {
                int color = CustomColors.getColor(spell.deduplicatedDescriptorsForSubjects());
                BlockPos pos = target.getTargetBlockPos();
                Level level = caster.getLevel();
                if (!level.m_8055_(pos).m_247087_()) {
                    return;
                }
                level.m_46597_(pos, ((Block)ScriptorBlocks.RUNE.get()).m_49966_());
                BlockEntity entity = level.m_7702_(pos);
                if (entity instanceof RuneBlockEntity) {
                    RuneBlockEntity runeBlockEntity = (RuneBlockEntity)entity;
                    runeBlockEntity.owner = player;
                    runeBlockEntity.future = result;
                    runeBlockEntity.spell = spell;
                    runeBlockEntity.color = color;
                    runeBlockEntity.m_6596_();
                }
            });
        } else {
            int color = CustomColors.getColor(spell.deduplicatedDescriptorsForSubjects());
            BlockPos pos = caster.getTargetBlockPos();
            Level level = caster.getLevel();
            if (!level.m_8055_(pos).m_247087_()) {
                result.complete(List.of());
                return result;
            }
            level.m_46597_(pos, ((Block)ScriptorBlocks.RUNE.get()).m_49966_());
            BlockEntity entity2 = level.m_7702_(pos);
            if (entity2 instanceof RuneBlockEntity) {
                RuneBlockEntity runeBlockEntity = (RuneBlockEntity)entity2;
                runeBlockEntity.future = result;
                runeBlockEntity.spell = spell;
                runeBlockEntity.color = color;
                runeBlockEntity.m_6596_();
            }
        }
        return result;
    }

    @Override
    public Word.Cost cost() {
        return new Word.Cost(1.0, Word.COSTTYPE.ADDITIVE);
    }

    @Override
    public void castOnItem(Spell spell, Player player, ItemStack slot) {
    }
}

