/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.block;

import com.mojang.serialization.MapCodec;
import com.ssblur.scriptor.blockentity.CastingLecternBlockEntity;
import com.ssblur.scriptor.blockentity.ScriptorBlockEntities;
import com.ssblur.scriptor.helpers.PlayerItemHelper;
import com.ssblur.scriptor.item.books.Spellbook;
import com.ssblur.scriptor.item.casters.CasterCrystal;
import com.ssblur.unfocused.extension.BlockEntityTypeExtension;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 02\u00020\u00012\u00020\u0002:\u00010B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J@\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001c\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\n0\u001bH\u0014J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J6\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H!0 \"\b\b\u0000\u0010!*\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H!0#H\u0016J(\u0010$\u001a\u00020%2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010&\u001a\u00020'2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020)H\u0016J0\u0010*\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020-H\u0014J\u0010\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010/H\u0014\u00a8\u00061"}, d2={"Lcom/ssblur/scriptor/block/CastingLecternBlock;", "Lnet/minecraft/world/level/block/HorizontalDirectionalBlock;", "Lnet/minecraft/world/level/block/EntityBlock;", "<init>", "()V", "useItemOn", "Lnet/minecraft/world/ItemInteractionResult;", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "level", "Lnet/minecraft/world/level/Level;", "blockPos", "Lnet/minecraft/core/BlockPos;", "player", "Lnet/minecraft/world/entity/player/Player;", "interactionHand", "Lnet/minecraft/world/InteractionHand;", "blockHitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "getStateForPlacement", "blockPlaceContext", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "getTicker", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "T", "blockEntityType", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "blockGetter", "Lnet/minecraft/world/level/BlockGetter;", "collisionContext", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "onRemove", "blockState2", "drops", "", "codec", "Lcom/mojang/serialization/MapCodec;", "Companion", "scriptor"})
public final class CastingLecternBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final DirectionProperty FACING;

    public CastingLecternBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)Blocks.SPRUCE_PLANKS)).noOcclusion());
    }

    @NotNull
    public ItemInteractionResult useItemOn(@NotNull ItemStack itemStack, @NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult blockHitResult) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)interactionHand, (String)"interactionHand");
        Intrinsics.checkNotNullParameter((Object)blockHitResult, (String)"blockHitResult");
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!level.isClientSide && blockEntity instanceof CastingLecternBlockEntity) {
            if (itemStack.isEmpty()) {
                if (!((CastingLecternBlockEntity)blockEntity).getSpellbook().isEmpty()) {
                    PlayerItemHelper.INSTANCE.addOrDropItem(player, ((CastingLecternBlockEntity)blockEntity).getSpellbook());
                    ((CastingLecternBlockEntity)blockEntity).setSpellbook(ItemStack.EMPTY);
                } else {
                    PlayerItemHelper.INSTANCE.addOrDropItem(player, ((CastingLecternBlockEntity)blockEntity).getFocus());
                    ((CastingLecternBlockEntity)blockEntity).setFocus(ItemStack.EMPTY);
                }
            } else if (itemStack.getItem() instanceof Spellbook) {
                PlayerItemHelper.INSTANCE.addOrDropItem(player, ((CastingLecternBlockEntity)blockEntity).getSpellbook());
                ((CastingLecternBlockEntity)blockEntity).setSpellbook(itemStack.copyWithCount(1));
                itemStack.shrink(1);
            } else if (itemStack.getItem() instanceof CasterCrystal) {
                PlayerItemHelper.INSTANCE.addOrDropItem(player, ((CastingLecternBlockEntity)blockEntity).getFocus());
                ((CastingLecternBlockEntity)blockEntity).setFocus(itemStack.copyWithCount(1));
                itemStack.shrink(1);
            }
        }
        return ItemInteractionResult.CONSUME;
    }

    @NotNull
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext blockPlaceContext) {
        Intrinsics.checkNotNullParameter((Object)blockPlaceContext, (String)"blockPlaceContext");
        Object object = this.defaultBlockState().setValue((Property)FACING, (Comparable)blockPlaceContext.getHorizontalDirection().getOpposite());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{FACING};
        builder.add(propertyArray);
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        BlockEntity blockEntity = BlockEntityTypeExtension.INSTANCE.create(ScriptorBlockEntities.INSTANCE.getCASTING_LECTERN(), blockPos, blockState);
        Intrinsics.checkNotNull((Object)blockEntity);
        return blockEntity;
    }

    @NotNull
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> blockEntityType) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter(blockEntityType, (String)"blockEntityType");
        return CastingLecternBlock::getTicker$lambda$0;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull CollisionContext collisionContext) {
        VoxelShape voxelShape;
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)blockGetter, (String)"blockGetter");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)collisionContext, (String)"collisionContext");
        Direction direction = (Direction)blockState.getValue((Property)LecternBlock.FACING);
        switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                VoxelShape voxelShape2 = LecternBlock.SHAPE_NORTH;
                voxelShape = voxelShape2;
                Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"SHAPE_NORTH");
                break;
            }
            case 2: {
                VoxelShape voxelShape3 = LecternBlock.SHAPE_SOUTH;
                voxelShape = voxelShape3;
                Intrinsics.checkNotNullExpressionValue((Object)voxelShape3, (String)"SHAPE_SOUTH");
                break;
            }
            case 3: {
                VoxelShape voxelShape4 = LecternBlock.SHAPE_EAST;
                voxelShape = voxelShape4;
                Intrinsics.checkNotNullExpressionValue((Object)voxelShape4, (String)"SHAPE_EAST");
                break;
            }
            case 4: {
                VoxelShape voxelShape5 = LecternBlock.SHAPE_WEST;
                voxelShape = voxelShape5;
                Intrinsics.checkNotNullExpressionValue((Object)voxelShape5, (String)"SHAPE_WEST");
                break;
            }
            default: {
                VoxelShape voxelShape6 = LecternBlock.SHAPE_COMMON;
                voxelShape = voxelShape6;
                Intrinsics.checkNotNullExpressionValue((Object)voxelShape6, (String)"SHAPE_COMMON");
            }
        }
        return voxelShape;
    }

    protected void onRemove(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState2, boolean drops) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState2, (String)"blockState2");
        if (!level.isClientSide && !blockState.is(blockState2.getBlock()) && level.getBlockEntity(blockPos) instanceof CastingLecternBlockEntity) {
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type com.ssblur.scriptor.blockentity.CastingLecternBlockEntity");
            CastingLecternBlockEntity lectern = (CastingLecternBlockEntity)blockEntity;
            Iterator iterator = lectern.getItems().iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                ItemStack item = (ItemStack)iterator2.next();
                ItemEntity entity = new ItemEntity(level, (double)((float)blockPos.getX() + 0.5f), (double)((float)blockPos.getY() + 0.5f), (double)((float)blockPos.getZ() + 0.5f), item);
                level.addFreshEntity((Entity)entity);
            }
        }
        super.onRemove(blockState, level, blockPos, blockState2, drops);
    }

    @NotNull
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        MapCodec mapCodec = MapCodec.unit((Object)((Object)this));
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"unit(...)");
        return mapCodec;
    }

    private static final void getTicker$lambda$0(Level tickerLevel, BlockPos pos, BlockState state, BlockEntity entity) {
        Intrinsics.checkNotNull((Object)tickerLevel);
        Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.entity.BlockEntity");
        CastingLecternBlockEntity.Companion.tick(tickerLevel, entity);
    }

    static {
        DirectionProperty directionProperty = HorizontalDirectionalBlock.FACING;
        Intrinsics.checkNotNullExpressionValue((Object)directionProperty, (String)"FACING");
        FACING = directionProperty;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/ssblur/scriptor/block/CastingLecternBlock$Companion;", "", "<init>", "()V", "FACING", "Lnet/minecraft/world/level/block/state/properties/DirectionProperty;", "getFACING", "()Lnet/minecraft/world/level/block/state/properties/DirectionProperty;", "scriptor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DirectionProperty getFACING() {
            return FACING;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

