/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.block;

import com.ssblur.unfocused.extension.BlockExtension;
import com.ssblur.unfocused.extension.BlockPropertiesExtension;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/ssblur/scriptor/block/MagicBlock;", "Lnet/minecraft/world/level/block/Block;", "color", "Lnet/minecraft/world/item/DyeColor;", "<init>", "(Lnet/minecraft/world/item/DyeColor;)V", "getColor", "()Lnet/minecraft/world/item/DyeColor;", "clientInit", "", "scriptor"})
public final class MagicBlock
extends Block {
    @NotNull
    private final DyeColor color;

    public MagicBlock(@NotNull DyeColor color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).strength(0.3f).sound(SoundType.GLASS).noOcclusion().mapColor(color);
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"mapColor(...)");
        super(BlockPropertiesExtension.INSTANCE.isEphemeral(properties));
        this.color = color;
        try {
            this.clientInit();
        }
        catch (NoSuchMethodError noSuchMethodError) {
        }
    }

    @NotNull
    public final DyeColor getColor() {
        return this.color;
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void clientInit() {
        Block block = this;
        RenderType renderType = RenderType.translucent();
        Intrinsics.checkNotNullExpressionValue((Object)renderType, (String)"translucent(...)");
        BlockExtension.INSTANCE.renderType(block, renderType);
    }
}

