/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.blockentity;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.ssblur.scriptor.block.PhasedBlock;
import com.ssblur.scriptor.block.ScriptorBlocks;
import com.ssblur.scriptor.blockentity.ScriptorBlockEntities;
import com.ssblur.scriptor.config.ScriptorConfig;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u0000 .2\u00020\u0001:\u0001.B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\"H\u0016J\u0010\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020\t2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010)\u001a\u00020 2\u0006\u0010(\u001a\u00020\t2\u0006\u0010%\u001a\u00020&H\u0014R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0011\u0010*\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006/"}, d2={"Lcom/ssblur/scriptor/blockentity/PhasedBlockBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "data", "Lnet/minecraft/nbt/CompoundTag;", "getData", "()Lnet/minecraft/nbt/CompoundTag;", "setData", "(Lnet/minecraft/nbt/CompoundTag;)V", "phasedBlockState", "getPhasedBlockState", "()Lnet/minecraft/world/level/block/state/BlockState;", "setPhasedBlockState", "(Lnet/minecraft/world/level/block/state/BlockState;)V", "countdown", "", "getCountdown", "()I", "setCountdown", "(I)V", "created", "", "getCreated", "()J", "setCreated", "(J)V", "tick", "", "getUpdatePacket", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "getUpdateTag", "provider", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "tag", "saveAdditional", "anim", "", "getAnim", "()F", "Companion", "scriptor"})
public final class PhasedBlockBlockEntity
extends BlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private CompoundTag data;
    @Nullable
    private BlockState phasedBlockState;
    private int countdown;
    private long created;
    private static boolean INVERT_DO_NOT_PHASE;
    public static final long ANIM_DURATION = 5L;
    public static final float ANIM_FLOOR = 0.2f;
    public static final float ANIM_DIFF = 0.8f;

    public PhasedBlockBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super((BlockEntityType)ScriptorBlockEntities.INSTANCE.getPHASED_BLOCK().get(), blockPos, blockState);
        this.created = -1L;
        this.countdown = -1;
    }

    @Nullable
    public final CompoundTag getData() {
        return this.data;
    }

    public final void setData(@Nullable CompoundTag compoundTag) {
        this.data = compoundTag;
    }

    @Nullable
    public final BlockState getPhasedBlockState() {
        return this.phasedBlockState;
    }

    public final void setPhasedBlockState(@Nullable BlockState blockState) {
        this.phasedBlockState = blockState;
    }

    public final int getCountdown() {
        return this.countdown;
    }

    public final void setCountdown(int n) {
        this.countdown = n;
    }

    public final long getCreated() {
        return this.created;
    }

    public final void setCreated(long l) {
        this.created = l;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void tick() {
        int n = this.countdown;
        this.countdown = n + -1;
        if (this.countdown > 0) return;
        if (this.level == null) return;
        if (this.phasedBlockState == null) return;
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        if (level.isClientSide) {
            return;
        }
        Level level2 = this.level;
        Intrinsics.checkNotNull((Object)level2);
        BlockPos blockPos = this.getBlockPos();
        BlockState blockState = this.phasedBlockState;
        Intrinsics.checkNotNull((Object)blockState);
        level2.setBlockAndUpdate(blockPos, blockState);
        if (this.data != null) {
            Level level3 = this.level;
            Intrinsics.checkNotNull((Object)level3);
            if (!level3.isClientSide) {
                BlockPos blockPos2 = this.getBlockPos();
                BlockState blockState2 = this.phasedBlockState;
                Intrinsics.checkNotNull((Object)blockState2);
                CompoundTag compoundTag = this.data;
                Intrinsics.checkNotNull((Object)compoundTag);
                Level level4 = this.level;
                Intrinsics.checkNotNull((Object)level4);
                BlockEntity entity = BlockEntity.loadStatic((BlockPos)blockPos2, (BlockState)blockState2, (CompoundTag)compoundTag, (HolderLookup.Provider)((HolderLookup.Provider)level4.registryAccess()));
                if (entity == null) return;
                Level level5 = this.level;
                Intrinsics.checkNotNull((Object)level5);
                level5.setBlockEntity(entity);
                return;
            }
        }
        Level level6 = this.level;
        Intrinsics.checkNotNull((Object)level6);
        level6.removeBlockEntity(this.getBlockPos());
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return (Packet)ClientboundBlockEntityDataPacket.create((BlockEntity)this, PhasedBlockBlockEntity::getUpdatePacket$lambda$0);
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        CompoundTag tag = super.getUpdateTag(provider);
        Intrinsics.checkNotNull((Object)tag);
        this.saveAdditional(tag, provider);
        return tag;
    }

    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        super.loadAdditional(tag, provider);
        this.data = tag.getCompound("data");
        Tag state = tag.get("blockState");
        BlockState.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)state).result().ifPresent(arg_0 -> PhasedBlockBlockEntity.loadAdditional$lambda$2(arg_0 -> PhasedBlockBlockEntity.loadAdditional$lambda$1(this, arg_0), arg_0));
        this.setChanged();
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        super.saveAdditional(tag, provider);
        if (this.data != null) {
            CompoundTag compoundTag = this.data;
            Intrinsics.checkNotNull((Object)compoundTag);
            tag.put("data", (Tag)compoundTag);
        }
        try {
            DataResult state = BlockState.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.phasedBlockState);
            state.result().ifPresent(arg_0 -> PhasedBlockBlockEntity.saveAdditional$lambda$4(arg_0 -> PhasedBlockBlockEntity.saveAdditional$lambda$3(tag, arg_0), arg_0));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public final float getAnim() {
        if (this.level == null) {
            return 0.2f;
        }
        if (this.created == -1L) {
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            this.created = level.getGameTime();
        }
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        long anim = level.getGameTime() - this.created;
        anim = Math.min(anim, 5L);
        return (float)anim / (float)5L * 0.8f + 0.2f;
    }

    private static final CompoundTag getUpdatePacket$lambda$0(BlockEntity entity, RegistryAccess provider) {
        return entity.getUpdateTag((HolderLookup.Provider)provider);
    }

    private static final Unit loadAdditional$lambda$1(PhasedBlockBlockEntity this$0, Pair result) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        this$0.phasedBlockState = (BlockState)result.getFirst();
        return Unit.INSTANCE;
    }

    private static final void loadAdditional$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit saveAdditional$lambda$3(CompoundTag $tag, Tag result) {
        Intrinsics.checkNotNullParameter((Object)$tag, (String)"$tag");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        $tag.put("blockState", result);
        return Unit.INSTANCE;
    }

    private static final void saveAdditional$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @JvmStatic
    @JvmOverloads
    public static final void phase(@NotNull Level level, @NotNull BlockPos pos, int duration) {
        Companion.phase(level, pos, duration);
    }

    @JvmStatic
    @JvmOverloads
    public static final void phase(@NotNull Level level, @NotNull BlockPos pos) {
        Companion.phase(level, pos);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u000f\u001a\u00020\u0010\"\n\b\u0000\u0010\u0011*\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u0002H\u0011\u00a2\u0006\u0002\u0010\u0014J\"\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0007J\u001e\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u001e\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/ssblur/scriptor/blockentity/PhasedBlockBlockEntity$Companion;", "", "<init>", "()V", "INVERT_DO_NOT_PHASE", "", "getINVERT_DO_NOT_PHASE", "()Z", "setINVERT_DO_NOT_PHASE", "(Z)V", "ANIM_DURATION", "", "ANIM_FLOOR", "", "ANIM_DIFF", "tick", "", "T", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "entity", "(Lnet/minecraft/world/level/block/entity/BlockEntity;)V", "phase", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "duration", "", "invalidForPhasing", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "phasable", "scriptor"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getINVERT_DO_NOT_PHASE() {
            return INVERT_DO_NOT_PHASE;
        }

        public final void setINVERT_DO_NOT_PHASE(boolean bl) {
            INVERT_DO_NOT_PHASE = bl;
        }

        public final <T extends BlockEntity> void tick(T entity) {
            if (entity instanceof PhasedBlockBlockEntity) {
                ((PhasedBlockBlockEntity)entity).tick();
            }
        }

        @JvmStatic
        @JvmOverloads
        public final void phase(@NotNull Level level, @NotNull BlockPos pos, int duration) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            BlockEntity entity = level.getBlockEntity(pos);
            if (entity instanceof PhasedBlockBlockEntity) {
                ((PhasedBlockBlockEntity)entity).setCountdown(Math.max(duration, ((PhasedBlockBlockEntity)entity).getCountdown()));
                return;
            }
            BlockState state = level.getBlockState(pos);
            Intrinsics.checkNotNull((Object)state);
            if (this.invalidForPhasing(state, level, pos)) {
                return;
            }
            if (level.isClientSide && this.phasable(state, level, pos) != this.getINVERT_DO_NOT_PHASE()) {
                return;
            }
            if (!level.isClientSide && this.phasable(state, level, pos) != ((Boolean)ScriptorConfig.INSTANCE.getINVERT_DO_NOT_PHASE().invoke()).booleanValue()) {
                return;
            }
            CompoundTag data = null;
            if (entity != null) {
                data = entity.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess());
            }
            level.removeBlockEntity(pos);
            BlockState newState = ((Block)ScriptorBlocks.INSTANCE.getPHASED_BLOCK().get()).defaultBlockState();
            newState = level.getFluidState(pos).is(Fluids.EMPTY) ? (BlockState)newState.setValue((Property)PhasedBlock.Companion.getWATERLOGGED(), (Comparable)Boolean.valueOf(false)) : (BlockState)newState.setValue((Property)PhasedBlock.Companion.getWATERLOGGED(), (Comparable)Boolean.valueOf(true));
            level.setBlockAndUpdate(pos, newState);
            BlockState blockState = newState;
            Intrinsics.checkNotNull((Object)blockState);
            PhasedBlockBlockEntity newEntity = new PhasedBlockBlockEntity(pos, blockState);
            newEntity.level = level;
            newEntity.setPhasedBlockState(state);
            newEntity.setCountdown(duration);
            if (data != null) {
                newEntity.setData(data);
            }
            level.setBlockEntity((BlockEntity)newEntity);
            level.sendBlockUpdated(pos, newState, newState, 3);
        }

        public static /* synthetic */ void phase$default(Companion companion, Level level, BlockPos blockPos, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 5;
            }
            companion.phase(level, blockPos, n);
        }

        public final boolean invalidForPhasing(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            if (state.liquid() || state.isAir()) {
                return true;
            }
            if (state.getCollisionShape((BlockGetter)level, pos).isEmpty()) {
                return true;
            }
            return state.getDestroySpeed((BlockGetter)level, pos) < 0.0f;
        }

        public final boolean phasable(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            return state.is(ScriptorBlocks.INSTANCE.getDO_NOT_PHASE());
        }

        @JvmStatic
        @JvmOverloads
        public final void phase(@NotNull Level level, @NotNull BlockPos pos) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            com.ssblur.scriptor.blockentity.PhasedBlockBlockEntity$Companion.phase$default(this, level, pos, 0, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

