/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.blockentity;

import com.ssblur.scriptor.blockentity.ScriptorBlockEntities;
import com.ssblur.scriptor.color.interfaces.Colorable;
import com.ssblur.scriptor.data.saved_data.DictionarySavedData;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.word.Spell;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 D2\u00020\u00012\u00020\u0002:\u0001DB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u00105\u001a\n 7*\u0004\u0018\u00010606H\u0016\u00a2\u0006\u0002\u00108J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0016J\u0018\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0016J\u0018\u0010@\u001a\u00020>2\u0006\u0010?\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0014J\u0006\u0010A\u001a\u00020>J\u0010\u0010B\u001a\u00020>2\u0006\u0010C\u001a\u00020*H\u0016R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R(\u0010!\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0#\u0018\u00010\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u000200X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104\u00a8\u0006E"}, d2={"Lcom/ssblur/scriptor/blockentity/RuneBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lcom/ssblur/scriptor/color/interfaces/Colorable;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "owner", "Lnet/minecraft/world/entity/Entity;", "getOwner", "()Lnet/minecraft/world/entity/Entity;", "setOwner", "(Lnet/minecraft/world/entity/Entity;)V", "ownerUUID", "Ljava/util/UUID;", "getOwnerUUID", "()Ljava/util/UUID;", "setOwnerUUID", "(Ljava/util/UUID;)V", "spell", "Lcom/ssblur/scriptor/word/Spell;", "getSpell", "()Lcom/ssblur/scriptor/word/Spell;", "setSpell", "(Lcom/ssblur/scriptor/word/Spell;)V", "spellText", "", "getSpellText", "()Ljava/lang/String;", "setSpellText", "(Ljava/lang/String;)V", "future", "Ljava/util/concurrent/CompletableFuture;", "", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "getFuture", "()Ljava/util/concurrent/CompletableFuture;", "setFuture", "(Ljava/util/concurrent/CompletableFuture;)V", "runeColor", "", "getRuneColor", "()I", "setRuneColor", "(I)V", "unloadedSpell", "", "getUnloadedSpell", "()Z", "setUnloadedSpell", "(Z)V", "getUpdatePacket", "Lnet/minecraft/network/protocol/game/ClientboundBlockEntityDataPacket;", "kotlin.jvm.PlatformType", "()Lnet/minecraft/network/protocol/game/ClientboundBlockEntityDataPacket;", "getUpdateTag", "Lnet/minecraft/nbt/CompoundTag;", "provider", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "", "tag", "saveAdditional", "tick", "setColor", "color", "Companion", "scriptor"})
public final class RuneBlockEntity
extends BlockEntity
implements Colorable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Entity owner;
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private Spell spell;
    @Nullable
    private String spellText;
    @Nullable
    private CompletableFuture<List<Targetable>> future;
    private int runeColor;
    private boolean unloadedSpell;

    public RuneBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super((BlockEntityType)ScriptorBlockEntities.INSTANCE.getRUNE().get(), blockPos, blockState);
        this.unloadedSpell = true;
    }

    @Nullable
    public final Entity getOwner() {
        return this.owner;
    }

    public final void setOwner(@Nullable Entity entity) {
        this.owner = entity;
    }

    @Nullable
    public final UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public final void setOwnerUUID(@Nullable UUID uUID) {
        this.ownerUUID = uUID;
    }

    @Nullable
    public final Spell getSpell() {
        return this.spell;
    }

    public final void setSpell(@Nullable Spell spell) {
        this.spell = spell;
    }

    @Nullable
    public final String getSpellText() {
        return this.spellText;
    }

    public final void setSpellText(@Nullable String string) {
        this.spellText = string;
    }

    @Nullable
    public final CompletableFuture<List<Targetable>> getFuture() {
        return this.future;
    }

    public final void setFuture(@Nullable CompletableFuture<List<Targetable>> completableFuture) {
        this.future = completableFuture;
    }

    public final int getRuneColor() {
        return this.runeColor;
    }

    public final void setRuneColor(int n) {
        this.runeColor = n;
    }

    public final boolean getUnloadedSpell() {
        return this.unloadedSpell;
    }

    public final void setUnloadedSpell(boolean bl) {
        this.unloadedSpell = bl;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        CompoundTag tag = super.getUpdateTag(provider);
        tag.putInt("scriptor:color", this.runeColor);
        Intrinsics.checkNotNull((Object)tag);
        return tag;
    }

    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        super.loadAdditional(tag, provider);
        this.runeColor = tag.getInt("scriptor:color");
        if (tag.contains("spell")) {
            this.spellText = tag.getString("spell");
        } else {
            this.unloadedSpell = false;
        }
        if (tag.contains("owner")) {
            this.ownerUUID = UUID.fromString(tag.getString("owner"));
        }
        this.setChanged();
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        super.saveAdditional(tag, provider);
        if (this.level instanceof ServerLevel && this.spell != null) {
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            DictionarySavedData dictionarySavedData = DictionarySavedData.Companion.computeIfAbsent((ServerLevel)level);
            Spell spell = this.spell;
            Intrinsics.checkNotNull((Object)spell);
            tag.putString("spell", dictionarySavedData.generate(spell));
        }
        if (this.owner != null) {
            Entity entity = this.owner;
            Intrinsics.checkNotNull((Object)entity);
            tag.putString("owner", entity.getStringUUID());
        } else if (this.ownerUUID != null) {
            tag.putString("owner", String.valueOf(this.ownerUUID));
        }
        tag.putInt("scriptor:color", this.runeColor);
    }

    /*
     * Unable to fully structure code
     */
    public final void tick() {
        block20: {
            block21: {
                block19: {
                    block18: {
                        block17: {
                            if (this.level == null) break block17;
                            v0 = this.level;
                            Intrinsics.checkNotNull((Object)v0);
                            if (!v0.isClientSide) break block18;
                        }
                        return;
                    }
                    v1 = this.level;
                    Intrinsics.checkNotNull((Object)v1);
                    if (v1.getGameTime() % (long)40 == 0L && this.owner == null && this.ownerUUID != null) {
                        v2 = this.level;
                        Intrinsics.checkNotNull((Object)v2);
                        v3 = this.ownerUUID;
                        Intrinsics.checkNotNull((Object)v3);
                        if (v2.getPlayerByUUID(v3) != null) {
                            v4 = this.level;
                            Intrinsics.checkNotNull((Object)v4);
                            v5 = this.ownerUUID;
                            Intrinsics.checkNotNull((Object)v5);
                            this.owner = (Entity)v4.getPlayerByUUID(v5);
                            v6 = this.level;
                            Intrinsics.checkNotNull((Object)v6, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                            spell = DictionarySavedData.Companion.computeIfAbsent((ServerLevel)v6).parse(this.spellText);
                            if (spell != null) {
                                if (this.owner != null) {
                                    v7 = this.owner;
                                    Intrinsics.checkNotNull((Object)v7);
                                    v8 = spell.createFuture(new EntityTargetable(v7));
                                } else {
                                    v9 = this.level;
                                    Intrinsics.checkNotNull((Object)v9);
                                    v10 = this.getBlockPos();
                                    Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"getBlockPos(...)");
                                    v8 = this.future = spell.createFuture(new Targetable(v9, v10));
                                }
                            }
                        }
                    }
                    if (this.future == null) break block19;
                    v11 = this.future;
                    Intrinsics.checkNotNull(v11);
                    if (!v11.isDone()) break block20;
                }
                if (this.spell == null) break block21;
                if (this.owner == null) ** GOTO lbl-1000
                v12 = this.owner;
                Intrinsics.checkNotNull((Object)v12);
                if (v12.isAlive()) {
                    v13 = this.spell;
                    Intrinsics.checkNotNull((Object)v13);
                    v14 = this.owner;
                    Intrinsics.checkNotNull((Object)v14);
                    v15 = v13.createFuture(new EntityTargetable(v14));
                } else lbl-1000:
                // 2 sources

                {
                    v16 = this.spell;
                    Intrinsics.checkNotNull((Object)v16);
                    v17 = this.level;
                    Intrinsics.checkNotNull((Object)v17);
                    v18 = this.getBlockPos();
                    Intrinsics.checkNotNullExpressionValue((Object)v18, (String)"getBlockPos(...)");
                    v15 = v16.createFuture(new Targetable(v17, v18));
                }
                this.future = v15;
                break block20;
            }
            if (this.spellText != null) {
                v19 = this.level;
                Intrinsics.checkNotNull((Object)v19, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                this.spell = DictionarySavedData.Companion.computeIfAbsent((ServerLevel)v19).parse(this.spellText);
                if (this.spell != null) {
                    if (this.owner == null) {
                        v20 = this.spell;
                        Intrinsics.checkNotNull((Object)v20);
                        v21 = this.level;
                        Intrinsics.checkNotNull((Object)v21);
                        v22 = this.worldPosition;
                        Intrinsics.checkNotNullExpressionValue((Object)v22, (String)"worldPosition");
                        v23 = v20.createFuture(new Targetable(v21, v22));
                    } else {
                        v24 = this.spell;
                        Intrinsics.checkNotNull((Object)v24);
                        v25 = this.owner;
                        Intrinsics.checkNotNull((Object)v25);
                        v23 = v24.createFuture(new EntityTargetable(v25));
                    }
                    this.future = v23;
                }
            }
        }
        xMin = this.worldPosition.getX() >= 0 ? 0.2 : -0.8;
        zMin = this.worldPosition.getZ() >= 0 ? 0.2 : -0.8;
        xMax = this.worldPosition.getX() >= 0 ? 0.6 : -0.4;
        zMax = this.worldPosition.getZ() >= 0 ? 0.6 : -0.4;
        box = AABB.of((BoundingBox)BoundingBox.fromCorners((Vec3i)new Vec3i((int)((double)this.worldPosition.getX() + xMin), (int)((double)this.worldPosition.getY() + 0.0), (int)((double)this.worldPosition.getZ() + zMin)), (Vec3i)new Vec3i((int)((double)this.worldPosition.getX() + xMax), (int)((double)this.worldPosition.getY() + 0.0625), (int)((double)this.worldPosition.getZ() + zMax))));
        v26 = this.level;
        Intrinsics.checkNotNull((Object)v26);
        entities = v26.getEntities(null, box);
        if (entities.size() > 0) {
            targets = new ArrayList<E>();
            for (Entity entity : entities) {
                Intrinsics.checkNotNull((Object)entity);
                targets.add(new EntityTargetable(entity));
            }
            if (this.future != null) {
                v27 = this.future;
                Intrinsics.checkNotNull(v27);
                v27.complete(targets);
            }
            v28 = this.level;
            Intrinsics.checkNotNull((Object)v28);
            v28.removeBlock(this.worldPosition, true);
        }
    }

    @Override
    public void setColor(int color) {
        this.runeColor = color;
        this.setChanged();
        if (this.level != null) {
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\u00020\u0005\"\n\b\u0000\u0010\u0006*\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u0002H\u0006\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/ssblur/scriptor/blockentity/RuneBlockEntity$Companion;", "", "<init>", "()V", "tick", "", "T", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "level", "Lnet/minecraft/world/level/Level;", "entity", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/entity/BlockEntity;)V", "scriptor"})
    public static final class Companion {
        private Companion() {
        }

        public final <T extends BlockEntity> void tick(@NotNull Level level, T entity) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            if (level.isClientSide) {
                return;
            }
            if (entity instanceof RuneBlockEntity) {
                ((RuneBlockEntity)entity).tick();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

