/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.blockentity.renderers;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.ssblur.scriptor.ScriptorMod;
import com.ssblur.scriptor.blockentity.RuneBlockEntity;
import com.ssblur.scriptor.color.CustomColors;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J8\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/ssblur/scriptor/blockentity/renderers/RuneBlockEntityRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Lcom/ssblur/scriptor/blockentity/RuneBlockEntity;", "context", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "render", "", "rune", "tickDelta", "", "matrix", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffers", "Lnet/minecraft/client/renderer/MultiBufferSource;", "light", "", "j", "Companion", "scriptor"})
public final class RuneBlockEntityRenderer
implements BlockEntityRenderer<RuneBlockEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static ResourceLocation magicCircle;
    @NotNull
    private static ResourceLocation emptyCircle;
    @NotNull
    private static RenderType magicLayer;
    @NotNull
    private static RenderType emptyLayer;

    public RuneBlockEntityRenderer(@Nullable BlockEntityRendererProvider.Context context) {
    }

    public void render(@NotNull RuneBlockEntity rune, float tickDelta, @NotNull PoseStack matrix, @NotNull MultiBufferSource buffers, int light, int j) {
        Intrinsics.checkNotNullParameter((Object)rune, (String)"rune");
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        Intrinsics.checkNotNullParameter((Object)buffers, (String)"buffers");
        if (rune.getLevel() == null) {
            return;
        }
        matrix.pushPose();
        int n = rune.getRuneColor();
        Level level = rune.getLevel();
        Intrinsics.checkNotNull((Object)level);
        int c = CustomColors.INSTANCE.getColor(n, (float)level.getGameTime() + tickDelta);
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        int r = (c & 0xFF0000) >> 16;
        int g = (c & 0xFF00) >> 8;
        int b = c & 0xFF;
        float yo = 0.0625f;
        matrix.translate(0.0f, yo, 0.0f);
        Matrix4f pose = matrix.last().pose();
        VertexConsumer buffer = buffers.getBuffer(magicLayer);
        int cycle = 240;
        Level level2 = rune.getLevel();
        Intrinsics.checkNotNull((Object)level2);
        double rot = level2.getGameTime() % (long)cycle;
        rot = (rot + (double)tickDelta) / (double)cycle * (double)2 * Math.PI;
        double R = 0.5;
        float x = (float)(R * Math.cos(rot));
        float y = (float)(R * Math.sin(rot));
        buffer.addVertex(pose, x + 0.5f, 0.0f, y + 0.5f).setColor(r, g, b, 255).setUv(0.0f, 1.0f).setLight(0xF000F0);
        x = (float)(R * Math.cos(rot += 1.5707963267948966));
        y = (float)(R * Math.sin(rot));
        buffer.addVertex(pose, x + 0.5f, 0.0f, y + 0.5f).setColor(r, g, b, 255).setUv(1.0f, 1.0f).setLight(0xF000F0);
        x = (float)(R * Math.cos(rot += 1.5707963267948966));
        y = (float)(R * Math.sin(rot));
        buffer.addVertex(pose, x + 0.5f, 0.0f, y + 0.5f).setColor(r, g, b, 255).setUv(1.0f, 0.0f).setLight(0xF000F0);
        x = (float)(R * Math.cos(rot += 1.5707963267948966));
        y = (float)(R * Math.sin(rot));
        buffer.addVertex(pose, x + 0.5f, 0.0f, y + 0.5f).setColor(r, g, b, 255).setUv(0.0f, 0.0f).setLight(0xF000F0);
        buffer = buffers.getBuffer(emptyLayer);
        R = 0.2;
        x = (float)(R * Math.cos(rot *= -1.0));
        y = (float)(R * Math.sin(rot));
        buffer.addVertex(pose, x + 0.5f, 0.0f, y + 0.5f).setColor(r, g, b, 255).setUv(0.0f, 1.0f).setLight(0xF000F0);
        x = (float)(R * Math.cos(rot += 1.5707963267948966));
        y = (float)(R * Math.sin(rot));
        buffer.addVertex(pose, x + 0.5f, 0.0f, y + 0.5f).setColor(r, g, b, 255).setUv(1.0f, 1.0f).setLight(0xF000F0);
        x = (float)(R * Math.cos(rot += 1.5707963267948966));
        y = (float)(R * Math.sin(rot));
        buffer.addVertex(pose, x + 0.5f, 0.0f, y + 0.5f).setColor(r, g, b, 255).setUv(1.0f, 0.0f).setLight(0xF000F0);
        x = (float)(R * Math.cos(rot += 1.5707963267948966));
        y = (float)(R * Math.sin(rot));
        buffer.addVertex(pose, x + 0.5f, 0.0f, y + 0.5f).setColor(r, g, b, 255).setUv(0.0f, 0.0f).setLight(0xF000F0);
        matrix.popPose();
    }

    static {
        ResourceLocation resourceLocation = ScriptorMod.INSTANCE.location("textures/entity/magic_circle.png");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
        magicCircle = resourceLocation;
        ResourceLocation resourceLocation2 = ScriptorMod.INSTANCE.location("textures/entity/empty_circle.png");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"location(...)");
        emptyCircle = resourceLocation2;
        RenderType.CompositeRenderType compositeRenderType = RenderType.create((String)"scriptor:rune", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)64, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(magicCircle, false, false)).setCullState(new RenderStateShard.CullStateShard(false)).setLightmapState(new RenderStateShard.LightmapStateShard(true)).setShaderState(RenderStateShard.POSITION_COLOR_TEX_LIGHTMAP_SHADER).createCompositeState(true));
        Intrinsics.checkNotNullExpressionValue((Object)compositeRenderType, (String)"create(...)");
        magicLayer = (RenderType)compositeRenderType;
        RenderType.CompositeRenderType compositeRenderType2 = RenderType.create((String)"scriptor:circle", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)64, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(emptyCircle, false, false)).setCullState(new RenderStateShard.CullStateShard(false)).setLightmapState(new RenderStateShard.LightmapStateShard(true)).setShaderState(RenderStateShard.POSITION_COLOR_TEX_LIGHTMAP_SHADER).createCompositeState(true));
        Intrinsics.checkNotNullExpressionValue((Object)compositeRenderType2, (String)"create(...)");
        emptyLayer = (RenderType)compositeRenderType2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lcom/ssblur/scriptor/blockentity/renderers/RuneBlockEntityRenderer$Companion;", "", "<init>", "()V", "magicCircle", "Lnet/minecraft/resources/ResourceLocation;", "getMagicCircle", "()Lnet/minecraft/resources/ResourceLocation;", "setMagicCircle", "(Lnet/minecraft/resources/ResourceLocation;)V", "emptyCircle", "getEmptyCircle", "setEmptyCircle", "magicLayer", "Lnet/minecraft/client/renderer/RenderType;", "getMagicLayer", "()Lnet/minecraft/client/renderer/RenderType;", "setMagicLayer", "(Lnet/minecraft/client/renderer/RenderType;)V", "emptyLayer", "getEmptyLayer", "setEmptyLayer", "scriptor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getMagicCircle() {
            return magicCircle;
        }

        public final void setMagicCircle(@NotNull ResourceLocation resourceLocation) {
            Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"<set-?>");
            magicCircle = resourceLocation;
        }

        @NotNull
        public final ResourceLocation getEmptyCircle() {
            return emptyCircle;
        }

        public final void setEmptyCircle(@NotNull ResourceLocation resourceLocation) {
            Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"<set-?>");
            emptyCircle = resourceLocation;
        }

        @NotNull
        public final RenderType getMagicLayer() {
            return magicLayer;
        }

        public final void setMagicLayer(@NotNull RenderType renderType) {
            Intrinsics.checkNotNullParameter((Object)renderType, (String)"<set-?>");
            magicLayer = renderType;
        }

        @NotNull
        public final RenderType getEmptyLayer() {
            return emptyLayer;
        }

        public final void setEmptyLayer(@NotNull RenderType renderType) {
            Intrinsics.checkNotNullParameter((Object)renderType, (String)"<set-?>");
            emptyLayer = renderType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

