/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.color;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.ssblur.scriptor.color.CustomColors;
import com.ssblur.scriptor.color.interfaces.ColorableBlock;
import com.ssblur.scriptor.registry.colorable.ColorableBlockRegistry;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001a\u0010\u0012\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\u001aH\u0016J\u0016\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0006J\u0006\u0010\u001f\u001a\u00020\u0013R&\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lcom/ssblur/scriptor/color/DyeColorableBlock;", "Lcom/ssblur/scriptor/color/interfaces/ColorableBlock;", "<init>", "()V", "blocks", "Lcom/google/common/collect/BiMap;", "Lnet/minecraft/world/item/DyeColor;", "Lnet/minecraft/world/level/block/Block;", "getBlocks", "()Lcom/google/common/collect/BiMap;", "setBlocks", "(Lcom/google/common/collect/BiMap;)V", "random", "Ljava/util/Random;", "getRandom", "()Ljava/util/Random;", "setRandom", "(Ljava/util/Random;)V", "setColor", "", "color", "", "level", "Lnet/minecraft/world/level/Level;", "blockPos", "Lnet/minecraft/core/BlockPos;", "Lnet/minecraft/world/item/ItemStack;", "itemStack", "add", "block", "dyeColor", "register", "scriptor"})
public final class DyeColorableBlock
implements ColorableBlock {
    @NotNull
    private BiMap<DyeColor, Block> blocks;
    @NotNull
    private Random random;

    public DyeColorableBlock() {
        HashBiMap hashBiMap = HashBiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)hashBiMap, (String)"create(...)");
        this.blocks = (BiMap)hashBiMap;
        this.random = new Random();
    }

    @NotNull
    public final BiMap<DyeColor, Block> getBlocks() {
        return this.blocks;
    }

    public final void setBlocks(@NotNull BiMap<DyeColor, Block> biMap) {
        Intrinsics.checkNotNullParameter(biMap, (String)"<set-?>");
        this.blocks = biMap;
    }

    @NotNull
    public final Random getRandom() {
        return this.random;
    }

    public final void setRandom(@NotNull Random random) {
        Intrinsics.checkNotNullParameter((Object)random, (String)"<set-?>");
        this.random = random;
    }

    @Override
    public void setColor(int color, @Nullable Level level, @NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        if (level == null) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        Object object = this.blocks.get((Object)CustomColors.INSTANCE.getDyeColor(color, level.getGameTime()));
        Intrinsics.checkNotNull((Object)object);
        level.setBlock(blockPos, ((Block)object).withPropertiesOf(level.getBlockState(blockPos)), 2);
        if (blockEntity != null) {
            level.removeBlockEntity(blockPos);
            level.setBlockEntity(blockEntity);
        }
    }

    @Override
    @NotNull
    public ItemStack setColor(int color, @Nullable ItemStack itemStack) {
        Object object = this.blocks.get((Object)CustomColors.INSTANCE.getDyeColor(color, (float)Math.abs((double)this.random.nextInt())));
        Intrinsics.checkNotNull((Object)object);
        Block block = (Block)object;
        ItemStack itemStack2 = itemStack;
        DyedItemColor dyedItemColor = itemStack2 != null ? (DyedItemColor)itemStack2.get(DataComponents.DYED_COLOR) : null;
        boolean tooltip = true;
        if (dyedItemColor != null) {
            tooltip = dyedItemColor.showInTooltip();
        }
        ItemStack itemStack3 = itemStack;
        int count = itemStack3 != null ? itemStack3.getCount() : 1;
        ItemStack itemOut = new ItemStack((ItemLike)block);
        itemOut.setCount(count);
        itemOut.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(color, tooltip));
        return itemOut;
    }

    public final void add(@NotNull Block block, @NotNull DyeColor dyeColor) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)dyeColor, (String)"dyeColor");
        ((Map)this.blocks).put(dyeColor, block);
    }

    public final void register() {
        Iterator iterator = ((Set)this.blocks.values()).iterator();
        while (iterator.hasNext()) {
            Block entry;
            Block block = entry = (Block)iterator.next();
            Intrinsics.checkNotNull((Object)block);
            ColorableBlockRegistry.INSTANCE.register(block, this);
        }
    }
}

