/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.ssblur.scriptor.config.ScriptorConfig;
import com.ssblur.scriptor.events.SpellChat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0002J\u0016\u0010\u0011\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/ssblur/scriptor/commands/CastCommand;", "", "<init>", "()V", "register", "", "dispatcher", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "registry", "Lnet/minecraft/commands/CommandBuildContext;", "selection", "Lnet/minecraft/commands/Commands$CommandSelection;", "execute", "", "command", "Lcom/mojang/brigadier/context/CommandContext;", "noSpell", "scriptor"})
public final class CastCommand {
    @NotNull
    public static final CastCommand INSTANCE = new CastCommand();

    private CastCommand() {
    }

    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher, @Nullable CommandBuildContext registry, @Nullable Commands.CommandSelection selection) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"cast").requires(CastCommand::register$lambda$0)).then(Commands.argument((String)"spell", (ArgumentType)((ArgumentType)StringArgumentType.greedyString())).executes(CastCommand::register$lambda$1))).executes(CastCommand::register$lambda$2));
    }

    private final int execute(CommandContext<CommandSourceStack> command) {
        if (!((Boolean)ScriptorConfig.INSTANCE.getCAST_COMMAND_ENABLED().invoke()).booleanValue()) {
            ((CommandSourceStack)command.getSource()).sendSystemMessage((Component)Component.translatable((String)"command.scriptor.cast_not_enabled").withStyle(ChatFormatting.RED));
            return 1;
        }
        if (((CommandSourceStack)command.getSource()).getEntity() instanceof Player) {
            Entity entity = ((CommandSourceStack)command.getSource()).getEntity();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
            Player player = (Player)entity;
            Level level = player.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level;
            Object object = command.getArgument("spell", String.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getArgument(...)");
            SpellChat.INSTANCE.castFromChat(player, serverLevel, (String)object);
        }
        return 1;
    }

    private final int noSpell(CommandContext<CommandSourceStack> command) {
        ((CommandSourceStack)command.getSource()).sendSystemMessage((Component)Component.translatable((String)"command.scriptor.no_spell").withStyle(ChatFormatting.RED));
        return 1;
    }

    private static final boolean register$lambda$0(CommandSourceStack s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return s.hasPermission(2);
    }

    private static final int register$lambda$1(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.execute((CommandContext<CommandSourceStack>)it);
    }

    private static final int register$lambda$2(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.noSpell((CommandContext<CommandSourceStack>)it);
    }
}

