/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.entity;

import com.ssblur.scriptor.color.CustomColors;
import com.ssblur.scriptor.color.interfaces.Colorable;
import com.ssblur.scriptor.mixin.SheepAccessor;
import java.awt.Color;
import java.util.EnumMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 +2\u00020\u00012\u00020\u0002:\u0001+B\u001f\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0011H\u0016J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J,\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\"H\u0016J\b\u0010*\u001a\u00020\nH\u0014R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006,"}, d2={"Lcom/ssblur/scriptor/entity/ColorfulSheep;", "Lnet/minecraft/world/entity/animal/Sheep;", "Lcom/ssblur/scriptor/color/interfaces/Colorable;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "defineSynchedData", "", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "setColor", "color", "", "getColor", "Lnet/minecraft/world/item/DyeColor;", "colorArray", "Ljava/awt/Color;", "getColorArray", "()Ljava/awt/Color;", "rGBA", "getRGBA", "()I", "dyeColor", "shear", "soundSource", "Lnet/minecraft/sounds/SoundSource;", "addAdditionalSaveData", "compoundTag", "Lnet/minecraft/nbt/CompoundTag;", "readAdditionalSaveData", "finalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "serverLevelAccessor", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficultyInstance", "Lnet/minecraft/world/DifficultyInstance;", "mobSpawnType", "Lnet/minecraft/world/entity/MobSpawnType;", "spawnGroupData", "registerGoals", "Companion", "scriptor"})
@SourceDebugExtension(value={"SMAP\nColorfulSheep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorfulSheep.kt\ncom/ssblur/scriptor/entity/ColorfulSheep\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
public final class ColorfulSheep
extends Sheep
implements Colorable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static EnumMap<DyeColor, Item> WOOL = new EnumMap(DyeColor.class);
    @NotNull
    private static final EntityDataAccessor<Integer> DATA_COLOR;

    public ColorfulSheep(@NotNull EntityType<? extends ColorfulSheep> entityType, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(entityType, level);
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.defineSynchedData(builder);
        builder.define(DATA_COLOR, (Object)0xFFFFFF);
    }

    @Override
    public void setColor(int color) {
        this.entityData.set(DATA_COLOR, (Object)color);
    }

    @NotNull
    public DyeColor getColor() {
        Object object = this.entityData.get(DATA_COLOR);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return CustomColors.INSTANCE.getDyeColor(((Number)object).intValue(), this.level().getGameTime());
    }

    @NotNull
    public final Color getColorArray() {
        return new Color(this.getRGBA());
    }

    public final int getRGBA() {
        Object object = this.entityData.get(DATA_COLOR);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return CustomColors.INSTANCE.getColor(((Number)object).intValue(), this.level().getGameTime());
    }

    public void setColor(@NotNull DyeColor dyeColor) {
        Intrinsics.checkNotNullParameter((Object)dyeColor, (String)"dyeColor");
        this.entityData.set(DATA_COLOR, (Object)dyeColor.getFireworkColor());
    }

    public void shear(@NotNull SoundSource soundSource) {
        Intrinsics.checkNotNullParameter((Object)soundSource, (String)"soundSource");
        this.level().playSound(null, (Entity)this, SoundEvents.SHEEP_SHEAR, soundSource, 1.0f, 1.0f);
        this.setSheared(true);
        int i = 1 + this.random.nextInt(3);
        for (int j = 0; j < i; ++j) {
            ItemEntity itemEntity;
            if (WOOL.get(this.getColor()) != null) {
                Item it;
                boolean bl = false;
                v0 = this.spawnAtLocation((ItemLike)it, 1);
            } else {
                v0 = itemEntity = null;
            }
            if (itemEntity == null) continue;
            itemEntity.setDeltaMovement(new Vec3((double)((this.random.nextFloat() - this.random.nextFloat()) * 0.05f), (double)(this.random.nextFloat() * 0.05f), (double)(this.random.nextFloat() - this.random.nextFloat() * 0.05f)));
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compoundTag) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
        super.addAdditionalSaveData(compoundTag);
        Object object = this.entityData.get(DATA_COLOR);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        compoundTag.putInt("scriptor:color", ((Number)object).intValue());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compoundTag) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
        super.readAdditionalSaveData(compoundTag);
        this.setColor(compoundTag.getInt("scriptor:color"));
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor serverLevelAccessor, @NotNull DifficultyInstance difficultyInstance, @NotNull MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData) {
        Intrinsics.checkNotNullParameter((Object)serverLevelAccessor, (String)"serverLevelAccessor");
        Intrinsics.checkNotNullParameter((Object)difficultyInstance, (String)"difficultyInstance");
        Intrinsics.checkNotNullParameter((Object)mobSpawnType, (String)"mobSpawnType");
        this.setColor(0xFFFFFF);
        return super.finalizeSpawn(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData);
    }

    protected void registerGoals() {
        EatBlockGoal eatBlockGoal = new EatBlockGoal((Mob)this);
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type com.ssblur.scriptor.mixin.SheepAccessor");
        ((SheepAccessor)((Object)this)).setEatBlockGoal(eatBlockGoal);
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0, Sheep.class));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.1, ColorfulSheep::registerGoals$lambda$1, false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(5, (Goal)eatBlockGoal);
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    private static final boolean registerGoals$lambda$1(ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        return itemStack.is(ItemTags.SHEEP_FOOD);
    }

    static {
        ((Map)WOOL).put(DyeColor.BLACK, Items.BLACK_WOOL);
        ((Map)WOOL).put(DyeColor.BLUE, Items.BLUE_WOOL);
        ((Map)WOOL).put(DyeColor.BROWN, Items.BROWN_WOOL);
        ((Map)WOOL).put(DyeColor.CYAN, Items.CYAN_WOOL);
        ((Map)WOOL).put(DyeColor.GRAY, Items.GRAY_WOOL);
        ((Map)WOOL).put(DyeColor.GREEN, Items.GREEN_WOOL);
        ((Map)WOOL).put(DyeColor.LIGHT_BLUE, Items.LIGHT_BLUE_WOOL);
        ((Map)WOOL).put(DyeColor.LIGHT_GRAY, Items.LIGHT_GRAY_WOOL);
        ((Map)WOOL).put(DyeColor.LIME, Items.LIME_WOOL);
        ((Map)WOOL).put(DyeColor.MAGENTA, Items.MAGENTA_WOOL);
        ((Map)WOOL).put(DyeColor.ORANGE, Items.ORANGE_WOOL);
        ((Map)WOOL).put(DyeColor.PINK, Items.PINK_WOOL);
        ((Map)WOOL).put(DyeColor.PURPLE, Items.PURPLE_WOOL);
        ((Map)WOOL).put(DyeColor.RED, Items.RED_WOOL);
        ((Map)WOOL).put(DyeColor.WHITE, Items.WHITE_WOOL);
        ((Map)WOOL).put(DyeColor.YELLOW, Items.YELLOW_WOOL);
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(ColorfulSheep.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        DATA_COLOR = entityDataAccessor;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R&\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/ssblur/scriptor/entity/ColorfulSheep$Companion;", "", "<init>", "()V", "WOOL", "Ljava/util/EnumMap;", "Lnet/minecraft/world/item/DyeColor;", "Lnet/minecraft/world/item/Item;", "getWOOL", "()Ljava/util/EnumMap;", "setWOOL", "(Ljava/util/EnumMap;)V", "DATA_COLOR", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "scriptor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EnumMap<DyeColor, Item> getWOOL() {
            return WOOL;
        }

        public final void setWOOL(@NotNull EnumMap<DyeColor, Item> enumMap) {
            Intrinsics.checkNotNullParameter(enumMap, (String)"<set-?>");
            WOOL = enumMap;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

