/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.entity.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.ssblur.scriptor.ScriptorMod;
import com.ssblur.scriptor.color.CustomColors;
import com.ssblur.scriptor.entity.ScriptorProjectile;
import com.ssblur.scriptor.particle.MagicParticleData;
import javax.annotation.ParametersAreNonnullByDefault;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J8\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/ssblur/scriptor/entity/renderers/ScriptorProjectileRenderer;", "Lnet/minecraft/client/renderer/entity/EntityRenderer;", "Lcom/ssblur/scriptor/entity/ScriptorProjectile;", "context", "Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)V", "getTextureLocation", "Lnet/minecraft/resources/ResourceLocation;", "entity", "render", "", "yaw", "", "tickDelta", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "multiBufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "lightLevel", "", "scriptor"})
public final class ScriptorProjectileRenderer
extends EntityRenderer<ScriptorProjectile> {
    public ScriptorProjectileRenderer(@NotNull EntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull ScriptorProjectile entity) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        ResourceLocation resourceLocation = ScriptorMod.INSTANCE.location("textures/item/tome.png");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
        return resourceLocation;
    }

    public void render(@NotNull ScriptorProjectile entity, float yaw, float tickDelta, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int lightLevel) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)multiBufferSource, (String)"multiBufferSource");
        super.render((Entity)entity, yaw, tickDelta, poseStack, multiBufferSource, lightLevel);
        ClientLevel clientLevel = Minecraft.getInstance().level;
        Intrinsics.checkNotNull((Object)clientLevel);
        ClientLevel level = clientLevel;
        CustomColors.RGB rGB = CustomColors.INSTANCE.splitIntoRGB(CustomColors.INSTANCE.getColor(entity.getColor(), level.getGameTime()));
        int r = rGB.component1();
        int g = rGB.component2();
        int b = rGB.component3();
        Vec3 d = entity.getDeltaMovement().scale((double)tickDelta);
        level.addParticle((ParticleOptions)MagicParticleData.Companion.magic(r, g, b), entity.getX() + d.x, entity.getY() + d.y, entity.getZ() + d.z, 0.0, 0.0, 0.0);
    }
}

