/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.events;

import com.ssblur.scriptor.ScriptorDamage;
import com.ssblur.scriptor.config.ScriptorConfig;
import com.ssblur.scriptor.data.saved_data.DictionarySavedData;
import com.ssblur.scriptor.effect.EmpoweredStatusEffect;
import com.ssblur.scriptor.effect.ScriptorEffects;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.word.Spell;
import com.ssblur.unfocused.event.common.PlayerChatEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/ssblur/scriptor/events/SpellChat;", "", "<init>", "()V", "castFromChat", "", "player", "Lnet/minecraft/world/entity/player/Player;", "level", "Lnet/minecraft/server/level/ServerLevel;", "sentence", "", "scriptor"})
public final class SpellChat {
    @NotNull
    public static final SpellChat INSTANCE = new SpellChat();

    private SpellChat() {
    }

    public final boolean castFromChat(@NotNull Player player, @NotNull ServerLevel level, @NotNull String sentence) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)sentence, (String)"sentence");
        Spell spell = DictionarySavedData.Companion.computeIfAbsent(level).parse(sentence);
        if (spell != null) {
            if (player.hasEffect((Holder)ScriptorEffects.INSTANCE.getHOARSE().ref())) {
                player.sendSystemMessage((Component)Component.translatable((String)"extra.scriptor.hoarse"));
                return true;
            }
            if (player.hasEffect((Holder)ScriptorEffects.INSTANCE.getMUTE().ref())) {
                player.sendSystemMessage((Component)Component.translatable((String)"extra.scriptor.mute"));
                return true;
            }
            int cost = MathKt.roundToInt((double)(spell.cost() * (double)30));
            float costScale = 1.0f;
            block0: for (MobEffectInstance instance : player.getActiveEffects()) {
                int n;
                int i;
                if (!(instance.getEffect().value() instanceof EmpoweredStatusEffect) || (i = 0) > (n = instance.getAmplifier())) continue;
                while (true) {
                    Object object = instance.getEffect().value();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.ssblur.scriptor.effect.EmpoweredStatusEffect");
                    costScale *= ((EmpoweredStatusEffect)((Object)object)).getScale();
                    if (i == n) continue block0;
                    ++i;
                }
            }
            cost = MathKt.roundToInt((float)((float)cost * costScale));
            int n = ((Number)ScriptorConfig.INSTANCE.getVOCAL_MAX_COST().invoke()).intValue();
            boolean bl = 0 <= n ? n < cost : false;
            if (bl) {
                player.sendSystemMessage((Component)Component.translatable((String)"extra.scriptor.mute"));
            }
            int adjustedCost = MathKt.roundToInt((double)((double)cost * (((Number)ScriptorConfig.INSTANCE.getVOCAL_COOLDOWN_MULTIPLIER().invoke()).doubleValue() / 100.0)));
            if (!player.isCreative()) {
                player.addEffect(new MobEffectInstance((Holder)ScriptorEffects.INSTANCE.getHOARSE().ref(), adjustedCost));
                if (adjustedCost > ((Number)ScriptorConfig.INSTANCE.getVOCAL_HUNGER_THRESHOLD().invoke()).intValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.HUNGER, 2 * (adjustedCost - ((Number)ScriptorConfig.INSTANCE.getVOCAL_HUNGER_THRESHOLD().invoke()).intValue())));
                }
                if (adjustedCost > ((Number)ScriptorConfig.INSTANCE.getVOCAL_DAMAGE_THRESHOLD().invoke()).intValue()) {
                    DamageSource damageSource = ScriptorDamage.overload((Entity)player);
                    Intrinsics.checkNotNull((Object)damageSource);
                    player.hurt(damageSource, ((float)adjustedCost - ((Number)ScriptorConfig.INSTANCE.getVOCAL_DAMAGE_THRESHOLD().invoke()).floatValue() * 0.75f) / 100.0f);
                }
            }
            if (player.getHealth() > 0.0f) {
                spell.cast(new EntityTargetable((Entity)player));
            }
            if (!((Boolean)ScriptorConfig.INSTANCE.getSHOW_SPELLS_IN_CHAT().invoke()).booleanValue()) {
                return true;
            }
        }
        return false;
    }

    private static final boolean lambda$1$lambda$0(ServerPlayer $player, int $distance, ServerPlayer recipient) {
        Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
        Intrinsics.checkNotNullParameter((Object)recipient, (String)"recipient");
        return recipient.distanceTo((Entity)$player) <= (float)$distance;
    }

    private static final void _init_$lambda$1(PlayerChatEvent.PlayerChatMessage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ServerPlayer player = it.getPlayer();
        Component component = it.getMessage();
        String sentence = component.getString();
        Level level = player.level();
        if (level instanceof ServerLevel) {
            Player player2 = (Player)player;
            ServerLevel serverLevel = (ServerLevel)level;
            Intrinsics.checkNotNull((Object)sentence);
            if (INSTANCE.castFromChat(player2, serverLevel, sentence)) {
                it.cancel();
                return;
            }
        }
        if (level instanceof ServerLevel && ((Boolean)ScriptorConfig.INSTANCE.getPROXIMITY_CHAT().invoke()).booleanValue()) {
            Component component2;
            int distance = ((Number)ScriptorConfig.INSTANCE.getPROXIMITY_RANGE().invoke()).intValue();
            Component name = player.getDisplayName();
            if (name == null) {
                MutableComponent mutableComponent = Component.literal((String)"> ").append(component);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"append(...)");
                component2 = (Component)mutableComponent;
            } else {
                MutableComponent mutableComponent = Component.literal((String)"<").append(name).append((Component)Component.literal((String)"> ")).append(component);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"append(...)");
                component2 = (Component)mutableComponent;
            }
            Component message = component2;
            List list = ((ServerLevel)level).getPlayers(arg_0 -> SpellChat.lambda$1$lambda$0(player, distance, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
            List players = list;
            for (ServerPlayer recipient : players) {
                recipient.sendSystemMessage(message);
            }
            if (players.size() <= 1) {
                player.sendSystemMessage((Component)Component.translatable((String)"command.scriptor.unheard").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
            }
            it.cancel();
            return;
        }
    }

    static {
        PlayerChatEvent.Companion.getBefore().register(SpellChat::_init_$lambda$1);
    }
}

