/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.helpers.generators;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ssblur.scriptor.error.MissingRequiredElementException;
import com.ssblur.scriptor.helpers.generators.TokenGenerator;
import com.ssblur.scriptor.registry.TokenGeneratorRegistry;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 \u001d2\u00020\u0001:\u0003\u001b\u001c\u001dB\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u000e\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\bJ\b\u0010\u001a\u001a\u00020\tH\u0016R8\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\nj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\u0007X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lcom/ssblur/scriptor/helpers/generators/StaticTokenGenerator;", "Lcom/ssblur/scriptor/helpers/generators/TokenGenerator;", "obj", "Lcom/google/gson/JsonObject;", "<init>", "(Lcom/google/gson/JsonObject;)V", "usedTokens", "Lkotlin/collections/HashMap;", "", "", "Ljava/util/HashMap;", "getUsedTokens", "()Ljava/util/HashMap;", "setUsedTokens", "(Ljava/util/HashMap;)V", "Ljava/util/HashMap;", "parameters", "Lcom/ssblur/scriptor/helpers/generators/StaticTokenGenerator$StaticTokenParameters;", "getParameters", "()Lcom/ssblur/scriptor/helpers/generators/StaticTokenGenerator$StaticTokenParameters;", "setParameters", "(Lcom/ssblur/scriptor/helpers/generators/StaticTokenGenerator$StaticTokenParameters;)V", "generateToken", "key", "shorten", "string", "canBeDefault", "CollisionStrategy", "StaticTokenParameters", "Companion", "scriptor"})
public final class StaticTokenGenerator
extends TokenGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private HashMap<String, Boolean> usedTokens = new HashMap();
    @NotNull
    private StaticTokenParameters parameters;
    @NotNull
    private static Type PARAMETERS_TYPE;
    @NotNull
    private static Gson GSON;

    public StaticTokenGenerator(@Nullable JsonObject obj) {
        this.parameters = (StaticTokenParameters)GSON.fromJson((JsonElement)obj, PARAMETERS_TYPE);
    }

    @NotNull
    public final HashMap<String, Boolean> getUsedTokens() {
        return this.usedTokens;
    }

    public final void setUsedTokens(@NotNull HashMap<String, Boolean> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.usedTokens = hashMap;
    }

    @NotNull
    public final StaticTokenParameters getParameters() {
        return this.parameters;
    }

    public final void setParameters(@NotNull StaticTokenParameters staticTokenParameters) {
        Intrinsics.checkNotNullParameter((Object)staticTokenParameters, (String)"<set-?>");
        this.parameters = staticTokenParameters;
    }

    @Override
    @NotNull
    public String generateToken(@NotNull String key, @Nullable JsonObject parameters) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (parameters == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        if (!parameters.has("token")) {
            throw new MissingRequiredElementException("token", "The word \"" + key + "\" must have a token defined because it uses a static token generator.");
        }
        String token = parameters.get("token").getAsString();
        if (this.usedTokens.containsKey(token)) {
            CollisionStrategy collisionStrategy = this.parameters.collisionStrategy();
            switch (collisionStrategy == null ? -1 : WhenMappings.$EnumSwitchMapping$0[collisionStrategy.ordinal()]) {
                case 1: {
                    String string = "Failed to generate static token: token %s already in use!";
                    Object[] objectArray = new Object[]{token};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    throw new RuntimeException(string2);
                }
                case 2: {
                    String string = token;
                    Intrinsics.checkNotNull((Object)string);
                    token = this.shorten(string);
                    break;
                }
                case 3: {
                    TokenGenerator tokenGenerator = TokenGeneratorRegistry.INSTANCE.getGenerator(TokenGeneratorRegistry.INSTANCE.getDefaultGenerator());
                    Intrinsics.checkNotNull((Object)tokenGenerator);
                    return tokenGenerator.generateToken(key, null);
                }
                case -1: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        ((Map)this.usedTokens).put(token, true);
        String string = token;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @NotNull
    public final String shorten(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        String token = string;
        while (this.usedTokens.containsKey(token)) {
            Intrinsics.checkNotNullExpressionValue((Object)token.substring(0, token.length() - 1), (String)"substring(...)");
            if (!(((CharSequence)token).length() == 0)) continue;
            String string2 = "Failed to generate a static token: token %s cannot be shortened any further!";
            Object[] objectArray = new Object[]{string};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            throw new RuntimeException(string3);
        }
        return token;
    }

    @Override
    public boolean canBeDefault() {
        return false;
    }

    static {
        Type type = new TypeToken<StaticTokenParameters>(){}.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(...)");
        PARAMETERS_TYPE = type;
        GSON = new Gson();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/ssblur/scriptor/helpers/generators/StaticTokenGenerator$CollisionStrategy;", "", "<init>", "(Ljava/lang/String;I)V", "FAIL", "FALLBACK", "SHORTEN", "scriptor"})
    public static final class CollisionStrategy
    extends Enum<CollisionStrategy> {
        public static final /* enum */ CollisionStrategy FAIL = new CollisionStrategy();
        public static final /* enum */ CollisionStrategy FALLBACK = new CollisionStrategy();
        public static final /* enum */ CollisionStrategy SHORTEN = new CollisionStrategy();
        private static final /* synthetic */ CollisionStrategy[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CollisionStrategy[] values() {
            return (CollisionStrategy[])$VALUES.clone();
        }

        public static CollisionStrategy valueOf(String value) {
            return Enum.valueOf(CollisionStrategy.class, value);
        }

        @NotNull
        public static EnumEntries<CollisionStrategy> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = collisionStrategyArray = new CollisionStrategy[]{CollisionStrategy.FAIL, CollisionStrategy.FALLBACK, CollisionStrategy.SHORTEN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/ssblur/scriptor/helpers/generators/StaticTokenGenerator$Companion;", "", "<init>", "()V", "PARAMETERS_TYPE", "Ljava/lang/reflect/Type;", "getPARAMETERS_TYPE", "()Ljava/lang/reflect/Type;", "setPARAMETERS_TYPE", "(Ljava/lang/reflect/Type;)V", "GSON", "Lcom/google/gson/Gson;", "getGSON", "()Lcom/google/gson/Gson;", "setGSON", "(Lcom/google/gson/Gson;)V", "scriptor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Type getPARAMETERS_TYPE() {
            return PARAMETERS_TYPE;
        }

        public final void setPARAMETERS_TYPE(@NotNull Type type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"<set-?>");
            PARAMETERS_TYPE = type;
        }

        @NotNull
        public final Gson getGSON() {
            return GSON;
        }

        public final void setGSON(@NotNull Gson gson) {
            Intrinsics.checkNotNullParameter((Object)gson, (String)"<set-?>");
            GSON = gson;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/ssblur/scriptor/helpers/generators/StaticTokenGenerator$StaticTokenParameters;", "Ljava/lang/Record;", "collisionStrategy", "Lcom/ssblur/scriptor/helpers/generators/StaticTokenGenerator$CollisionStrategy;", "<init>", "(Lcom/ssblur/scriptor/helpers/generators/StaticTokenGenerator$CollisionStrategy;)V", "()Lcom/ssblur/scriptor/helpers/generators/StaticTokenGenerator$CollisionStrategy;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "scriptor"})
    public static final class StaticTokenParameters
    extends Record {
        @Nullable
        private final CollisionStrategy collisionStrategy;

        public StaticTokenParameters(@Nullable CollisionStrategy collisionStrategy) {
            this.collisionStrategy = collisionStrategy;
        }

        @Nullable
        public final CollisionStrategy collisionStrategy() {
            return this.collisionStrategy;
        }

        @Nullable
        public final CollisionStrategy component1() {
            return this.collisionStrategy;
        }

        @NotNull
        public final StaticTokenParameters copy(@Nullable CollisionStrategy collisionStrategy) {
            return new StaticTokenParameters(collisionStrategy);
        }

        public static /* synthetic */ StaticTokenParameters copy$default(StaticTokenParameters staticTokenParameters, CollisionStrategy collisionStrategy, int n, Object object) {
            if ((n & 1) != 0) {
                collisionStrategy = staticTokenParameters.collisionStrategy;
            }
            return staticTokenParameters.copy(collisionStrategy);
        }

        @Override
        @NotNull
        public String toString() {
            return "StaticTokenParameters(collisionStrategy=" + this.collisionStrategy + ")";
        }

        @Override
        public int hashCode() {
            return this.collisionStrategy == null ? 0 : this.collisionStrategy.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StaticTokenParameters)) {
                return false;
            }
            StaticTokenParameters staticTokenParameters = (StaticTokenParameters)other;
            return this.collisionStrategy == staticTokenParameters.collisionStrategy;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CollisionStrategy.values().length];
            try {
                nArray[CollisionStrategy.FAIL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CollisionStrategy.SHORTEN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CollisionStrategy.FALLBACK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

