/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.item.casters;

import com.ssblur.scriptor.data.components.ScriptorDataComponents;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.item.casters.CasterCrystal;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J.\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a8\u0006\u001c"}, d2={"Lcom/ssblur/scriptor/item/casters/PlayerCasterCrystal;", "Lcom/ssblur/scriptor/item/casters/CasterCrystal;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "getTargetables", "", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "appendHoverText", "", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "list", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "use", "Lnet/minecraft/world/InteractionResultHolder;", "player", "Lnet/minecraft/world/entity/player/Player;", "interactionHand", "Lnet/minecraft/world/InteractionHand;", "scriptor"})
public final class PlayerCasterCrystal
extends CasterCrystal {
    public PlayerCasterCrystal(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @Override
    @Nullable
    public List<Targetable> getTargetables(@Nullable ItemStack itemStack, @Nullable Level level) {
        ItemStack itemStack2 = itemStack;
        Intrinsics.checkNotNull((Object)itemStack2);
        String uuid = (String)itemStack2.get(ScriptorDataComponents.INSTANCE.getPLAYER_FOCUS());
        if (uuid != null) {
            Level level2 = level;
            Intrinsics.checkNotNull((Object)level2);
            Player player = level2.getPlayerByUUID(UUID.fromString(uuid));
            if (player != null) {
                return List.of(new EntityTargetable((Entity)player));
            }
        }
        return CollectionsKt.emptyList();
    }

    public void appendHoverText(@NotNull ItemStack itemStack, @NotNull Item.TooltipContext context, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        super.appendHoverText(itemStack, context, list, tooltipFlag);
        MutableComponent mutableComponent = Component.translatable((String)"lore.scriptor.player_crystal_1").withStyle(ChatFormatting.GRAY);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
        list.add((Component)mutableComponent);
        String name = (String)itemStack.get(ScriptorDataComponents.INSTANCE.getPLAYER_NAME());
        if (name != null) {
            Object[] objectArray = new Object[]{name};
            MutableComponent mutableComponent2 = Component.translatable((String)"lore.scriptor.player_crystal_2", (Object[])objectArray).withStyle(ChatFormatting.GRAY);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"withStyle(...)");
            list.add((Component)mutableComponent2);
            MutableComponent mutableComponent3 = Component.translatable((String)"lore.scriptor.crystal_reset").withStyle(ChatFormatting.GRAY);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"withStyle(...)");
            list.add((Component)mutableComponent3);
        }
        MutableComponent mutableComponent4 = Component.translatable((String)"lore.scriptor.crystal_focus").withStyle(ChatFormatting.GRAY);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent4, (String)"withStyle(...)");
        list.add((Component)mutableComponent4);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)interactionHand, (String)"interactionHand");
        InteractionResultHolder result = super.use(level, player, interactionHand);
        if (!level.isClientSide) {
            ItemStack itemStack = player.getItemInHand(interactionHand);
            itemStack.set(ScriptorDataComponents.INSTANCE.getPLAYER_FOCUS(), (Object)player.getStringUUID());
            DataComponentType<String> dataComponentType = ScriptorDataComponents.INSTANCE.getPLAYER_NAME();
            Component component = player.getDisplayName();
            Intrinsics.checkNotNull((Object)component);
            itemStack.set(dataComponentType, (Object)component.getString());
        }
        Intrinsics.checkNotNull((Object)result);
        return result;
    }
}

