/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.network.server;

import com.ssblur.scriptor.ScriptorMod;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.network.client.ScriptorNetworkS2C;
import com.ssblur.unfocused.extension.ServerLevelExtension;
import com.ssblur.unfocused.network.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u001b\u001c\u001d\u001eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\t0\u000fJ\u001e\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0012J\u001e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0010J\u0016\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\t0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001f"}, d2={"Lcom/ssblur/scriptor/network/server/TraceNetwork;", "", "<init>", "()V", "queue", "Ljava/util/HashMap;", "Ljava/util/UUID;", "Lcom/ssblur/scriptor/network/server/TraceNetwork$TraceQueue;", "requestTraceData", "", "player", "Lnet/minecraft/world/entity/player/Player;", "collideWithWater", "", "callback", "Lkotlin/Function1;", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "requestExtendedTraceData", "Lcom/ssblur/scriptor/network/server/TraceNetwork$TraceCallback;", "validateAndRun", "uuid", "targetable", "validateAndDrop", "returnTrace", "Lcom/ssblur/scriptor/network/server/TraceNetwork$Payload;", "getReturnTrace", "()Lkotlin/jvm/functions/Function1;", "TYPE", "TraceCallback", "TraceQueue", "Payload", "scriptor"})
public final class TraceNetwork {
    @NotNull
    public static final TraceNetwork INSTANCE = new TraceNetwork();
    @NotNull
    private static HashMap<UUID, TraceQueue> queue = new HashMap();
    @NotNull
    private static final Function1<Payload, Unit> returnTrace;

    private TraceNetwork() {
    }

    public final void requestTraceData(@NotNull Player player, boolean collideWithWater, @NotNull Function1<? super Targetable, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        UUID uuid = UUID.randomUUID();
        RegistryFriendlyByteBuf out = new RegistryFriendlyByteBuf(Unpooled.buffer(), (RegistryAccess)RegistryAccess.EMPTY);
        out.writeUUID(uuid);
        ((Map)queue).put(uuid, new TraceQueue(player, new TraceCallback(callback){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void run(Targetable target) {
                this.function.invoke((Object)target);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof TraceCallback ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        }));
        Function2<ScriptorNetworkS2C.Trace, List<? extends Player>, Unit> function2 = ScriptorNetworkS2C.INSTANCE.getTrace();
        Intrinsics.checkNotNull((Object)uuid);
        function2.invoke((Object)new ScriptorNetworkS2C.Trace(uuid, collideWithWater), (Object)CollectionsKt.listOf((Object)player));
    }

    public final void requestExtendedTraceData(@NotNull Player player, boolean collideWithWater, @NotNull TraceCallback callback) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        UUID uuid = UUID.randomUUID();
        RegistryFriendlyByteBuf out = new RegistryFriendlyByteBuf(Unpooled.buffer(), (RegistryAccess)RegistryAccess.EMPTY);
        out.writeUUID(uuid);
        ((Map)queue).put(uuid, new TraceQueue(player, callback));
        Function2<ScriptorNetworkS2C.ExtendedTrace, List<? extends Player>, Unit> function2 = ScriptorNetworkS2C.INSTANCE.getExtendedTrace();
        Intrinsics.checkNotNull((Object)uuid);
        function2.invoke((Object)new ScriptorNetworkS2C.ExtendedTrace(uuid, collideWithWater, 0.0, 4, null), (Object)CollectionsKt.listOf((Object)player));
    }

    public final void validateAndRun(@NotNull UUID uuid, @NotNull Player player, @NotNull Targetable targetable) {
        TraceQueue queueItem;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)targetable, (String)"targetable");
        TraceQueue traceQueue = queueItem = queue.get(uuid);
        Intrinsics.checkNotNull((Object)traceQueue);
        if (traceQueue.getPlayer() == player) {
            queueItem.getCallback().run(targetable);
        }
    }

    public final void validateAndDrop(@NotNull UUID uuid, @NotNull Player player) {
        TraceQueue queueItem;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        TraceQueue traceQueue = queueItem = queue.get(uuid);
        Intrinsics.checkNotNull((Object)traceQueue);
        if (traceQueue.getPlayer() == player) {
            queue.remove(uuid);
        }
    }

    @NotNull
    public final Function1<Payload, Unit> getReturnTrace() {
        return returnTrace;
    }

    private static final void returnTrace$lambda$4$lambda$0(Payload $payload, ServerPlayer $player, Targetable $targetable) {
        Intrinsics.checkNotNullParameter((Object)$payload, (String)"$payload");
        Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
        Intrinsics.checkNotNullParameter((Object)$targetable, (String)"$targetable");
        INSTANCE.validateAndRun($payload.getUuid(), (Player)$player, $targetable);
    }

    private static final void returnTrace$lambda$4$lambda$1(Payload $payload, ServerPlayer $player, Entity $entity) {
        Intrinsics.checkNotNullParameter((Object)$payload, (String)"$payload");
        Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
        INSTANCE.validateAndRun($payload.getUuid(), (Player)$player, new EntityTargetable($entity));
    }

    private static final void returnTrace$lambda$4$lambda$2(Payload $payload, ServerPlayer $player) {
        Intrinsics.checkNotNullParameter((Object)$payload, (String)"$payload");
        Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
        INSTANCE.validateAndDrop($payload.getUuid(), (Player)$player);
    }

    private static final void returnTrace$lambda$4$lambda$3(Payload $payload, ServerPlayer $player) {
        Intrinsics.checkNotNullParameter((Object)$payload, (String)"$payload");
        Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
        INSTANCE.validateAndDrop($payload.getUuid(), (Player)$player);
    }

    private static final void returnTrace$lambda$4(Payload payload, ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        switch (WhenMappings.$EnumSwitchMapping$0[payload.getTraceType().ordinal()]) {
            case 1: {
                BlockHitResult blockHitResult = payload.getBlockHitResult();
                Intrinsics.checkNotNull((Object)blockHitResult);
                BlockHitResult result = blockHitResult;
                BlockPos pos = result.getBlockPos().relative(result.getDirection());
                Level level = player.level();
                Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
                Intrinsics.checkNotNull((Object)pos);
                Targetable targetable = new Targetable(level, pos).setFacing(result.getDirection());
                ServerLevel serverLevel = player.serverLevel();
                Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"serverLevel(...)");
                ServerLevelExtension.INSTANCE.runOnce(serverLevel, () -> TraceNetwork.returnTrace$lambda$4$lambda$0(payload, player, targetable));
                break;
            }
            case 2: {
                ServerLevel level = player.serverLevel();
                Entity entity = level.getEntity(payload.getEntityId());
                if (entity != null && Intrinsics.areEqual((Object)entity.getUUID(), (Object)payload.getEntityUUID())) {
                    Intrinsics.checkNotNull((Object)level);
                    ServerLevelExtension.INSTANCE.runOnce(level, () -> TraceNetwork.returnTrace$lambda$4$lambda$1(payload, player, entity));
                    break;
                }
                Intrinsics.checkNotNull((Object)level);
                ServerLevelExtension.INSTANCE.runOnce(level, () -> TraceNetwork.returnTrace$lambda$4$lambda$2(payload, player));
                break;
            }
            default: {
                ServerLevel serverLevel = player.serverLevel();
                Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"serverLevel(...)");
                ServerLevelExtension.INSTANCE.runOnce(serverLevel, () -> TraceNetwork.returnTrace$lambda$4$lambda$3(payload, player));
            }
        }
    }

    static {
        ResourceLocation resourceLocation = ScriptorMod.INSTANCE.location("server_return_trace_data");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
        returnTrace = NetworkManager.INSTANCE.registerC2S(resourceLocation, Reflection.getOrCreateKotlinClass(Payload.class), TraceNetwork::returnTrace$lambda$4);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J?\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\tH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000e\u00a8\u0006\""}, d2={"Lcom/ssblur/scriptor/network/server/TraceNetwork$Payload;", "", "uuid", "Ljava/util/UUID;", "traceType", "Lcom/ssblur/scriptor/network/server/TraceNetwork$TYPE;", "blockHitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "entityId", "", "entityUUID", "<init>", "(Ljava/util/UUID;Lcom/ssblur/scriptor/network/server/TraceNetwork$TYPE;Lnet/minecraft/world/phys/BlockHitResult;ILjava/util/UUID;)V", "getUuid", "()Ljava/util/UUID;", "getTraceType", "()Lcom/ssblur/scriptor/network/server/TraceNetwork$TYPE;", "getBlockHitResult", "()Lnet/minecraft/world/phys/BlockHitResult;", "getEntityId", "()I", "getEntityUUID", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "scriptor"})
    public static final class Payload {
        @NotNull
        private final UUID uuid;
        @NotNull
        private final TYPE traceType;
        @Nullable
        private final BlockHitResult blockHitResult;
        private final int entityId;
        @Nullable
        private final UUID entityUUID;

        public Payload(@NotNull UUID uuid, @NotNull TYPE traceType, @Nullable BlockHitResult blockHitResult, int entityId, @Nullable UUID entityUUID) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Intrinsics.checkNotNullParameter((Object)((Object)traceType), (String)"traceType");
            this.uuid = uuid;
            this.traceType = traceType;
            this.blockHitResult = blockHitResult;
            this.entityId = entityId;
            this.entityUUID = entityUUID;
        }

        @NotNull
        public final UUID getUuid() {
            return this.uuid;
        }

        @NotNull
        public final TYPE getTraceType() {
            return this.traceType;
        }

        @Nullable
        public final BlockHitResult getBlockHitResult() {
            return this.blockHitResult;
        }

        public final int getEntityId() {
            return this.entityId;
        }

        @Nullable
        public final UUID getEntityUUID() {
            return this.entityUUID;
        }

        @NotNull
        public final UUID component1() {
            return this.uuid;
        }

        @NotNull
        public final TYPE component2() {
            return this.traceType;
        }

        @Nullable
        public final BlockHitResult component3() {
            return this.blockHitResult;
        }

        public final int component4() {
            return this.entityId;
        }

        @Nullable
        public final UUID component5() {
            return this.entityUUID;
        }

        @NotNull
        public final Payload copy(@NotNull UUID uuid, @NotNull TYPE traceType, @Nullable BlockHitResult blockHitResult, int entityId, @Nullable UUID entityUUID) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Intrinsics.checkNotNullParameter((Object)((Object)traceType), (String)"traceType");
            return new Payload(uuid, traceType, blockHitResult, entityId, entityUUID);
        }

        public static /* synthetic */ Payload copy$default(Payload payload, UUID uUID, TYPE tYPE, BlockHitResult blockHitResult, int n, UUID uUID2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                uUID = payload.uuid;
            }
            if ((n2 & 2) != 0) {
                tYPE = payload.traceType;
            }
            if ((n2 & 4) != 0) {
                blockHitResult = payload.blockHitResult;
            }
            if ((n2 & 8) != 0) {
                n = payload.entityId;
            }
            if ((n2 & 0x10) != 0) {
                uUID2 = payload.entityUUID;
            }
            return payload.copy(uUID, tYPE, blockHitResult, n, uUID2);
        }

        @NotNull
        public String toString() {
            return "Payload(uuid=" + this.uuid + ", traceType=" + this.traceType + ", blockHitResult=" + this.blockHitResult + ", entityId=" + this.entityId + ", entityUUID=" + this.entityUUID + ")";
        }

        public int hashCode() {
            int result = this.uuid.hashCode();
            result = result * 31 + this.traceType.hashCode();
            result = result * 31 + (this.blockHitResult == null ? 0 : this.blockHitResult.hashCode());
            result = result * 31 + Integer.hashCode(this.entityId);
            result = result * 31 + (this.entityUUID == null ? 0 : this.entityUUID.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Payload)) {
                return false;
            }
            Payload payload = (Payload)other;
            if (!Intrinsics.areEqual((Object)this.uuid, (Object)payload.uuid)) {
                return false;
            }
            if (this.traceType != payload.traceType) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.blockHitResult, (Object)payload.blockHitResult)) {
                return false;
            }
            if (this.entityId != payload.entityId) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.entityUUID, (Object)payload.entityUUID);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/ssblur/scriptor/network/server/TraceNetwork$TYPE;", "", "<init>", "(Ljava/lang/String;I)V", "BLOCK", "ENTITY", "MISS", "scriptor"})
    public static final class TYPE
    extends Enum<TYPE> {
        public static final /* enum */ TYPE BLOCK = new TYPE();
        public static final /* enum */ TYPE ENTITY = new TYPE();
        public static final /* enum */ TYPE MISS = new TYPE();
        private static final /* synthetic */ TYPE[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static TYPE[] values() {
            return (TYPE[])$VALUES.clone();
        }

        public static TYPE valueOf(String value) {
            return Enum.valueOf(TYPE.class, value);
        }

        @NotNull
        public static EnumEntries<TYPE> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = tYPEArray = new TYPE[]{TYPE.BLOCK, TYPE.ENTITY, TYPE.MISS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/ssblur/scriptor/network/server/TraceNetwork$TraceCallback;", "", "run", "", "target", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "scriptor"})
    public static interface TraceCallback {
        public void run(@NotNull Targetable var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/ssblur/scriptor/network/server/TraceNetwork$TraceQueue;", "", "player", "Lnet/minecraft/world/entity/player/Player;", "callback", "Lcom/ssblur/scriptor/network/server/TraceNetwork$TraceCallback;", "<init>", "(Lnet/minecraft/world/entity/player/Player;Lcom/ssblur/scriptor/network/server/TraceNetwork$TraceCallback;)V", "getPlayer", "()Lnet/minecraft/world/entity/player/Player;", "getCallback", "()Lcom/ssblur/scriptor/network/server/TraceNetwork$TraceCallback;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "scriptor"})
    public static final class TraceQueue {
        @NotNull
        private final Player player;
        @NotNull
        private final TraceCallback callback;

        public TraceQueue(@NotNull Player player, @NotNull TraceCallback callback) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            this.player = player;
            this.callback = callback;
        }

        @NotNull
        public final Player getPlayer() {
            return this.player;
        }

        @NotNull
        public final TraceCallback getCallback() {
            return this.callback;
        }

        @NotNull
        public final Player component1() {
            return this.player;
        }

        @NotNull
        public final TraceCallback component2() {
            return this.callback;
        }

        @NotNull
        public final TraceQueue copy(@NotNull Player player, @NotNull TraceCallback callback) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            return new TraceQueue(player, callback);
        }

        public static /* synthetic */ TraceQueue copy$default(TraceQueue traceQueue, Player player, TraceCallback traceCallback, int n, Object object) {
            if ((n & 1) != 0) {
                player = traceQueue.player;
            }
            if ((n & 2) != 0) {
                traceCallback = traceQueue.callback;
            }
            return traceQueue.copy(player, traceCallback);
        }

        @NotNull
        public String toString() {
            return "TraceQueue(player=" + this.player + ", callback=" + this.callback + ")";
        }

        public int hashCode() {
            int result = this.player.hashCode();
            result = result * 31 + this.callback.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TraceQueue)) {
                return false;
            }
            TraceQueue traceQueue = (TraceQueue)other;
            if (!Intrinsics.areEqual((Object)this.player, (Object)traceQueue.player)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.callback, (Object)traceQueue.callback);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TYPE.values().length];
            try {
                nArray[TYPE.BLOCK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TYPE.ENTITY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

