/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.screen.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\f\n\u0002\b\u000b\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001kBE\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\u0005\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\nH\u0016J \u0010<\u001a\u00020\n2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020>2\u0006\u0010@\u001a\u00020\u0005H\u0016J\u001e\u0010E\u001a\u00020(2\u0006\u00100\u001a\u0002012\u0006\u0010F\u001a\u00020>2\u0006\u0010G\u001a\u00020>J\u000e\u0010H\u001a\b\u0012\u0004\u0012\u00020C0BH\u0002J\u000e\u0010I\u001a\u00020:2\u0006\u0010@\u001a\u00020\u0005J\u000e\u0010J\u001a\u00020:2\u0006\u0010@\u001a\u00020\u0005J\u000e\u0010K\u001a\u00020:2\u0006\u0010@\u001a\u00020\u0005J\b\u0010L\u001a\u00020\nH\u0016J\u0010\u0010M\u001a\u00020:2\u0006\u0010N\u001a\u00020OH\u0016J\b\u0010P\u001a\u00020QH\u0016J(\u0010R\u001a\u00020:2\u0006\u0010S\u001a\u00020T2\u0006\u0010@\u001a\u00020\u00052\u0006\u0010U\u001a\u00020\u00052\u0006\u0010V\u001a\u00020WH\u0016J(\u0010X\u001a\u00020\n2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020>2\u0006\u0010V\u001a\u00020>2\u0006\u0010Y\u001a\u00020>H\u0016J \u0010Z\u001a\u00020\n2\u0006\u0010[\u001a\u00020\u00052\u0006\u0010U\u001a\u00020\u00052\u0006\u0010\\\u001a\u00020\u0005H\u0016J \u0010]\u001a\u00020\n2\u0006\u0010@\u001a\u00020\u00052\u0006\u0010U\u001a\u00020\u00052\u0006\u0010^\u001a\u00020\u0005H\u0016J\u0018\u0010_\u001a\u00020\n2\u0006\u0010`\u001a\u00020a2\u0006\u0010@\u001a\u00020\u0005H\u0016J\u0010\u0010b\u001a\u00020:2\u0006\u0010!\u001a\u00020 H\u0002J$\u0010c\u001a\u00020 2\b\b\u0002\u0010d\u001a\u00020\u00052\b\b\u0002\u0010e\u001a\u00020\n2\b\b\u0002\u0010f\u001a\u00020\nJ\u0010\u0010g\u001a\u00020a2\b\b\u0002\u0010@\u001a\u00020\u0005J\u0006\u0010h\u001a\u00020\u0005J\u0006\u0010i\u001a\u00020\u0005J\f\u0010j\u001a\u00020\u0005*\u00020\u0005H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0010\"\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u000b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0018\"\u0004\b\u001c\u0010\u001aR\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0010\"\u0004\b\u001e\u0010\u0012R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\"\u001a\u00020 2\u0006\u0010!\u001a\u00020 8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u0018\"\u0004\b/\u0010\u001aR\u001c\u00100\u001a\u0004\u0018\u000101X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001a\u00106\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u0010\"\u0004\b8\u0010\u0012R\u0016\u0010A\u001a\n\u0012\u0004\u0012\u00020C\u0018\u00010BX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00050BX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006l"}, d2={"Lcom/ssblur/scriptor/screen/widget/TextField;", "Lnet/minecraft/client/gui/components/events/GuiEventListener;", "Lnet/minecraft/client/gui/narration/NarratableEntry;", "Lnet/minecraft/client/gui/components/Renderable;", "x", "", "y", "w", "h", "editable", "", "multiline", "color", "<init>", "(IIIIZZI)V", "getX", "()I", "setX", "(I)V", "getY", "setY", "getW", "getH", "getEditable", "()Z", "setEditable", "(Z)V", "getMultiline", "setMultiline", "getColor", "setColor", "textInternal", "", "value", "text", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "cursor", "Lcom/ssblur/scriptor/screen/widget/TextField$CursorPos;", "getCursor", "()Lcom/ssblur/scriptor/screen/widget/TextField$CursorPos;", "setCursor", "(Lcom/ssblur/scriptor/screen/widget/TextField$CursorPos;)V", "focus", "getFocus", "setFocus", "font", "Lnet/minecraft/client/gui/Font;", "getFont", "()Lnet/minecraft/client/gui/Font;", "setFont", "(Lnet/minecraft/client/gui/Font;)V", "scrollOffset", "getScrollOffset", "setScrollOffset", "setFocused", "", "bl", "mouseClicked", "d", "", "e", "i", "lines", "", "Lnet/minecraft/network/chat/FormattedText;", "lineStartIndices", "getIndexAtPosition", "clickX", "clickY", "splitLines", "moveCursorToIndex", "moveCursorToY", "moveCursorToX", "isFocused", "updateNarration", "narrationElementOutput", "Lnet/minecraft/client/gui/narration/NarrationElementOutput;", "narrationPriority", "Lnet/minecraft/client/gui/narration/NarratableEntry$NarrationPriority;", "render", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "j", "f", "", "mouseScrolled", "g", "keyPressed", "key", "modifier", "keyReleased", "k", "charTyped", "c", "", "insertText", "currentWord", "index", "crawlBackwards", "crawlForwards", "currentChar", "nextWhitespace", "prevWhitespace", "coerceToValid", "CursorPos", "scriptor"})
public final class TextField
implements GuiEventListener,
NarratableEntry,
Renderable {
    private int x;
    private int y;
    private final int w;
    private final int h;
    private boolean editable;
    private boolean multiline;
    private int color;
    @NotNull
    private String textInternal;
    @NotNull
    private CursorPos cursor;
    private boolean focus;
    @Nullable
    private Font font;
    private int scrollOffset;
    @Nullable
    private List<? extends FormattedText> lines;
    @NotNull
    private List<Integer> lineStartIndices;

    public TextField(int x, int y, int w, int h, boolean editable, boolean multiline, int color) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.editable = editable;
        this.multiline = multiline;
        this.color = color;
        this.textInternal = "";
        this.cursor = new CursorPos(0, 0, 0);
        this.lineStartIndices = CollectionsKt.listOf((Object)0);
    }

    public /* synthetic */ TextField(int n, int n2, int n3, int n4, boolean bl, boolean bl2, int n5, int n6, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n6 & 0x10) != 0) {
            bl = true;
        }
        if ((n6 & 0x20) != 0) {
            bl2 = true;
        }
        if ((n6 & 0x40) != 0) {
            n5 = 0;
        }
        this(n, n2, n3, n4, bl, bl2, n5);
    }

    public final int getX() {
        return this.x;
    }

    public final void setX(int n) {
        this.x = n;
    }

    public final int getY() {
        return this.y;
    }

    public final void setY(int n) {
        this.y = n;
    }

    public final int getW() {
        return this.w;
    }

    public final int getH() {
        return this.h;
    }

    public final boolean getEditable() {
        return this.editable;
    }

    public final void setEditable(boolean bl) {
        this.editable = bl;
    }

    public final boolean getMultiline() {
        return this.multiline;
    }

    public final void setMultiline(boolean bl) {
        this.multiline = bl;
    }

    public final int getColor() {
        return this.color;
    }

    public final void setColor(int n) {
        this.color = n;
    }

    @NotNull
    public final String getText() {
        return this.textInternal;
    }

    public final void setText(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!Intrinsics.areEqual((Object)value, (Object)this.textInternal)) {
            this.lines = null;
        }
        this.textInternal = value;
    }

    @NotNull
    public final CursorPos getCursor() {
        return this.cursor;
    }

    public final void setCursor(@NotNull CursorPos cursorPos) {
        Intrinsics.checkNotNullParameter((Object)cursorPos, (String)"<set-?>");
        this.cursor = cursorPos;
    }

    public final boolean getFocus() {
        return this.focus;
    }

    public final void setFocus(boolean bl) {
        this.focus = bl;
    }

    @Nullable
    public final Font getFont() {
        return this.font;
    }

    public final void setFont(@Nullable Font font) {
        this.font = font;
    }

    public final int getScrollOffset() {
        return this.scrollOffset;
    }

    public final void setScrollOffset(int n) {
        this.scrollOffset = n;
    }

    public void setFocused(boolean bl) {
        this.focus = bl;
    }

    public boolean mouseClicked(double d, double e, int i) {
        Font font;
        double clickX = d - (double)this.x;
        double clickY = e - (double)this.y;
        if (clickX > 0.0 && clickY > 0.0 && clickX < (double)this.w && clickY < (double)this.h && (font = this.font) != null) {
            Font it = font;
            boolean bl = false;
            this.cursor = this.getIndexAtPosition(it, clickX + (double)2, clickY);
            return true;
        }
        return super.mouseClicked(d, e, i);
    }

    @NotNull
    public final CursorPos getIndexAtPosition(@NotNull Font font, double clickX, double clickY) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        Objects.requireNonNull(font);
        int i = (int)Math.floor(clickY / (double)font.lineHeight) + this.scrollOffset;
        List<FormattedText> lines = this.splitLines();
        if (i < 0) {
            return new CursorPos(0, 0, 0);
        }
        if (i >= lines.size()) {
            if (lines.size() > 0) {
                return new CursorPos(((FormattedText)CollectionsKt.last(lines)).getString().length(), lines.size() - 1, this.getText().length());
            }
            return new CursorPos(0, 0, 0);
        }
        FormattedText line = lines.get(i);
        int x = font.getSplitter().plainIndexAtWidth(line.getString(), (int)Math.floor(clickX), Style.EMPTY);
        return new CursorPos(x, i, ((Number)this.lineStartIndices.get(i)).intValue() + x);
    }

    private final List<FormattedText> splitLines() {
        List list;
        if (this.lines == null) {
            if (this.multiline) {
                Font font = this.font;
                List<? extends FormattedText> list2 = this.lines = font != null && (font = font.getSplitter()) != null ? font.splitLines(FormattedText.of((String)this.getText()), this.w, Style.EMPTY) : null;
                if (list2 != null) {
                    List<? extends FormattedText> it = list2;
                    boolean bl = false;
                    List starts = new ArrayList();
                    int total = 0;
                    for (FormattedText formattedText : it) {
                        starts.add(total);
                        total += formattedText.getString().length();
                        while (total < this.getText().length() && CharsKt.isWhitespace((char)this.getText().charAt(total))) {
                            ++total;
                        }
                    }
                    this.lineStartIndices = starts;
                }
            } else {
                this.lineStartIndices = CollectionsKt.listOf((Object)0);
                this.lines = CollectionsKt.listOf((Object)FormattedText.of((String)this.getText()));
            }
        }
        if ((list = this.lines) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final void moveCursorToIndex(int i) {
        if (i <= 0 || this.splitLines().isEmpty()) {
            this.cursor = new CursorPos(0, 0, 0);
        }
        if (i > this.getText().length()) {
            this.moveCursorToIndex(this.getText().length());
            return;
        }
        int line = 0;
        int n = this.lineStartIndices.size() - 2;
        if (line <= n) {
            while (true) {
                if (((Number)this.lineStartIndices.get(line + 1)).intValue() > i) {
                    this.cursor = new CursorPos(i - ((Number)this.lineStartIndices.get(line)).intValue(), line, i);
                    return;
                }
                if (line == n) break;
                ++line;
            }
        }
        int last = this.lineStartIndices.isEmpty() ? 0 : ((Number)CollectionsKt.last(this.lineStartIndices)).intValue();
        this.cursor = new CursorPos(i - last, this.lineStartIndices.size() - 1, i);
    }

    public final void moveCursorToY(int i) {
        if (i < 0 || i >= this.splitLines().size()) {
            return;
        }
        if (i < this.scrollOffset) {
            this.scrollOffset = i;
        }
        if (i > this.scrollOffset + 7) {
            this.scrollOffset = i - 7;
        }
        int x = Math.min(this.splitLines().get(i).getString().length(), this.cursor.getX());
        x = Math.max(0, x);
        this.cursor = new CursorPos(x, i, ((Number)this.lineStartIndices.get(i)).intValue() + x);
    }

    public final void moveCursorToX(int i) {
        if (i < 0) {
            return;
        }
        int x = Math.min(this.splitLines().get(this.cursor.getY()).getString().length(), i);
        x = Math.max(x, 0);
        this.cursor = new CursorPos(x, this.cursor.getY(), ((Number)this.lineStartIndices.get(this.cursor.getY())).intValue() + x);
    }

    public boolean isFocused() {
        return this.focus;
    }

    public void updateNarration(@NotNull NarrationElementOutput narrationElementOutput) {
        Intrinsics.checkNotNullParameter((Object)narrationElementOutput, (String)"narrationElementOutput");
        narrationElementOutput.add(NarratedElementType.TITLE, this.getText());
    }

    @NotNull
    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.FOCUSED;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int i, int j, float f) {
        block11: {
            int cy;
            Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
            Font font = this.font;
            if (font == null) break block11;
            Font font2 = font;
            boolean bl = false;
            if (this.editable) {
                ClientLevel clientLevel = Minecraft.getInstance().level;
                if ((clientLevel != null ? clientLevel.getGameTime() : 0L) % (long)40 > 20L) {
                    try {
                        cy = (this.cursor.getY() - this.scrollOffset) * font2.lineHeight + this.y;
                        if (this.cursor.getY() - this.scrollOffset >= 0 && this.cursor.getY() - this.scrollOffset < 8) {
                            List<? extends FormattedText> list = this.lines;
                            if (list != null) {
                                List<? extends FormattedText> lines = list;
                                boolean bl2 = false;
                                StringSplitter stringSplitter = font2.getSplitter();
                                String string = lines.get(this.cursor.getY()).getString();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                                String string2 = string;
                                int n = 0;
                                int n2 = this.cursor.getX();
                                String string3 = string2.substring(n, n2);
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                                int cx = (int)stringSplitter.stringWidth(string3) + this.x - 1;
                                if (this.multiline && this.focus) {
                                    guiGraphics.drawString(font2, "|", cx, cy, 0xAAAAAA, false);
                                }
                            }
                        }
                    }
                    catch (StringIndexOutOfBoundsException cy2) {
                    }
                    catch (IndexOutOfBoundsException cy2) {
                        // empty catch block
                    }
                }
            }
            cy = this.y;
            int skip = this.scrollOffset;
            for (FormattedText line : this.splitLines()) {
                if (skip > 0) {
                    --skip;
                    continue;
                }
                if (cy + 2 * font2.lineHeight >= this.y + this.h && this.multiline) {
                    guiGraphics.drawString(font2, (Component)Component.translatable((String)"extra.scriptor.scroll"), this.x, cy, 0x777777, false);
                    break;
                }
                guiGraphics.drawString(font2, line.getString(), this.x, cy, this.color, false);
                cy += font2.lineHeight;
            }
        }
    }

    public boolean mouseScrolled(double d, double e, double f, double g) {
        if (this.multiline) {
            this.scrollOffset -= (int)Math.signum(g);
            this.scrollOffset = this.splitLines().size() >= 2 ? RangesKt.coerceIn((int)this.scrollOffset, (int)0, (int)(this.splitLines().size() - 1)) : 0;
        }
        return super.mouseScrolled(d, e, f, g);
    }

    public boolean keyPressed(int key, int j, int modifier) {
        if (this.editable && this.isFocused()) {
            switch (key) {
                case 263: {
                    if (modifier == 2) {
                        this.moveCursorToIndex(this.prevWhitespace());
                    } else {
                        this.moveCursorToIndex(this.cursor.getI() - 1);
                    }
                    return true;
                }
                case 262: {
                    if (modifier == 2) {
                        this.moveCursorToIndex(this.nextWhitespace());
                    } else {
                        this.moveCursorToIndex(this.cursor.getI() + 1);
                    }
                    return true;
                }
                case 265: {
                    if (this.multiline) {
                        this.moveCursorToY(this.cursor.getY() - 1);
                    }
                    return true;
                }
                case 264: {
                    if (this.multiline) {
                        this.moveCursorToY(this.cursor.getY() + 1);
                    }
                    return true;
                }
                case 268: {
                    this.moveCursorToX(0);
                    return true;
                }
                case 269: {
                    this.moveCursorToX(Integer.MAX_VALUE);
                    return true;
                }
                case 259: {
                    try {
                        String string = this.getText().substring(0, this.cursor.getI() - 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        String string2 = this.getText().substring(this.cursor.getI(), this.getText().length());
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                        this.setText(string + string2);
                        this.moveCursorToIndex(this.cursor.getI() - 1);
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    return true;
                }
                case 261: {
                    try {
                        String string = this.getText().substring(0, this.cursor.getI());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        String string3 = this.getText().substring(this.cursor.getI() + 1, this.getText().length());
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                        this.setText(string + string3);
                        this.moveCursorToIndex(this.cursor.getI());
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    return true;
                }
                case 69: {
                    return true;
                }
                case 260: {
                    if (modifier != 1) break;
                    String string = Minecraft.getInstance().keyboardHandler.getClipboard();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClipboard(...)");
                    this.insertText(string);
                    break;
                }
                case 86: {
                    if (modifier != 2) break;
                    String string = Minecraft.getInstance().keyboardHandler.getClipboard();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClipboard(...)");
                    this.insertText(string);
                }
            }
        }
        return super.keyPressed(key, j, modifier);
    }

    public boolean keyReleased(int i, int j, int k) {
        return super.keyReleased(i, j, k);
    }

    public boolean charTyped(char c, int i) {
        if (this.editable && this.isFocused()) {
            if (this.cursor.getI() > this.getText().length()) {
                this.moveCursorToIndex(this.getText().length());
            }
            String string = this.getText().substring(0, this.cursor.getI());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = this.getText().substring(this.cursor.getI(), this.getText().length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            this.setText(string + c + string2);
            this.moveCursorToIndex(this.cursor.getI() + 1);
            if (this.cursor.getY() > this.scrollOffset + 7) {
                this.scrollOffset = this.cursor.getY() - 7;
            }
        }
        return super.charTyped(c, i);
    }

    private final void insertText(String value) {
        try {
            String string = this.getText().substring(0, this.cursor.getI());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = this.getText().substring(this.cursor.getI());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            this.setText(string + value + string2);
            this.moveCursorToIndex(this.cursor.getI() + value.length());
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @NotNull
    public final String currentWord(int index, boolean crawlBackwards, boolean crawlForwards) {
        int wordEnd;
        int wordStart;
        if (crawlBackwards) {
            for (wordStart = RangesKt.coerceIn((int)index, (ClosedRange)((ClosedRange)StringsKt.getIndices((CharSequence)this.getText()))); wordStart > 0 && !CharsKt.isWhitespace((char)this.getText().charAt(wordStart)); --wordStart) {
            }
        }
        if (crawlForwards) {
            for (wordEnd = RangesKt.coerceIn((int)index, (ClosedRange)((ClosedRange)StringsKt.getIndices((CharSequence)this.getText()))); wordEnd < this.getText().length() && !CharsKt.isWhitespace((char)this.getText().charAt(wordEnd)); ++wordEnd) {
            }
        }
        String string = this.getText().substring(wordStart, wordEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    public static /* synthetic */ String currentWord$default(TextField textField, int n, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = textField.cursor.getI();
        }
        if ((n2 & 2) != 0) {
            bl = true;
        }
        if ((n2 & 4) != 0) {
            bl2 = true;
        }
        return textField.currentWord(n, bl, bl2);
    }

    public final char currentChar(int i) {
        int index = this.coerceToValid(i);
        if (index == 0) {
            return '-';
        }
        return this.getText().charAt(index);
    }

    public static /* synthetic */ char currentChar$default(TextField textField, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = textField.cursor.getI();
        }
        return textField.currentChar(n);
    }

    public final int nextWhitespace() {
        int index = this.coerceToValid(this.cursor.getI() + 1);
        while (true) {
            boolean bl = 0 <= index ? index < ((CharSequence)this.getText()).length() : false;
            if (!bl || CharsKt.isWhitespace((char)this.currentChar(index))) break;
            ++index;
        }
        return index;
    }

    public final int prevWhitespace() {
        int index = this.coerceToValid(this.cursor.getI() - 1);
        while (true) {
            boolean bl = 0 <= index ? index < ((CharSequence)this.getText()).length() : false;
            if (!bl || CharsKt.isWhitespace((char)this.currentChar(index - 1))) break;
            --index;
        }
        return index;
    }

    private final int coerceToValid(int $this$coerceToValid) {
        return RangesKt.coerceIn((int)$this$coerceToValid, (ClosedRange)((ClosedRange)new IntRange(0, RangesKt.coerceAtLeast((int)(this.getText().length() - 1), (int)0))));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/ssblur/scriptor/screen/widget/TextField$CursorPos;", "", "x", "", "y", "i", "<init>", "(III)V", "getX", "()I", "getY", "getI", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "scriptor"})
    public static final class CursorPos {
        private final int x;
        private final int y;
        private final int i;

        public CursorPos(int x, int y, int i) {
            this.x = x;
            this.y = y;
            this.i = i;
        }

        public final int getX() {
            return this.x;
        }

        public final int getY() {
            return this.y;
        }

        public final int getI() {
            return this.i;
        }

        public final int component1() {
            return this.x;
        }

        public final int component2() {
            return this.y;
        }

        public final int component3() {
            return this.i;
        }

        @NotNull
        public final CursorPos copy(int x, int y, int i) {
            return new CursorPos(x, y, i);
        }

        public static /* synthetic */ CursorPos copy$default(CursorPos cursorPos, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = cursorPos.x;
            }
            if ((n4 & 2) != 0) {
                n2 = cursorPos.y;
            }
            if ((n4 & 4) != 0) {
                n3 = cursorPos.i;
            }
            return cursorPos.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "CursorPos(x=" + this.x + ", y=" + this.y + ", i=" + this.i + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.x);
            result = result * 31 + Integer.hashCode(this.y);
            result = result * 31 + Integer.hashCode(this.i);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CursorPos)) {
                return false;
            }
            CursorPos cursorPos = (CursorPos)other;
            if (this.x != cursorPos.x) {
                return false;
            }
            if (this.y != cursorPos.y) {
                return false;
            }
            return this.i == cursorPos.i;
        }
    }
}

