/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word.action;

import com.ssblur.scriptor.api.word.Action;
import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.color.CustomColors;
import com.ssblur.scriptor.color.interfaces.Colorable;
import com.ssblur.scriptor.color.interfaces.ColorableBlock;
import com.ssblur.scriptor.color.interfaces.ColorableItem;
import com.ssblur.scriptor.helpers.ItemTargetableHelper;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.registry.colorable.ColorableBlockRegistry;
import com.ssblur.scriptor.registry.colorable.ColorableItemRegistry;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/ssblur/scriptor/word/action/ColorAction;", "Lcom/ssblur/scriptor/api/word/Action;", "<init>", "()V", "apply", "", "caster", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "targetable", "descriptors", "", "Lcom/ssblur/scriptor/api/word/Descriptor;", "(Lcom/ssblur/scriptor/helpers/targetable/Targetable;Lcom/ssblur/scriptor/helpers/targetable/Targetable;[Lcom/ssblur/scriptor/api/word/Descriptor;)V", "cost", "Lcom/ssblur/scriptor/api/word/Word$Cost;", "scriptor"})
public final class ColorAction
extends Action {
    @Override
    public void apply(@NotNull Targetable caster, @NotNull Targetable targetable, @NotNull Descriptor[] descriptors) {
        ItemStack itemTarget;
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        Intrinsics.checkNotNullParameter((Object)targetable, (String)"targetable");
        Intrinsics.checkNotNullParameter((Object)descriptors, (String)"descriptors");
        int color = CustomColors.INSTANCE.getColor(descriptors);
        if (targetable instanceof EntityTargetable && ((EntityTargetable)targetable).getTargetEntity() instanceof Colorable) {
            Entity entity = ((EntityTargetable)targetable).getTargetEntity();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type com.ssblur.scriptor.color.interfaces.Colorable");
            ((Colorable)entity).setColor(color);
        }
        if (!(itemTarget = ItemTargetableHelper.INSTANCE.getTargetItemStack(targetable)).isEmpty()) {
            if (itemTarget.getItem() instanceof ColorableItem) {
                Item item = itemTarget.getItem();
                Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type com.ssblur.scriptor.color.interfaces.ColorableItem");
                ItemStack itemStack = ((ColorableItem)item).setColor(color, itemTarget);
                Intrinsics.checkNotNull((Object)itemStack);
                ItemStack itemOut = itemStack;
                if (!itemOut.isEmpty()) {
                    itemTarget.setCount(0);
                    ItemTargetableHelper.INSTANCE.depositItemStack(targetable, itemOut);
                }
            } else {
                Item item = itemTarget.getItem();
                Intrinsics.checkNotNullExpressionValue((Object)item, (String)"getItem(...)");
                if (ColorableItemRegistry.INSTANCE.has(item)) {
                    Item item2 = itemTarget.getItem();
                    Intrinsics.checkNotNullExpressionValue((Object)item2, (String)"getItem(...)");
                    ColorableItem colorableItem = ColorableItemRegistry.INSTANCE.get(item2);
                    Intrinsics.checkNotNull((Object)colorableItem);
                    ItemStack itemStack = colorableItem.setColor(color, itemTarget);
                    Intrinsics.checkNotNull((Object)itemStack);
                    ItemStack itemOut = itemStack;
                    if (!itemOut.isEmpty()) {
                        itemTarget.setCount(0);
                        ItemTargetableHelper.INSTANCE.depositItemStack(targetable, itemOut);
                    }
                }
            }
            return;
        }
        BlockEntity blockEntity = targetable.getLevel().getBlockEntity(targetable.getOffsetBlockPos());
        if (blockEntity instanceof Colorable) {
            ((Colorable)blockEntity).setColor(color);
            return;
        }
        Block block = targetable.getLevel().getBlockState(targetable.getOffsetBlockPos()).getBlock();
        if (block instanceof ColorableBlock) {
            ((ColorableBlock)block).setColor(color, targetable.getLevel(), targetable.getOffsetBlockPos());
        } else {
            Intrinsics.checkNotNull((Object)block);
            if (ColorableBlockRegistry.INSTANCE.has(block)) {
                ColorableBlock colorableBlock = ColorableBlockRegistry.INSTANCE.get(block);
                Intrinsics.checkNotNull((Object)colorableBlock);
                colorableBlock.setColor(color, targetable.getLevel(), targetable.getOffsetBlockPos());
            }
        }
    }

    @Override
    @NotNull
    public Word.Cost cost() {
        return new Word.Cost(8.0, Word.COSTTYPE.ADDITIVE);
    }
}

