/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word.action;

import com.ssblur.scriptor.api.word.Action;
import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.helpers.ItemTargetableHelper;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/ssblur/scriptor/word/action/DryAction;", "Lcom/ssblur/scriptor/api/word/Action;", "<init>", "()V", "apply", "", "caster", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "targetable", "descriptors", "", "Lcom/ssblur/scriptor/api/word/Descriptor;", "(Lcom/ssblur/scriptor/helpers/targetable/Targetable;Lcom/ssblur/scriptor/helpers/targetable/Targetable;[Lcom/ssblur/scriptor/api/word/Descriptor;)V", "cost", "Lcom/ssblur/scriptor/api/word/Word$Cost;", "scriptor"})
public final class DryAction
extends Action {
    @Override
    public void apply(@NotNull Targetable caster, @NotNull Targetable targetable, @NotNull Descriptor[] descriptors) {
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        Intrinsics.checkNotNullParameter((Object)targetable, (String)"targetable");
        Intrinsics.checkNotNullParameter((Object)descriptors, (String)"descriptors");
        if (targetable.getLevel().isClientSide) {
            return;
        }
        ItemStack itemTarget = ItemTargetableHelper.INSTANCE.getTargetItemStack(targetable, false, DryAction::apply$lambda$0);
        if (!itemTarget.isEmpty() && itemTarget.getItem() instanceof BucketItem) {
            itemTarget.shrink(1);
            ItemTargetableHelper.INSTANCE.depositItemStack(caster, new ItemStack((ItemLike)Items.BUCKET));
        }
        BlockPos pos = targetable.getOffsetBlockPos();
        BlockState state = targetable.getLevel().getBlockState(pos);
        if (state.getBlock().defaultDestroyTime() < 0.0f) {
            return;
        }
        Level level = targetable.getLevel();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel level2 = (ServerLevel)level;
        Block block = state.getBlock();
        if (block instanceof LiquidBlock) {
            level2.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        } else if (block instanceof BucketPickup) {
            if (caster instanceof EntityTargetable && ((EntityTargetable)caster).getTargetEntity() instanceof Player) {
                BucketPickup bucketPickup = (BucketPickup)block;
                Entity entity = ((EntityTargetable)caster).getTargetEntity();
                Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
                v3 = bucketPickup.pickupBlock((Player)entity, (LevelAccessor)level2, pos, state);
            } else {
                v3 = ((BucketPickup)block).pickupBlock(null, (LevelAccessor)level2, pos, state);
            }
        }
    }

    @Override
    @NotNull
    public Word.Cost cost() {
        return new Word.Cost(0.6, Word.COSTTYPE.ADDITIVE);
    }

    private static final boolean apply$lambda$0(ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isEmpty() && it.isDamageableItem();
    }
}

