/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word.action;

import com.ssblur.scriptor.api.word.Action;
import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.word.descriptor.power.StrengthDescriptor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/ssblur/scriptor/word/action/ExplosionAction;", "Lcom/ssblur/scriptor/api/word/Action;", "<init>", "()V", "apply", "", "caster", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "targetable", "descriptors", "", "Lcom/ssblur/scriptor/api/word/Descriptor;", "(Lcom/ssblur/scriptor/helpers/targetable/Targetable;Lcom/ssblur/scriptor/helpers/targetable/Targetable;[Lcom/ssblur/scriptor/api/word/Descriptor;)V", "cost", "Lcom/ssblur/scriptor/api/word/Word$Cost;", "ExplosionActionDamageCalculator", "scriptor"})
public final class ExplosionAction
extends Action {
    @Override
    public void apply(@NotNull Targetable caster, @NotNull Targetable targetable, @NotNull Descriptor[] descriptors) {
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        Intrinsics.checkNotNullParameter((Object)targetable, (String)"targetable");
        Intrinsics.checkNotNullParameter((Object)descriptors, (String)"descriptors");
        if (targetable.getLevel().isClientSide) {
            return;
        }
        double strength = 2.0;
        for (Descriptor d : descriptors) {
            if (!(d instanceof StrengthDescriptor)) continue;
            strength += ((StrengthDescriptor)((Object)d)).strengthModifier();
        }
        Level level = targetable.getLevel();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel level2 = (ServerLevel)level;
        Vec3 pos = targetable.getTargetPos();
        float power = (float)Math.pow(strength, 0.7);
        level2.explode(null, null, (ExplosionDamageCalculator)new ExplosionActionDamageCalculator(caster), pos.x, pos.y + 0.25, pos.z, power, false, Level.ExplosionInteraction.TNT);
    }

    @Override
    @NotNull
    public Word.Cost cost() {
        return new Word.Cost(16.0, Word.COSTTYPE.ADDITIVE);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/ssblur/scriptor/word/action/ExplosionAction$ExplosionActionDamageCalculator;", "Lnet/minecraft/world/level/ExplosionDamageCalculator;", "caster", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "<init>", "(Lcom/ssblur/scriptor/helpers/targetable/Targetable;)V", "getCaster", "()Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "getEntityDamageAmount", "", "explosion", "Lnet/minecraft/world/level/Explosion;", "entity", "Lnet/minecraft/world/entity/Entity;", "scriptor"})
    public static final class ExplosionActionDamageCalculator
    extends ExplosionDamageCalculator {
        @NotNull
        private final Targetable caster;

        public ExplosionActionDamageCalculator(@NotNull Targetable caster) {
            Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
            this.caster = caster;
        }

        @NotNull
        public final Targetable getCaster() {
            return this.caster;
        }

        public float getEntityDamageAmount(@NotNull Explosion explosion, @NotNull Entity entity) {
            Intrinsics.checkNotNullParameter((Object)explosion, (String)"explosion");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            if (this.caster instanceof EntityTargetable && ((EntityTargetable)this.caster).getTargetEntity() == entity) {
                return super.getEntityDamageAmount(explosion, entity) * 0.15f;
            }
            return super.getEntityDamageAmount(explosion, entity) * 0.3f;
        }
    }
}

