/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word.action.bound;

import com.ssblur.scriptor.ScriptorMod;
import com.ssblur.scriptor.api.word.Action;
import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.color.CustomColors;
import com.ssblur.scriptor.data.components.ScriptorDataComponents;
import com.ssblur.scriptor.helpers.ItemTargetableHelper;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.item.ScriptorItems;
import com.ssblur.scriptor.word.descriptor.duration.DurationDescriptor;
import com.ssblur.scriptor.word.descriptor.power.StrengthDescriptor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/ssblur/scriptor/word/action/bound/BoundSwordAction;", "Lcom/ssblur/scriptor/api/word/Action;", "<init>", "()V", "apply", "", "caster", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "targetable", "descriptors", "", "Lcom/ssblur/scriptor/api/word/Descriptor;", "(Lcom/ssblur/scriptor/helpers/targetable/Targetable;Lcom/ssblur/scriptor/helpers/targetable/Targetable;[Lcom/ssblur/scriptor/api/word/Descriptor;)V", "cost", "Lcom/ssblur/scriptor/api/word/Word$Cost;", "scriptor"})
public final class BoundSwordAction
extends Action {
    @Override
    public void apply(@NotNull Targetable caster, @NotNull Targetable targetable, @NotNull Descriptor[] descriptors) {
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        Intrinsics.checkNotNullParameter((Object)targetable, (String)"targetable");
        Intrinsics.checkNotNullParameter((Object)descriptors, (String)"descriptors");
        double strength = 5.0;
        double duration = 4.0;
        int n = descriptors.length;
        for (int i = 0; i < n; ++i) {
            Descriptor d = descriptors[i];
            if (d instanceof StrengthDescriptor) {
                strength += ((StrengthDescriptor)((Object)d)).strengthModifier();
            }
            if (!(d instanceof DurationDescriptor)) continue;
            duration += ((DurationDescriptor)((Object)d)).durationModifier();
        }
        ItemStack itemStack = new ItemStack((ItemLike)ScriptorItems.INSTANCE.getBOUND_SWORD().get());
        itemStack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(CustomColors.INSTANCE.getColor(descriptors), false));
        itemStack.set(ScriptorDataComponents.INSTANCE.getEXPIRES(), (Object)(caster.getLevel().getGameTime() + (long)Math.floor(duration * (double)80)));
        double finalStrength = strength;
        itemStack.update(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY, arg_0 -> BoundSwordAction.apply$lambda$0(finalStrength, arg_0));
        ItemTargetableHelper.INSTANCE.depositItemStack(targetable, itemStack);
    }

    @Override
    @NotNull
    public Word.Cost cost() {
        return new Word.Cost(6.0, Word.COSTTYPE.ADDITIVE);
    }

    private static final ItemAttributeModifiers apply$lambda$0(double $finalStrength, ItemAttributeModifiers modifiers) {
        Intrinsics.checkNotNullParameter((Object)modifiers, (String)"modifiers");
        return modifiers.withModifierAdded(Attributes.ATTACK_DAMAGE, new AttributeModifier(ScriptorMod.INSTANCE.location("bound_sword"), $finalStrength, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
    }
}

