/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word.action.bound;

import com.ssblur.scriptor.api.word.Action;
import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.color.CustomColors;
import com.ssblur.scriptor.data.components.ScriptorDataComponents;
import com.ssblur.scriptor.helpers.ItemTargetableHelper;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.word.descriptor.duration.DurationDescriptor;
import com.ssblur.scriptor.word.descriptor.power.StrengthDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ+\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016R \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR&\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/ssblur/scriptor/word/action/bound/BoundToolAction;", "Lcom/ssblur/scriptor/api/word/Action;", "item", "Ljava/util/function/Supplier;", "Lnet/minecraft/world/item/Item;", "tags", "", "Lnet/minecraft/tags/TagKey;", "Lnet/minecraft/world/level/block/Block;", "<init>", "(Ljava/util/function/Supplier;Ljava/util/List;)V", "getItem", "()Ljava/util/function/Supplier;", "setItem", "(Ljava/util/function/Supplier;)V", "getTags", "()Ljava/util/List;", "setTags", "(Ljava/util/List;)V", "apply", "", "caster", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "targetable", "descriptors", "", "Lcom/ssblur/scriptor/api/word/Descriptor;", "(Lcom/ssblur/scriptor/helpers/targetable/Targetable;Lcom/ssblur/scriptor/helpers/targetable/Targetable;[Lcom/ssblur/scriptor/api/word/Descriptor;)V", "cost", "Lcom/ssblur/scriptor/api/word/Word$Cost;", "Companion", "scriptor"})
public final class BoundToolAction
extends Action {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Supplier<Item> item;
    @NotNull
    private List<TagKey<Block>> tags;
    @NotNull
    private static final TagKey<Block> NEEDS_STONE_TOOL;
    @NotNull
    private static final TagKey<Block> NEEDS_IRON_TOOL;
    @NotNull
    private static final TagKey<Block> NEEDS_DIAMOND_TOOL;
    @NotNull
    private static final TagKey<Block> NEEDS_NETHERITE_TOOL;

    public BoundToolAction(@NotNull Supplier<Item> item, @NotNull List<TagKey<Block>> tags) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        this.item = item;
        this.tags = tags;
    }

    @NotNull
    public final Supplier<Item> getItem() {
        return this.item;
    }

    public final void setItem(@NotNull Supplier<Item> supplier) {
        Intrinsics.checkNotNullParameter(supplier, (String)"<set-?>");
        this.item = supplier;
    }

    @NotNull
    public final List<TagKey<Block>> getTags() {
        return this.tags;
    }

    public final void setTags(@NotNull List<TagKey<Block>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.tags = list;
    }

    @Override
    public void apply(@NotNull Targetable caster, @NotNull Targetable targetable, @NotNull Descriptor[] descriptors) {
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        Intrinsics.checkNotNullParameter((Object)targetable, (String)"targetable");
        Intrinsics.checkNotNullParameter((Object)descriptors, (String)"descriptors");
        float strength = 6.0f;
        double duration = 4.0;
        int n = descriptors.length;
        for (int i = 0; i < n; ++i) {
            Descriptor d = descriptors[i];
            if (d instanceof StrengthDescriptor) {
                strength += (float)((StrengthDescriptor)((Object)d)).strengthModifier();
            }
            if (!(d instanceof DurationDescriptor)) continue;
            duration += ((DurationDescriptor)((Object)d)).durationModifier();
        }
        ItemStack itemStack = new ItemStack((ItemLike)this.item.get());
        itemStack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(CustomColors.INSTANCE.getColor(descriptors), false));
        itemStack.set(ScriptorDataComponents.INSTANCE.getEXPIRES(), (Object)(caster.getLevel().getGameTime() + (long)Math.floor(duration * (double)80)));
        int finalStrength = (int)(strength * 0.666f);
        int finalToolLevel = finalStrength / 2;
        itemStack.set(ScriptorDataComponents.INSTANCE.getTOOL_MINING_LEVEL(), (Object)finalToolLevel);
        itemStack.update(DataComponents.TOOL, (Object)new Tool(CollectionsKt.emptyList(), 1.0f, 1), arg_0 -> BoundToolAction.apply$lambda$2(finalToolLevel, this, finalStrength, arg_0));
        ItemTargetableHelper.INSTANCE.depositItemStack(targetable, itemStack);
    }

    @Override
    @NotNull
    public Word.Cost cost() {
        return new Word.Cost(6.0, Word.COSTTYPE.ADDITIVE);
    }

    private static final Tool.Rule apply$lambda$2$lambda$0(int $finalStrength, TagKey it) {
        return Tool.Rule.minesAndDrops((TagKey)it, (float)$finalStrength);
    }

    private static final Tool.Rule apply$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Tool.Rule)$tmp0.invoke(p0);
    }

    private static final Tool apply$lambda$2(int $finalToolLevel, BoundToolAction this$0, int $finalStrength, Tool tool) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        List rules = new ArrayList();
        if ($finalToolLevel < 1) {
            Tool.Rule rule = Tool.Rule.deniesDrops(NEEDS_STONE_TOOL);
            Intrinsics.checkNotNullExpressionValue((Object)rule, (String)"deniesDrops(...)");
            rules.add(rule);
        }
        if ($finalToolLevel < 2) {
            Tool.Rule rule = Tool.Rule.deniesDrops(NEEDS_IRON_TOOL);
            Intrinsics.checkNotNullExpressionValue((Object)rule, (String)"deniesDrops(...)");
            rules.add(rule);
        }
        if ($finalToolLevel < 3) {
            Tool.Rule rule = Tool.Rule.deniesDrops(NEEDS_DIAMOND_TOOL);
            Intrinsics.checkNotNullExpressionValue((Object)rule, (String)"deniesDrops(...)");
            rules.add(rule);
        }
        if ($finalToolLevel < 4) {
            Tool.Rule rule = Tool.Rule.deniesDrops(NEEDS_NETHERITE_TOOL);
            Intrinsics.checkNotNullExpressionValue((Object)rule, (String)"deniesDrops(...)");
            rules.add(rule);
        }
        List<Tool.Rule> list = this$0.tags.stream().map(arg_0 -> BoundToolAction.apply$lambda$2$lambda$1(arg_0 -> BoundToolAction.apply$lambda$2$lambda$0($finalStrength, arg_0), arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        rules.addAll((Collection)list);
        return new Tool(rules, 1.0f, tool.damagePerBlock());
    }

    static {
        TagKey tagKey = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"needs_stone_tool"));
        Intrinsics.checkNotNullExpressionValue((Object)tagKey, (String)"create(...)");
        NEEDS_STONE_TOOL = tagKey;
        TagKey tagKey2 = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"needs_iron_tool"));
        Intrinsics.checkNotNullExpressionValue((Object)tagKey2, (String)"create(...)");
        NEEDS_IRON_TOOL = tagKey2;
        TagKey tagKey3 = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"needs_diamond_tool"));
        Intrinsics.checkNotNullExpressionValue((Object)tagKey3, (String)"create(...)");
        NEEDS_DIAMOND_TOOL = tagKey3;
        TagKey tagKey4 = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"needs_netherite_tool"));
        Intrinsics.checkNotNullExpressionValue((Object)tagKey4, (String)"create(...)");
        NEEDS_NETHERITE_TOOL = tagKey4;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/ssblur/scriptor/word/action/bound/BoundToolAction$Companion;", "", "<init>", "()V", "NEEDS_STONE_TOOL", "Lnet/minecraft/tags/TagKey;", "Lnet/minecraft/world/level/block/Block;", "getNEEDS_STONE_TOOL", "()Lnet/minecraft/tags/TagKey;", "NEEDS_IRON_TOOL", "getNEEDS_IRON_TOOL", "NEEDS_DIAMOND_TOOL", "getNEEDS_DIAMOND_TOOL", "NEEDS_NETHERITE_TOOL", "getNEEDS_NETHERITE_TOOL", "scriptor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TagKey<Block> getNEEDS_STONE_TOOL() {
            return NEEDS_STONE_TOOL;
        }

        @NotNull
        public final TagKey<Block> getNEEDS_IRON_TOOL() {
            return NEEDS_IRON_TOOL;
        }

        @NotNull
        public final TagKey<Block> getNEEDS_DIAMOND_TOOL() {
            return NEEDS_DIAMOND_TOOL;
        }

        @NotNull
        public final TagKey<Block> getNEEDS_NETHERITE_TOOL() {
            return NEEDS_NETHERITE_TOOL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

