/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word.descriptor.discount;

import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.InventoryTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.word.descriptor.AfterCastDescriptor;
import com.ssblur.scriptor.word.descriptor.CastDescriptor;
import com.ssblur.scriptor.word.descriptor.power.StrengthDescriptor;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001\u001fB\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0007\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0018H\u0016J\u0012\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010\u001e\u001a\u00020\bH\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\t\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/ssblur/scriptor/word/descriptor/discount/ReagentDescriptor;", "Lcom/ssblur/scriptor/api/word/Descriptor;", "Lcom/ssblur/scriptor/word/descriptor/CastDescriptor;", "Lcom/ssblur/scriptor/word/descriptor/AfterCastDescriptor;", "Lcom/ssblur/scriptor/word/descriptor/power/StrengthDescriptor;", "item", "Lnet/minecraft/world/item/Item;", "cost", "", "strength", "<init>", "(Lnet/minecraft/world/item/Item;DD)V", "getItem", "()Lnet/minecraft/world/item/Item;", "setItem", "(Lnet/minecraft/world/item/Item;)V", "getCost", "()D", "setCost", "(D)V", "getStrength", "setStrength", "Lcom/ssblur/scriptor/api/word/Word$Cost;", "cannotCast", "", "caster", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "allowsDuplicates", "afterCast", "", "strengthModifier", "Companion", "scriptor"})
public final class ReagentDescriptor
extends Descriptor
implements CastDescriptor,
AfterCastDescriptor,
StrengthDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Item item;
    private double cost;
    private double strength;
    @NotNull
    private static HashMap<Item, Integer> runningTotals = new HashMap();

    public ReagentDescriptor(@NotNull Item item, double cost, double strength) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.item = item;
        this.cost = cost;
        this.strength = strength;
    }

    @NotNull
    public final Item getItem() {
        return this.item;
    }

    public final void setItem(@NotNull Item item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"<set-?>");
        this.item = item;
    }

    public final double getCost() {
        return this.cost;
    }

    public final void setCost(double d) {
        this.cost = d;
    }

    public final double getStrength() {
        return this.strength;
    }

    public final void setStrength(double d) {
        this.strength = d;
    }

    @Override
    @NotNull
    public Word.Cost cost() {
        return Word.Cost.Companion.add(-this.cost);
    }

    @Override
    public boolean cannotCast(@Nullable Targetable caster) {
        Container container;
        int c = ((Number)runningTotals.getOrDefault(this.item, 0)).intValue() + 1;
        Integer n = c;
        ((Map)runningTotals).put(this.item, n);
        if (caster instanceof InventoryTargetable && ((InventoryTargetable)((Object)caster)).getContainer() != null) {
            v0 = ((InventoryTargetable)((Object)caster)).getContainer();
        } else if (caster instanceof EntityTargetable && ((EntityTargetable)caster).getTargetEntity() instanceof Player) {
            Entity entity = ((EntityTargetable)caster).getTargetEntity();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
            v0 = (Container)((Player)entity).getInventory();
        } else {
            v0 = container = null;
        }
        if (container != null && container.countItem(this.item) >= c) {
            return false;
        }
        runningTotals.remove(this.item);
        return true;
    }

    @Override
    public boolean allowsDuplicates() {
        return true;
    }

    @Override
    public void afterCast(@Nullable Targetable caster) {
        Container container;
        Integer n = runningTotals.getOrDefault(this.item, 0);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getOrDefault(...)");
        int c = ((Number)n).intValue();
        runningTotals.remove(this.item);
        if (caster instanceof InventoryTargetable && ((InventoryTargetable)((Object)caster)).getContainer() != null) {
            container = ((InventoryTargetable)((Object)caster)).getContainer();
        } else if (caster instanceof EntityTargetable && ((EntityTargetable)caster).getTargetEntity() instanceof Player) {
            Entity entity = ((EntityTargetable)caster).getTargetEntity();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
            container = (Container)((Player)entity).getInventory();
        } else {
            if (caster instanceof EntityTargetable) {
                ((EntityTargetable)caster).getTargetEntity().kill();
                return;
            }
            return;
        }
        Container container2 = container;
        Container container3 = container2;
        Intrinsics.checkNotNull((Object)container3);
        int n2 = container3.getContainerSize();
        for (int i = 0; i < n2; ++i) {
            if (container2.getItem(i).getItem() != this.item) continue;
            int maxSize = (int)Math.min((double)container2.getItem(i).getCount(), (double)c);
            container2.getItem(i).shrink(maxSize);
            if ((c -= maxSize) > 0) continue;
            return;
        }
    }

    @Override
    public double strengthModifier() {
        return this.strength;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R8\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\bj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lcom/ssblur/scriptor/word/descriptor/discount/ReagentDescriptor$Companion;", "", "<init>", "()V", "runningTotals", "Lkotlin/collections/HashMap;", "Lnet/minecraft/world/item/Item;", "", "Ljava/util/HashMap;", "getRunningTotals", "()Ljava/util/HashMap;", "setRunningTotals", "(Ljava/util/HashMap;)V", "Ljava/util/HashMap;", "scriptor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HashMap<Item, Integer> getRunningTotals() {
            return runningTotals;
        }

        public final void setRunningTotals(@NotNull HashMap<Item, Integer> hashMap) {
            Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
            runningTotals = hashMap;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

