/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word.subject;

import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Subject;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.color.CustomColors;
import com.ssblur.scriptor.entity.ScriptorEntities;
import com.ssblur.scriptor.entity.ScriptorProjectile;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.word.Spell;
import com.ssblur.scriptor.word.descriptor.SpeedDescriptor;
import com.ssblur.scriptor.word.descriptor.duration.DurationDescriptor;
import com.ssblur.scriptor.word.descriptor.target.CollideWithWaterDescriptor;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J$\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/ssblur/scriptor/word/subject/ProjectileSubject;", "Lcom/ssblur/scriptor/api/word/Subject;", "<init>", "()V", "cost", "Lcom/ssblur/scriptor/api/word/Word$Cost;", "getTargets", "Ljava/util/concurrent/CompletableFuture;", "", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "caster", "spell", "Lcom/ssblur/scriptor/word/Spell;", "scriptor"})
public final class ProjectileSubject
extends Subject {
    @Override
    @NotNull
    public Word.Cost cost() {
        return new Word.Cost(3.0, Word.COSTTYPE.ADDITIVE);
    }

    @Override
    @NotNull
    public CompletableFuture<List<Targetable>> getTargets(@NotNull Targetable caster, @NotNull Spell spell) {
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        Intrinsics.checkNotNullParameter((Object)spell, (String)"spell");
        CompletableFuture<List<Targetable>> future = new CompletableFuture<List<Targetable>>();
        int color = CustomColors.INSTANCE.getColor(spell.deduplicatedDescriptorsForSubjects());
        double duration = 12.0;
        double speed = 1.0;
        boolean collidesWithWater = false;
        for (Descriptor d : spell.deduplicatedDescriptorsForSubjects()) {
            if (d instanceof DurationDescriptor) {
                duration += ((DurationDescriptor)((Object)d)).durationModifier();
            }
            if (d instanceof SpeedDescriptor) {
                speed *= ((SpeedDescriptor)((Object)d)).speedModifier();
            }
            if (!Intrinsics.areEqual((Object)d, (Object)CollideWithWaterDescriptor.INSTANCE)) continue;
            collidesWithWater = true;
        }
        speed *= 0.8;
        Entity entity = ((EntityType)ScriptorEntities.INSTANCE.getPROJECTILE_TYPE().get()).create(caster.getLevel());
        Intrinsics.checkNotNull((Object)entity);
        ScriptorProjectile projectile = (ScriptorProjectile)entity;
        projectile.setCollidesWithWater(collidesWithWater);
        if (caster instanceof EntityTargetable) {
            Entity entity2 = ((EntityTargetable)caster).getTargetEntity();
            projectile.setPos(entity2.getEyePosition());
            projectile.setDeltaMovement(entity2.getLookAngle().normalize().scale(speed));
            projectile.setOwner(entity2);
        } else {
            projectile.setPos(caster.getTargetPos());
            Vec3i normal = caster.getFacing().getNormal();
            projectile.setDeltaMovement(new Vec3((double)normal.getX(), (double)normal.getY(), (double)normal.getZ()).scale(speed));
        }
        projectile.setOrigin(caster.getOrigin());
        projectile.setDuration((int)Math.round((double)10 * duration));
        projectile.setColor(color);
        projectile.setCompletable(future);
        caster.getLevel().addFreshEntity((Entity)projectile);
        return future;
    }
}

