/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.block;

import com.ssblur.scriptor.blockentity.ChalkBlockEntity;
import com.ssblur.scriptor.blockentity.ScriptorBlockEntities;
import com.ssblur.scriptor.data.components.DictionaryData;
import com.ssblur.scriptor.data.components.ScriptorDataComponents;
import com.ssblur.scriptor.item.ScriptorItems;
import com.ssblur.unfocused.extension.BlockEntityTypeExtension;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004B\u0011\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0003\u0010\u0007J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016JB\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J0\u0010 \u001a\u00020!2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016\u00a8\u0006\""}, d2={"Lcom/ssblur/scriptor/block/ChalkBlock;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/EntityBlock;", "<init>", "()V", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "blockGetter", "Lnet/minecraft/world/level/BlockGetter;", "blockPos", "Lnet/minecraft/core/BlockPos;", "collisionContext", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "useItemOn", "Lnet/minecraft/world/ItemInteractionResult;", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "interactionHand", "Lnet/minecraft/world/InteractionHand;", "blockHitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "useWithoutItem", "Lnet/minecraft/world/InteractionResult;", "scriptor"})
public class ChalkBlock
extends Block
implements EntityBlock {
    public ChalkBlock() {
        super(BlockBehaviour.Properties.of().instabreak().noLootTable().sound(SoundType.STONE).noCollission());
    }

    public ChalkBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull CollisionContext collisionContext) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)blockGetter, (String)"blockGetter");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)collisionContext, (String)"collisionContext");
        VoxelShape voxelShape = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"box(...)");
        return voxelShape;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return BlockEntityTypeExtension.INSTANCE.create(ScriptorBlockEntities.INSTANCE.getCHALK(), blockPos, blockState);
    }

    @Nullable
    protected ItemInteractionResult useItemOn(@NotNull ItemStack itemStack, @NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult blockHitResult) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)interactionHand, (String)"interactionHand");
        Intrinsics.checkNotNullParameter((Object)blockHitResult, (String)"blockHitResult");
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof ChalkBlockEntity)) {
            return super.useItemOn(itemStack, blockState, level, blockPos, player, interactionHand, blockHitResult);
        }
        if (itemStack.is((Item)ScriptorItems.INSTANCE.getDICTIONARY().get())) {
            DictionaryData dictionaryData = (DictionaryData)itemStack.get(ScriptorDataComponents.INSTANCE.getDICTIONARY_DATA());
            if (dictionaryData == null) {
                dictionaryData = new DictionaryData(CollectionsKt.emptyList());
            }
            DictionaryData data = dictionaryData;
            itemStack.set(ScriptorDataComponents.INSTANCE.getDICTIONARY_DATA(), (Object)DictionaryData.withWord$default(data, ((ChalkBlockEntity)blockEntity).getWord(), null, false, 6, null));
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(itemStack, blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull BlockHitResult blockHitResult) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)blockHitResult, (String)"blockHitResult");
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof ChalkBlockEntity) {
            ((ChalkBlockEntity)blockEntity).cast();
            return InteractionResult.SUCCESS;
        }
        InteractionResult interactionResult = super.useWithoutItem(blockState, level, blockPos, player, blockHitResult);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useWithoutItem(...)");
        return interactionResult;
    }
}

