/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.blockentity.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.ssblur.scriptor.blockentity.LightBlockEntity;
import com.ssblur.scriptor.color.CustomColors;
import com.ssblur.scriptor.particle.MagicParticleData;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Random;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J8\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/ssblur/scriptor/blockentity/renderers/LightBlockEntityRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Lcom/ssblur/scriptor/blockentity/LightBlockEntity;", "context", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "render", "", "light", "tickDelta", "", "matrix", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffers", "Lnet/minecraft/client/renderer/MultiBufferSource;", "lightLevel", "", "j", "scriptor"})
public final class LightBlockEntityRenderer
implements BlockEntityRenderer<LightBlockEntity> {
    public LightBlockEntityRenderer(@Nullable BlockEntityRendererProvider.Context context) {
    }

    public void render(@NotNull LightBlockEntity light, float tickDelta, @NotNull PoseStack matrix, @NotNull MultiBufferSource buffers, int lightLevel, int j) {
        Intrinsics.checkNotNullParameter((Object)light, (String)"light");
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        Intrinsics.checkNotNullParameter((Object)buffers, (String)"buffers");
        if (light.getLevel() == null) {
            return;
        }
        int n = light.getColor();
        Level level = light.getLevel();
        Intrinsics.checkNotNull((Object)level);
        int c = CustomColors.INSTANCE.getColor(n, (float)level.getGameTime() + tickDelta);
        int r = (c & 0xFF0000) >> 16;
        int g = (c & 0xFF00) >> 8;
        int b = c & 0xFF;
        Random random = new Random();
        if (random.nextFloat() < 0.9f) {
            return;
        }
        float xd = 0.25f + random.nextFloat() / 2.0f;
        float yd = 0.25f + random.nextFloat() / 2.0f;
        float zd = 0.25f + random.nextFloat() / 2.0f;
        if (!Minecraft.getInstance().isPaused()) {
            Level level2 = light.getLevel();
            Intrinsics.checkNotNull((Object)level2);
            level2.addParticle((ParticleOptions)MagicParticleData.Companion.magic(r, g, b), (double)((float)light.getBlockPos().getX() + xd), (double)((float)light.getBlockPos().getY() + yd), (double)((float)light.getBlockPos().getZ() + zd), 0.0, 0.0, 0.0);
        }
    }
}

