/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.blockentity.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.ssblur.scriptor.blockentity.PhasedBlockBlockEntity;
import com.ssblur.scriptor.mixin.BlockRenderDispatcherAccessor;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J8\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/ssblur/scriptor/blockentity/renderers/PhasedBlockBlockEntityRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Lcom/ssblur/scriptor/blockentity/PhasedBlockBlockEntity;", "context", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "getContext", "()Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "setContext", "render", "", "blockEntity", "f", "", "matrix", "Lcom/mojang/blaze3d/vertex/PoseStack;", "multiBufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "i", "", "j", "scriptor"})
public final class PhasedBlockBlockEntityRenderer
implements BlockEntityRenderer<PhasedBlockBlockEntity> {
    @NotNull
    private BlockEntityRendererProvider.Context context;

    public PhasedBlockBlockEntityRenderer(@NotNull BlockEntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final BlockEntityRendererProvider.Context getContext() {
        return this.context;
    }

    public final void setContext(@NotNull BlockEntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
        this.context = context;
    }

    public void render(@NotNull PhasedBlockBlockEntity blockEntity, float f, @NotNull PoseStack matrix, @NotNull MultiBufferSource multiBufferSource, int i, int j) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        Intrinsics.checkNotNullParameter((Object)multiBufferSource, (String)"multiBufferSource");
        BlockState blockState = blockEntity.getPhasedBlockState();
        Level level = blockEntity.getLevel();
        if (blockState == null || level == null) {
            return;
        }
        BlockRenderDispatcher dispatcher = this.context.getBlockRenderDispatcher();
        VertexConsumer buffer = multiBufferSource.getBuffer(Sheets.translucentCullBlockSheet());
        BakedModel model = dispatcher.getBlockModel(blockState);
        RandomSource randomSource = RandomSource.create();
        PoseStack.Pose pose = matrix.last();
        Intrinsics.checkNotNull((Object)dispatcher, (String)"null cannot be cast to non-null type com.ssblur.scriptor.mixin.BlockRenderDispatcherAccessor");
        int color = ((BlockRenderDispatcherAccessor)dispatcher).getBlockColors().getColor(blockState, null, null, 0);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = 1.0f - 0.8f * blockEntity.getAnim();
        float ra = 0.0f;
        float ga = 0.0f;
        float ba = 0.0f;
        for (Direction direction : EntriesMappings.entries$0) {
            randomSource.setSeed(42L);
            for (BakedQuad bakedQuad : model.getQuads(blockState, direction, randomSource)) {
                if (bakedQuad.isTinted()) {
                    ra = Mth.clamp((float)r, (float)0.0f, (float)1.0f);
                    ga = Mth.clamp((float)g, (float)0.0f, (float)1.0f);
                    ba = Mth.clamp((float)b, (float)0.0f, (float)1.0f);
                } else {
                    ra = 1.0f;
                    ga = 1.0f;
                    ba = 1.0f;
                }
                buffer.putBulkData(pose, bakedQuad, ra, ga, ba, a, i, j);
            }
        }
        randomSource.setSeed(42L);
        for (BakedQuad bakedQuad : model.getQuads(blockState, null, randomSource)) {
            if (bakedQuad.isTinted()) {
                ra = Mth.clamp((float)r, (float)0.0f, (float)1.0f);
                ga = Mth.clamp((float)g, (float)0.0f, (float)1.0f);
                ba = Mth.clamp((float)b, (float)0.0f, (float)1.0f);
            } else {
                ra = 1.0f;
                ga = 1.0f;
                ba = 1.0f;
            }
            buffer.putBulkData(pose, bakedQuad, ra, ga, ba, a, i, j);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Direction> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
        }
    }
}

