/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.helpers;

import com.ssblur.scriptor.helpers.targetable.InventoryTargetable;
import com.ssblur.scriptor.helpers.targetable.ItemTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bJ\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0005\u00a8\u0006\u0010"}, d2={"Lcom/ssblur/scriptor/helpers/ItemTargetableHelper;", "", "<init>", "()V", "getTargetItemStack", "Lnet/minecraft/world/item/ItemStack;", "targetable", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "aggressive", "", "condition", "Ljava/util/function/Predicate;", "getTargetItemStackAggressively", "depositItemStack", "", "itemStack", "scriptor"})
public final class ItemTargetableHelper {
    @NotNull
    public static final ItemTargetableHelper INSTANCE = new ItemTargetableHelper();

    private ItemTargetableHelper() {
    }

    @NotNull
    public final ItemStack getTargetItemStack(@NotNull Targetable targetable, boolean aggressive) {
        Intrinsics.checkNotNullParameter((Object)targetable, (String)"targetable");
        if (targetable instanceof ItemTargetable && (((ItemTargetable)targetable).shouldTargetItem() || aggressive)) {
            return ((ItemTargetable)targetable).getTargetItem();
        }
        if (targetable instanceof InventoryTargetable && ((InventoryTargetable)((Object)targetable)).getContainer() != null) {
            int slot = ((InventoryTargetable)((Object)targetable)).shouldIgnoreTargetedSlot() ? ((InventoryTargetable)((Object)targetable)).getFirstFilledSlot() : ((InventoryTargetable)((Object)targetable)).getTargetedSlot();
            Container container = ((InventoryTargetable)((Object)targetable)).getContainer();
            Intrinsics.checkNotNull((Object)container);
            ItemStack itemStack = container.getItem(slot);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
            return itemStack;
        }
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        return itemStack;
    }

    @NotNull
    public final ItemStack getTargetItemStack(@NotNull Targetable targetable, boolean aggressive, @NotNull Predicate<ItemStack> condition) {
        Intrinsics.checkNotNullParameter((Object)targetable, (String)"targetable");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        if (targetable instanceof ItemTargetable && (((ItemTargetable)targetable).shouldTargetItem() || aggressive)) {
            if (condition.test(((ItemTargetable)targetable).getTargetItem())) {
                return ((ItemTargetable)targetable).getTargetItem();
            }
        } else if (targetable instanceof InventoryTargetable && ((InventoryTargetable)((Object)targetable)).getContainer() != null) {
            int slot;
            int n = slot = ((InventoryTargetable)((Object)targetable)).shouldIgnoreTargetedSlot() ? ((InventoryTargetable)((Object)targetable)).getFirstMatchingSlot(condition) : ((InventoryTargetable)((Object)targetable)).getTargetedSlot();
            if (slot >= 0) {
                Container container = ((InventoryTargetable)((Object)targetable)).getContainer();
                Intrinsics.checkNotNull((Object)container);
                if (condition.test(container.getItem(slot))) {
                    Container container2 = ((InventoryTargetable)((Object)targetable)).getContainer();
                    Intrinsics.checkNotNull((Object)container2);
                    ItemStack itemStack = container2.getItem(slot);
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
                    return itemStack;
                }
            }
        }
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        return itemStack;
    }

    @NotNull
    public final ItemStack getTargetItemStack(@NotNull Targetable targetable) {
        Intrinsics.checkNotNullParameter((Object)targetable, (String)"targetable");
        return this.getTargetItemStack(targetable, false);
    }

    @NotNull
    public final ItemStack getTargetItemStackAggressively(@NotNull Targetable targetable) {
        Intrinsics.checkNotNullParameter((Object)targetable, (String)"targetable");
        return this.getTargetItemStack(targetable, true);
    }

    public final void depositItemStack(@NotNull Targetable targetable, @NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)targetable, (String)"targetable");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        if (targetable instanceof InventoryTargetable && ((InventoryTargetable)((Object)targetable)).getContainer() != null) {
            int slot = ((InventoryTargetable)((Object)targetable)).getFirstMatchingSlotNotEmpty(itemStack);
            if (slot >= 0) {
                Container container = ((InventoryTargetable)((Object)targetable)).getContainer();
                Intrinsics.checkNotNull((Object)container);
                ItemStack itemStack2 = container.getItem(slot);
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getItem(...)");
                ItemStack item = itemStack2;
                if (item.getCount() + itemStack.getCount() < item.getMaxStackSize()) {
                    item.grow(itemStack.getCount());
                    return;
                }
                int diff = item.getMaxStackSize() - item.getCount();
                item.grow(diff);
                itemStack.shrink(diff);
            }
            if ((slot = ((InventoryTargetable)((Object)targetable)).getFirstMatchingSlot(ItemTargetableHelper::depositItemStack$lambda$0)) >= 0) {
                Container container = ((InventoryTargetable)((Object)targetable)).getContainer();
                Intrinsics.checkNotNull((Object)container);
                container.setItem(slot, itemStack.copy());
                return;
            }
        }
        if (targetable instanceof ItemTargetable && ((ItemTargetable)targetable).getTargetEntity() instanceof Player) {
            Entity entity = ((ItemTargetable)targetable).getTargetEntity();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
            if (((Player)entity).addItem(itemStack)) {
                return;
            }
        }
        Vec3 pos = targetable.getTargetPos();
        ItemEntity entity = new ItemEntity(targetable.getLevel(), pos.x(), pos.y() + 1.0, pos.z(), itemStack);
        targetable.getLevel().addFreshEntity((Entity)entity);
    }

    private static final boolean depositItemStack$lambda$0(ItemStack obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return obj.isEmpty();
    }
}

