/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.helpers;

import com.ssblur.scriptor.ScriptorMod;
import com.ssblur.scriptor.data.components.ScriptorDataComponents;
import com.ssblur.scriptor.item.ScriptorItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.network.Filterable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\bJ\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n2\u0006\u0010\u0006\u001a\u00020\u0005J\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000b0\n2\u0006\u0010\u0006\u001a\u00020\u0005J,\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0014\u001a\u00020\u0005\u00a8\u0006\u0015"}, d2={"Lcom/ssblur/scriptor/helpers/LimitedBookSerializer;", "", "<init>", "()V", "decodeText", "", "text", "Lnet/minecraft/world/item/component/WrittenBookContent;", "Lnet/minecraft/world/item/component/WritableBookContent;", "encodeText", "", "Lnet/minecraft/server/network/Filterable;", "Lnet/minecraft/network/chat/Component;", "encodeTextWritable", "createSpellbook", "Lnet/minecraft/world/item/ItemStack;", "author", "title", "item", "filterable", "page", "scriptor"})
@SourceDebugExtension(value={"SMAP\nLimitedBookSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LimitedBookSerializer.kt\ncom/ssblur/scriptor/helpers/LimitedBookSerializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,124:1\n739#2,9:125\n739#2,9:136\n37#3,2:134\n37#3,2:145\n*S KotlinDebug\n*F\n+ 1 LimitedBookSerializer.kt\ncom/ssblur/scriptor/helpers/LimitedBookSerializer\n*L\n42#1:125,9\n77#1:136,9\n42#1:134,2\n77#1:145,2\n*E\n"})
public final class LimitedBookSerializer {
    @NotNull
    public static final LimitedBookSerializer INSTANCE = new LimitedBookSerializer();

    private LimitedBookSerializer() {
    }

    @NotNull
    public final String decodeText(@NotNull WrittenBookContent text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        List pages = text.getPages(true);
        StringBuilder builder = new StringBuilder();
        for (Component component : pages) {
            String string = component.getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            builder.append(((Object)StringsKt.trimEnd((CharSequence)string)).toString());
            builder.append(" ");
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    @NotNull
    public final String decodeText(@NotNull WritableBookContent text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Stream pages = text.getPages(true);
        StringBuilder builder = new StringBuilder();
        Iterator iterator = pages.iterator();
        while (iterator.hasNext()) {
            String component = (String)iterator.next();
            Intrinsics.checkNotNull((Object)component);
            builder.append(((Object)StringsKt.trimEnd((CharSequence)component)).toString());
            builder.append(" ");
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    @NotNull
    public final List<Filterable<Component>> encodeText(@NotNull String text) {
        List list;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        CharSequence charSequence = text;
        Regex regex = new Regex("\\s+");
        int n = 0;
        List $this$dropLastWhile$iv = regex.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] tokens = thisCollection$iv.toArray(new String[0]);
        List list2 = new ArrayList();
        int pageLength = 0;
        StringBuilder page = new StringBuilder();
        int perPage = 196;
        for (String token : tokens) {
            StringBuilder stringBuilder;
            if (token.length() >= perPage) {
                pageLength = 0;
                String string = page.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                list2.add(this.filterable(string));
                list2.add(this.filterable(token));
                page = new StringBuilder();
                stringBuilder = Unit.INSTANCE;
                continue;
            }
            if (token.length() + page.length() >= perPage) {
                pageLength = token.length();
                String string = page.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                list2.add(this.filterable(string));
                page = new StringBuilder();
                page.append(token);
                stringBuilder = page.append(" ");
                continue;
            }
            pageLength += token.length();
            page.append(token);
            stringBuilder = page.append(" ");
        }
        if (!(((CharSequence)page).length() == 0)) {
            String string = page.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            list2.add(this.filterable(string));
        }
        return list2;
    }

    @NotNull
    public final List<Filterable<String>> encodeTextWritable(@NotNull String text) {
        List list;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        CharSequence charSequence = text;
        Regex regex = new Regex("\\s+");
        int n = 0;
        List $this$dropLastWhile$iv = regex.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] tokens = thisCollection$iv.toArray(new String[0]);
        List list2 = new ArrayList();
        int pageLength = 0;
        StringBuilder page = new StringBuilder();
        int perPage = 196;
        for (String token : tokens) {
            StringBuilder stringBuilder;
            if (token.length() >= perPage) {
                pageLength = 0;
                Filterable filterable = Filterable.passThrough((Object)page.toString());
                Intrinsics.checkNotNullExpressionValue((Object)filterable, (String)"passThrough(...)");
                list2.add(filterable);
                Filterable filterable2 = Filterable.passThrough((Object)token);
                Intrinsics.checkNotNullExpressionValue((Object)filterable2, (String)"passThrough(...)");
                list2.add(filterable2);
                page = new StringBuilder();
                stringBuilder = Unit.INSTANCE;
                continue;
            }
            if (token.length() + page.length() >= perPage) {
                pageLength = token.length();
                Filterable filterable = Filterable.passThrough((Object)page.toString());
                Intrinsics.checkNotNullExpressionValue((Object)filterable, (String)"passThrough(...)");
                list2.add(filterable);
                page = new StringBuilder();
                page.append(token);
                stringBuilder = page.append(" ");
                continue;
            }
            pageLength += token.length();
            page.append(token);
            stringBuilder = page.append(" ");
        }
        if (((CharSequence)page).length() > 0) {
            Filterable filterable = Filterable.passThrough((Object)page.toString());
            Intrinsics.checkNotNullExpressionValue((Object)filterable, (String)"passThrough(...)");
            list2.add(filterable);
        }
        return list2;
    }

    @NotNull
    public final ItemStack createSpellbook(@Nullable String author, @Nullable String title, @NotNull String text, @Nullable String item) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ItemStack itemStack = item != null ? new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)item))) : new ItemStack((ItemLike)ScriptorItems.INSTANCE.getSPELLBOOK().get());
        itemStack.setCount(1);
        Filterable filterable = Filterable.passThrough((Object)"Spellbook");
        String string = author;
        if (string == null) {
            string = "";
        }
        itemStack.set(DataComponents.WRITTEN_BOOK_CONTENT, (Object)new WrittenBookContent(filterable, string, 0, this.encodeText(text), false));
        itemStack.set(ScriptorDataComponents.INSTANCE.getTOME_NAME(), (Object)title);
        if (ScriptorMod.INSTANCE.getCOMMUNITY_MODE()) {
            itemStack.set(ScriptorDataComponents.INSTANCE.getCOMMUNITY_MODE(), (Object)true);
        }
        return itemStack;
    }

    @NotNull
    public final Filterable<Component> filterable(@NotNull String page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Filterable filterable = Filterable.passThrough((Object)Component.literal((String)page));
        Intrinsics.checkNotNullExpressionValue((Object)filterable, (String)"passThrough(...)");
        return filterable;
    }
}

