/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.helpers.targetable;

import com.ssblur.scriptor.helpers.targetable.InventoryTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.mixin.BaseContainerBlockEntityAccessor;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\f\"\u0004\b\u0015\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/ssblur/scriptor/helpers/targetable/ContainerTargetable;", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "Lcom/ssblur/scriptor/helpers/targetable/InventoryTargetable;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "slot", "", "<init>", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;I)V", "getSlot", "()I", "setSlot", "(I)V", "container", "Lnet/minecraft/world/Container;", "getContainer", "()Lnet/minecraft/world/Container;", "targetedSlot", "getTargetedSlot", "setTargetedSlot", "scriptor"})
public final class ContainerTargetable
extends Targetable
implements InventoryTargetable {
    private int slot;
    private int targetedSlot;

    public ContainerTargetable(@NotNull Level level, @NotNull BlockPos pos, int slot) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        super(level, pos);
        this.targetedSlot = this.slot = slot;
    }

    public final int getSlot() {
        return this.slot;
    }

    public final void setSlot(int n) {
        this.slot = n;
    }

    @Override
    @Nullable
    public Container getContainer() {
        BlockEntity blockEntity = this.getLevel().getBlockEntity(this.getTargetBlockPos());
        if (blockEntity instanceof Container) {
            if (blockEntity instanceof BaseContainerBlockEntity) {
                if (((BaseContainerBlockEntityAccessor)blockEntity).getLockKey().unlocksWith(ItemStack.EMPTY)) {
                    BlockEntity blockEntity2 = this.getLevel().getBlockEntity(this.getTargetBlockPos());
                    Intrinsics.checkNotNull((Object)blockEntity2, (String)"null cannot be cast to non-null type net.minecraft.world.Container");
                    return (Container)blockEntity2;
                }
                return null;
            }
            BlockEntity blockEntity3 = this.getLevel().getBlockEntity(this.getTargetBlockPos());
            Intrinsics.checkNotNull((Object)blockEntity3, (String)"null cannot be cast to non-null type net.minecraft.world.Container");
            return (Container)blockEntity3;
        }
        return null;
    }

    @Override
    public int getTargetedSlot() {
        return this.targetedSlot;
    }

    @Override
    public void setTargetedSlot(int n) {
        this.targetedSlot = n;
    }

    @Override
    public boolean shouldIgnoreTargetedSlot() {
        return InventoryTargetable.DefaultImpls.shouldIgnoreTargetedSlot(this);
    }

    @Override
    public void useFirstMatchingSlot(@NotNull Predicate<ItemStack> predicate) {
        InventoryTargetable.DefaultImpls.useFirstMatchingSlot(this, predicate);
    }

    @Override
    public int getFirstMatchingSlot(@NotNull Predicate<ItemStack> predicate) {
        return InventoryTargetable.DefaultImpls.getFirstMatchingSlot((InventoryTargetable)this, predicate);
    }

    @Override
    public int getFirstMatchingSlot(@NotNull ItemStack itemStack) {
        return InventoryTargetable.DefaultImpls.getFirstMatchingSlot((InventoryTargetable)this, itemStack);
    }

    @Override
    public int getFirstFilledSlot() {
        return InventoryTargetable.DefaultImpls.getFirstFilledSlot(this);
    }

    @Override
    public int getFirstMatchingSlotNotEmpty(@NotNull ItemStack itemStack) {
        return InventoryTargetable.DefaultImpls.getFirstMatchingSlotNotEmpty(this, itemStack);
    }

    @Override
    public void useFirstFilledSlot() {
        InventoryTargetable.DefaultImpls.useFirstFilledSlot(this);
    }
}

