/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.helpers.targetable;

import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001J\b\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0016\u0010\u0013\u001a\u00020\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\b\u0010\u0018\u001a\u00020\u000fH\u0016R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\u00020\u0007X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\u0014\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/ssblur/scriptor/helpers/targetable/InventoryTargetable;", "", "container", "Lnet/minecraft/world/Container;", "getContainer", "()Lnet/minecraft/world/Container;", "targetedSlot", "", "getTargetedSlot", "()I", "setTargetedSlot", "(I)V", "shouldIgnoreTargetedSlot", "", "useFirstMatchingSlot", "", "predicate", "Ljava/util/function/Predicate;", "Lnet/minecraft/world/item/ItemStack;", "getFirstMatchingSlot", "firstFilledSlot", "getFirstFilledSlot", "itemStack", "getFirstMatchingSlotNotEmpty", "useFirstFilledSlot", "scriptor"})
public interface InventoryTargetable {
    @Nullable
    public Container getContainer();

    public int getTargetedSlot();

    public void setTargetedSlot(int var1);

    public boolean shouldIgnoreTargetedSlot();

    public void useFirstMatchingSlot(@NotNull Predicate<ItemStack> var1);

    public int getFirstMatchingSlot(@NotNull Predicate<ItemStack> var1);

    public int getFirstFilledSlot();

    public int getFirstMatchingSlot(@NotNull ItemStack var1);

    public int getFirstMatchingSlotNotEmpty(@NotNull ItemStack var1);

    public void useFirstFilledSlot();

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static boolean shouldIgnoreTargetedSlot(@NotNull InventoryTargetable $this) {
            return $this.getTargetedSlot() == -1 && $this.getContainer() != null;
        }

        public static void useFirstMatchingSlot(@NotNull InventoryTargetable $this, @NotNull Predicate<ItemStack> predicate) {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            int slot = $this.getFirstMatchingSlot(predicate);
            if (slot >= 0) {
                $this.setTargetedSlot(slot);
            }
        }

        public static int getFirstMatchingSlot(@NotNull InventoryTargetable $this, @NotNull Predicate<ItemStack> predicate) {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            if ($this.getContainer() != null) {
                Container container = $this.getContainer();
                Intrinsics.checkNotNull((Object)container);
                int n = container.getContainerSize();
                for (int i = 0; i < n; ++i) {
                    Container container2 = $this.getContainer();
                    Intrinsics.checkNotNull((Object)container2);
                    if (!predicate.test(container2.getItem(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        public static int getFirstFilledSlot(@NotNull InventoryTargetable $this) {
            return $this.getFirstMatchingSlot(DefaultImpls::_get_firstFilledSlot_$lambda$0);
        }

        public static int getFirstMatchingSlot(@NotNull InventoryTargetable $this, @NotNull ItemStack itemStack) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            return $this.getFirstMatchingSlot(arg_0 -> DefaultImpls.getFirstMatchingSlot$lambda$1(itemStack, arg_0));
        }

        public static int getFirstMatchingSlotNotEmpty(@NotNull InventoryTargetable $this, @NotNull ItemStack itemStack) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            return $this.getFirstMatchingSlot(arg_0 -> DefaultImpls.getFirstMatchingSlotNotEmpty$lambda$2(itemStack, arg_0));
        }

        public static void useFirstFilledSlot(@NotNull InventoryTargetable $this) {
            int slot = $this.getFirstFilledSlot();
            if (slot >= 0) {
                $this.setTargetedSlot(slot);
            }
        }

        private static boolean _get_firstFilledSlot_$lambda$0(ItemStack item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return !item.isEmpty();
        }

        private static boolean getFirstMatchingSlot$lambda$1(ItemStack $itemStack, ItemStack item) {
            Intrinsics.checkNotNullParameter((Object)$itemStack, (String)"$itemStack");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return item.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)$itemStack) && item.getCount() + $itemStack.getCount() <= item.getMaxStackSize();
        }

        private static boolean getFirstMatchingSlotNotEmpty$lambda$2(ItemStack $itemStack, ItemStack item) {
            Intrinsics.checkNotNullParameter((Object)$itemStack, (String)"$itemStack");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)$itemStack) && item.getCount() + $itemStack.getCount() <= item.getMaxStackSize();
        }
    }
}

