/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.item.casters;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.ssblur.scriptor.block.ScriptorBlocks;
import com.ssblur.scriptor.data.components.ScriptorDataComponents;
import com.ssblur.scriptor.helpers.ComponentHelper;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.item.casters.CasterCrystal;
import com.ssblur.scriptor.item.interfaces.ItemWithCustomRenderer;
import com.ssblur.scriptor.network.server.TraceNetwork;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0002#$B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J$\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J.\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J2\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0016\u00a8\u0006%"}, d2={"Lcom/ssblur/scriptor/item/casters/CoordinateCasterCrystal;", "Lcom/ssblur/scriptor/item/casters/CasterCrystal;", "Lcom/ssblur/scriptor/item/interfaces/ItemWithCustomRenderer;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "getTargetables", "", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "appendHoverText", "", "Lnet/minecraft/world/item/Item$TooltipContext;", "list", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "use", "Lnet/minecraft/world/InteractionResultHolder;", "player", "Lnet/minecraft/world/entity/player/Player;", "interactionHand", "Lnet/minecraft/world/InteractionHand;", "worldRender", "Lnet/minecraft/client/player/AbstractClientPlayer;", "hand", "matrix", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "BlockPosDirection", "Companion", "scriptor"})
public final class CoordinateCasterCrystal
extends CasterCrystal
implements ItemWithCustomRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public CoordinateCasterCrystal(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @Override
    @NotNull
    public List<Targetable> getTargetables(@Nullable ItemStack itemStack, @Nullable Level level) {
        ArrayList<Targetable> list = new ArrayList<Targetable>();
        ItemStack itemStack2 = itemStack;
        Intrinsics.checkNotNull((Object)itemStack2);
        List coordinates = (List)itemStack2.get(ScriptorDataComponents.INSTANCE.getCOORDINATES());
        if (coordinates != null) {
            for (List pos : coordinates) {
                Level level2 = level;
                Intrinsics.checkNotNull((Object)level2);
                Targetable targetable = new Targetable(level2, new BlockPos(((Number)pos.get(0)).intValue(), ((Number)pos.get(1)).intValue(), ((Number)pos.get(2)).intValue()));
                targetable.setFacing((Direction)EntriesMappings.entries$0.get(((Number)pos.get(3)).intValue()));
                list.add(targetable);
            }
        }
        return list;
    }

    public void appendHoverText(@NotNull ItemStack itemStack, @NotNull Item.TooltipContext level, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        super.appendHoverText(itemStack, level, list, tooltipFlag);
        List<BlockPosDirection> coordinates = Companion.getCoordinates(itemStack);
        for (BlockPosDirection pair : coordinates) {
            BlockPos coordinate = pair.getLeft();
            Object[] objectArray = new Object[]{coordinate.getX(), coordinate.getY(), coordinate.getZ()};
            ComponentHelper.INSTANCE.updateTooltipWith(ChatFormatting.GRAY, list, "lore.scriptor.coordinate_crystal_3", objectArray);
        }
        if (coordinates.isEmpty()) {
            MutableComponent mutableComponent = Component.translatable((String)"lore.scriptor.coordinate_crystal_1").withStyle(ChatFormatting.GRAY);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
            v1 = list.add((Component)mutableComponent);
        } else {
            if (coordinates.size() < 4) {
                MutableComponent mutableComponent = Component.translatable((String)"lore.scriptor.coordinate_crystal_2").withStyle(ChatFormatting.GRAY);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
                list.add((Component)mutableComponent);
            }
            MutableComponent mutableComponent = Component.translatable((String)"lore.scriptor.crystal_reset").withStyle(ChatFormatting.GRAY);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
            v1 = list.add((Component)mutableComponent);
        }
        MutableComponent mutableComponent = Component.translatable((String)"lore.scriptor.crystal_focus").withStyle(ChatFormatting.GRAY);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
        list.add((Component)mutableComponent);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)interactionHand, (String)"interactionHand");
        InteractionResultHolder result = super.use(level, player, interactionHand);
        if (!level.isClientSide) {
            ItemStack itemStack = player.getItemInHand(interactionHand);
            TraceNetwork.INSTANCE.requestTraceData(player, false, (Function1<? super Targetable, Unit>)((Function1)arg_0 -> CoordinateCasterCrystal.use$lambda$0(itemStack, arg_0)));
        }
        Intrinsics.checkNotNull((Object)result);
        return result;
    }

    @Override
    public void worldRender(@NotNull AbstractClientPlayer player, @NotNull InteractionHand hand, @NotNull ItemStack itemStack, @Nullable PoseStack matrix, @NotNull MultiBufferSource buffer) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (matrix == null) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        BlockRenderDispatcher dispatcher = minecraft.getBlockRenderer();
        GameRenderer gameRenderer = minecraft.gameRenderer;
        Vec3 camera = gameRenderer.getMainCamera().getPosition();
        matrix.pushPose();
        matrix.setIdentity();
        matrix.translate(-camera.x, -camera.y, -camera.z);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.setShader(CoordinateCasterCrystal::worldRender$lambda$1);
        RenderSystem.disableCull();
        for (BlockPosDirection blockPosDirection : Companion.getCoordinates(itemStack)) {
            BlockPos pos = (BlockPos)((Map.Entry)((Object)blockPosDirection)).getKey();
            Direction dir = (Direction)((Map.Entry)((Object)blockPosDirection)).getValue();
            matrix.pushPose();
            BlockState blockState = (BlockState)((Block)ScriptorBlocks.INSTANCE.getHIGHLIGHT_MODEL().get()).defaultBlockState().setValue((Property)DirectionalBlock.FACING, (Comparable)dir);
            matrix.translate((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
            dispatcher.renderSingleBlock(blockState, matrix, buffer, 0xFFFFFF, 0xFFFFFF);
            matrix.popPose();
        }
        matrix.popPose();
    }

    @Override
    public boolean render(@NotNull AbstractClientPlayer player, float i, float pitch, @NotNull InteractionHand hand, float swingProgress, @NotNull ItemStack itemStack, float readyProgress, @Nullable PoseStack matrix, @NotNull MultiBufferSource buffer, int lightLevel) {
        return ItemWithCustomRenderer.DefaultImpls.render(this, player, i, pitch, hand, swingProgress, itemStack, readyProgress, matrix, buffer, lightLevel);
    }

    private static final Unit use$lambda$0(ItemStack $itemStack, Targetable target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNull((Object)$itemStack);
        Companion.addCoordinate($itemStack, target.getTargetBlockPos(), target.getFacing());
        return Unit.INSTANCE;
    }

    private static final ShaderInstance worldRender$lambda$1() {
        return GameRenderer.getPositionTexColorShader();
    }

    @JvmStatic
    @NotNull
    public static final List<BlockPosDirection> getCoordinates(@NotNull ItemStack itemStack) {
        return Companion.getCoordinates(itemStack);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0002H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u000e\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002R\u001a\u0010\u0004\u001a\u00020\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/ssblur/scriptor/item/casters/CoordinateCasterCrystal$BlockPosDirection;", "Lorg/apache/commons/lang3/tuple/Pair;", "Lnet/minecraft/core/BlockPos;", "Lnet/minecraft/core/Direction;", "blockPos", "direction", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)V", "getBlockPos", "()Lnet/minecraft/core/BlockPos;", "setBlockPos", "(Lnet/minecraft/core/BlockPos;)V", "getDirection", "()Lnet/minecraft/core/Direction;", "setDirection", "(Lnet/minecraft/core/Direction;)V", "getLeft", "getRight", "setValue", "newValue", "scriptor"})
    @SourceDebugExtension(value={"SMAP\nCoordinateCasterCrystal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoordinateCasterCrystal.kt\ncom/ssblur/scriptor/item/casters/CoordinateCasterCrystal$BlockPosDirection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,180:1\n1#2:181\n*E\n"})
    public static final class BlockPosDirection
    extends Pair<BlockPos, Direction> {
        @NotNull
        private BlockPos blockPos;
        @NotNull
        private Direction direction;

        public BlockPosDirection(@NotNull BlockPos blockPos, @NotNull Direction direction) {
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            this.blockPos = blockPos;
            this.direction = direction;
        }

        @NotNull
        public final BlockPos getBlockPos() {
            return this.blockPos;
        }

        public final void setBlockPos(@NotNull BlockPos blockPos) {
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"<set-?>");
            this.blockPos = blockPos;
        }

        @NotNull
        public final Direction getDirection() {
            return this.direction;
        }

        public final void setDirection(@NotNull Direction direction) {
            Intrinsics.checkNotNullParameter((Object)direction, (String)"<set-?>");
            this.direction = direction;
        }

        @NotNull
        public BlockPos getLeft() {
            return this.blockPos;
        }

        @NotNull
        public Direction getRight() {
            return this.direction;
        }

        @NotNull
        public Direction setValue(@NotNull Direction newValue) {
            Direction direction;
            Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
            Direction it = direction = newValue;
            boolean bl = false;
            this.direction = it;
            return direction;
        }

        @NotNull
        public final BlockPos setValue(@NotNull BlockPos newValue) {
            BlockPos blockPos;
            Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
            BlockPos it = blockPos = newValue;
            boolean bl = false;
            this.blockPos = it;
            return blockPos;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\u000f"}, d2={"Lcom/ssblur/scriptor/item/casters/CoordinateCasterCrystal$Companion;", "", "<init>", "()V", "addCoordinate", "", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "pos", "Lnet/minecraft/core/BlockPos;", "direction", "Lnet/minecraft/core/Direction;", "getCoordinates", "", "Lcom/ssblur/scriptor/item/casters/CoordinateCasterCrystal$BlockPosDirection;", "scriptor"})
    public static final class Companion {
        private Companion() {
        }

        public final void addCoordinate(@NotNull ItemStack itemStack, @NotNull BlockPos pos, @NotNull Direction direction) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            List list = (List)itemStack.get(ScriptorDataComponents.INSTANCE.getCOORDINATES());
            if (list == null) {
                list = new ArrayList();
            }
            if (list.size() < 4) {
                list = new ArrayList(list);
                ((ArrayList)list).add(List.of(Integer.valueOf(pos.getX()), Integer.valueOf(pos.getY()), Integer.valueOf(pos.getZ()), Integer.valueOf(direction.ordinal())));
            }
            itemStack.set(ScriptorDataComponents.INSTANCE.getCOORDINATES(), (Object)list);
        }

        @JvmStatic
        @NotNull
        public final List<BlockPosDirection> getCoordinates(@NotNull ItemStack itemStack) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            ArrayList<BlockPosDirection> list = new ArrayList<BlockPosDirection>();
            List coordinates = (List)itemStack.get(ScriptorDataComponents.INSTANCE.getCOORDINATES());
            if (coordinates != null) {
                for (List pos : coordinates) {
                    list.add(new BlockPosDirection(new BlockPos(((Number)pos.get(0)).intValue(), ((Number)pos.get(1)).intValue(), ((Number)pos.get(2)).intValue()), (Direction)EntriesMappings.entries$0.get(((Number)pos.get(3)).intValue())));
                }
            }
            return list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class EntriesMappings {
            public static final /* synthetic */ EnumEntries<Direction> entries$0;

            static {
                entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Direction> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
        }
    }
}

