/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.network.client;

import com.ssblur.scriptor.ScriptorMod;
import com.ssblur.scriptor.api.word.Action;
import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Subject;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.blockentity.PhasedBlockBlockEntity;
import com.ssblur.scriptor.color.CustomColors;
import com.ssblur.scriptor.data.components.ScriptorDataComponents;
import com.ssblur.scriptor.network.server.TraceNetwork;
import com.ssblur.scriptor.registry.words.WordRegistry;
import com.ssblur.scriptor.word.PartialSpell;
import com.ssblur.scriptor.word.Spell;
import com.ssblur.scriptor.word.subject.InventorySubject;
import com.ssblur.unfocused.network.NetworkManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0007\u001e\u001f !\"#$B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u001d\u001a\u00020\tR)\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR)\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR)\u0010\u0011\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR)\u0010\u0014\u001a\u001a\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000bR)\u0010\u0017\u001a\u001a\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000bR)\u0010\u001a\u001a\u001a\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000b\u00a8\u0006%"}, d2={"Lcom/ssblur/scriptor/network/client/ScriptorNetworkS2C;", "", "<init>", "()V", "creativeBook", "Lkotlin/Function2;", "Lcom/ssblur/scriptor/network/client/ScriptorNetworkS2C$CreativeBook;", "", "Lnet/minecraft/world/entity/player/Player;", "", "getCreativeBook", "()Lkotlin/jvm/functions/Function2;", "extendedTraceCallback", "payload", "Lcom/ssblur/scriptor/network/client/ScriptorNetworkS2C$ExtendedTrace;", "extendedTrace", "getExtendedTrace", "trace", "Lcom/ssblur/scriptor/network/client/ScriptorNetworkS2C$Trace;", "getTrace", "identify", "Lcom/ssblur/scriptor/network/client/ScriptorNetworkS2C$Identify;", "getIdentify", "color", "Lcom/ssblur/scriptor/network/client/ScriptorNetworkS2C$Color;", "getColor", "flag", "Lcom/ssblur/scriptor/network/client/ScriptorNetworkS2C$Flag;", "getFlag", "register", "CreativeBook", "ExtendedTrace", "Trace", "Identify", "Color", "FLAGS", "Flag", "scriptor"})
@SourceDebugExtension(value={"SMAP\nScriptorNetworkS2C.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptorNetworkS2C.kt\ncom/ssblur/scriptor/network/client/ScriptorNetworkS2C\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n37#2,2:164\n37#2,2:167\n1#3:166\n*S KotlinDebug\n*F\n+ 1 ScriptorNetworkS2C.kt\ncom/ssblur/scriptor/network/client/ScriptorNetworkS2C\n*L\n42#1:164,2\n50#1:167,2\n*E\n"})
public final class ScriptorNetworkS2C {
    @NotNull
    public static final ScriptorNetworkS2C INSTANCE = new ScriptorNetworkS2C();
    @NotNull
    private static final Function2<CreativeBook, List<? extends Player>, Unit> creativeBook;
    @NotNull
    private static final Function2<ExtendedTrace, List<? extends Player>, Unit> extendedTrace;
    @NotNull
    private static final Function2<Trace, List<? extends Player>, Unit> trace;
    @NotNull
    private static final Function2<Identify, List<? extends Player>, Unit> identify;
    @NotNull
    private static final Function2<Color, List<? extends Player>, Unit> color;
    @NotNull
    private static final Function2<Flag, List<? extends Player>, Unit> flag;

    private ScriptorNetworkS2C() {
    }

    @NotNull
    public final Function2<CreativeBook, List<? extends Player>, Unit> getCreativeBook() {
        return creativeBook;
    }

    public final void extendedTraceCallback(@NotNull ExtendedTrace payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        Intrinsics.checkNotNull((Object)localPlayer);
        Player player = (Player)localPlayer;
        Level level = player.level();
        Vec3 position = player.getEyePosition();
        Vec3 angle = player.getLookAngle().normalize().multiply(payload.getScale(), payload.getScale(), payload.getScale());
        Vec3 dest = angle.add(position);
        BlockHitResult blockHitResult = level.clip(new ClipContext(position, dest, ClipContext.Block.COLLIDER, payload.getCollideWithWater() ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, (Entity)player));
        EntityHitResult entityHitResult = ProjectileUtil.getEntityHitResult((Level)level, (Entity)((Entity)player), (Vec3)position, (Vec3)dest, (AABB)AABB.ofSize((Vec3)position.subtract(0.1, 0.1, 0.1), (double)0.2, (double)0.2, (double)0.2).expandTowards(angle).inflate(1.0), ScriptorNetworkS2C::extendedTraceCallback$lambda$4);
        if (entityHitResult != null && entityHitResult.getType() != HitResult.Type.MISS) {
            if (blockHitResult.getType() != HitResult.Type.MISS && blockHitResult.distanceTo((Entity)player) < entityHitResult.distanceTo((Entity)player)) {
                TraceNetwork.INSTANCE.getReturnTrace().invoke((Object)new TraceNetwork.Payload(payload.getUuid(), TraceNetwork.TYPE.BLOCK, blockHitResult, 0, null));
            } else {
                TraceNetwork.INSTANCE.getReturnTrace().invoke((Object)new TraceNetwork.Payload(payload.getUuid(), TraceNetwork.TYPE.ENTITY, blockHitResult, entityHitResult.getEntity().getId(), entityHitResult.getEntity().getUUID()));
            }
        } else if (blockHitResult.getType() != HitResult.Type.MISS) {
            TraceNetwork.INSTANCE.getReturnTrace().invoke((Object)new TraceNetwork.Payload(payload.getUuid(), TraceNetwork.TYPE.BLOCK, blockHitResult, 0, null));
        } else {
            TraceNetwork.INSTANCE.getReturnTrace().invoke((Object)new TraceNetwork.Payload(payload.getUuid(), TraceNetwork.TYPE.MISS, blockHitResult, 0, null));
        }
    }

    @NotNull
    public final Function2<ExtendedTrace, List<? extends Player>, Unit> getExtendedTrace() {
        return extendedTrace;
    }

    @NotNull
    public final Function2<Trace, List<? extends Player>, Unit> getTrace() {
        return trace;
    }

    @NotNull
    public final Function2<Identify, List<? extends Player>, Unit> getIdentify() {
        return identify;
    }

    @NotNull
    public final Function2<Color, List<? extends Player>, Unit> getColor() {
        return color;
    }

    @NotNull
    public final Function2<Flag, List<? extends Player>, Unit> getFlag() {
        return flag;
    }

    public final void register() {
    }

    private static final void creativeBook$lambda$3(CreativeBook payload) {
        Collection thisCollection$iv;
        Object $this$toTypedArray$iv;
        boolean $i$f$toTypedArray;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Word action = null;
        Word subject = null;
        ArrayList<Subject> descriptor = new ArrayList<Subject>();
        for (String string : payload.getComponents()) {
            Object object = StringsKt.replace$default((String)string, (String)"\"", (String)"", (boolean)false, (int)4, null);
            Regex regex = new Regex(":");
            int n = 2;
            object = regex.split((CharSequence)object, n);
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            String[] split = thisCollection$iv.toArray(new String[0]);
            switch (split[0]) {
                case "action": {
                    Word it;
                    boolean bl;
                    if ((Action)WordRegistry.INSTANCE.getActionRegistry().get((Object)split[1]) != null) {
                        bl = false;
                        action = it;
                    }
                    break;
                }
                case "descriptor": {
                    Word it;
                    boolean bl;
                    if ((Descriptor)WordRegistry.INSTANCE.getDescriptorRegistry().get((Object)split[1]) != null) {
                        bl = false;
                        descriptor.add((Subject)it);
                    }
                    break;
                }
                case "subject": {
                    Word it;
                    boolean bl;
                    if ((Subject)WordRegistry.INSTANCE.getSubjectRegistry().get((Object)split[1]) != null) {
                        bl = false;
                        subject = it;
                    }
                    break;
                }
            }
        }
        Word word = subject;
        Intrinsics.checkNotNull(word);
        PartialSpell[] partialSpellArray = new PartialSpell[1];
        Word word2 = action;
        Intrinsics.checkNotNull(word2);
        $this$toTypedArray$iv = descriptor;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        Descriptor[] descriptorArray = thisCollection$iv.toArray(new Descriptor[0]);
        partialSpellArray[0] = new PartialSpell((Action)word2, Arrays.copyOf(descriptorArray, descriptorArray.length));
        Spell spell = new Spell((Subject)word, partialSpellArray);
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        Intrinsics.checkNotNull((Object)localPlayer);
        LocalPlayer localPlayer2 = localPlayer;
        if (spell.getSubject() instanceof InventorySubject) {
            Subject subject2 = spell.getSubject();
            Intrinsics.checkNotNull((Object)subject2, (String)"null cannot be cast to non-null type com.ssblur.scriptor.word.subject.InventorySubject");
            InventorySubject inventorySubject = (InventorySubject)((Object)subject2);
            Player player = (Player)localPlayer2;
            Object object = localPlayer2.containerMenu.getItems().get(payload.getSlot());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            inventorySubject.castOnItem(spell, player, (ItemStack)object);
            localPlayer2.getCooldowns().addCooldown(localPlayer2.containerMenu.getCarried().getItem(), 5);
        }
    }

    private static final boolean extendedTraceCallback$lambda$4(Entity entity) {
        return true;
    }

    private static final void trace$lambda$5(Trace payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        if (!payload.getCollideWithWater()) {
            HitResult hit = Minecraft.getInstance().hitResult;
            HitResult.Type type = Objects.requireNonNull(hit).getType();
            switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    Function1<TraceNetwork.Payload, Unit> function1 = TraceNetwork.INSTANCE.getReturnTrace();
                    UUID uUID = payload.getUuid();
                    Intrinsics.checkNotNull((Object)hit, (String)"null cannot be cast to non-null type net.minecraft.world.phys.BlockHitResult");
                    function1.invoke((Object)new TraceNetwork.Payload(uUID, TraceNetwork.TYPE.BLOCK, (BlockHitResult)hit, 0, null));
                    break;
                }
                case 2: {
                    Intrinsics.checkNotNull((Object)hit, (String)"null cannot be cast to non-null type net.minecraft.world.phys.EntityHitResult");
                    Entity entity = ((EntityHitResult)hit).getEntity();
                    TraceNetwork.INSTANCE.getReturnTrace().invoke((Object)new TraceNetwork.Payload(payload.getUuid(), TraceNetwork.TYPE.ENTITY, null, entity.getId(), entity.getUUID()));
                    break;
                }
                default: {
                    TraceNetwork.INSTANCE.getReturnTrace().invoke((Object)new TraceNetwork.Payload(payload.getUuid(), TraceNetwork.TYPE.MISS, null, 0, null));
                    break;
                }
            }
        } else {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null) {
                INSTANCE.extendedTraceCallback(new ExtendedTrace(payload.getUuid(), true, player.getAttributes().getValue(Attributes.BLOCK_INTERACTION_RANGE)));
            }
        }
    }

    private static final void identify$lambda$6(Identify payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        Intrinsics.checkNotNull((Object)localPlayer);
        localPlayer.containerMenu.getSlot(payload.getSlot()).getItem().set(ScriptorDataComponents.INSTANCE.getIDENTIFIED(), payload.getComponents());
    }

    private static final void color$lambda$7(Color payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        int[] nArray = new int[]{payload.getR(), payload.getG(), payload.getB()};
        CustomColors.INSTANCE.putColor(payload.getIndex(), payload.getName(), nArray);
    }

    private static final void flag$lambda$8(Flag payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        switch (WhenMappings.$EnumSwitchMapping$1[payload.getKey().ordinal()]) {
            case 1: {
                ScriptorMod.INSTANCE.setCOMMUNITY_MODE(payload.getValue());
                break;
            }
            case 2: {
                PhasedBlockBlockEntity.Companion.setINVERT_DO_NOT_PHASE(payload.getValue());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    static {
        ResourceLocation resourceLocation = ScriptorMod.INSTANCE.location("client_cursor_return_bookc");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
        creativeBook = NetworkManager.INSTANCE.registerS2C(resourceLocation, Reflection.getOrCreateKotlinClass(CreativeBook.class), ScriptorNetworkS2C::creativeBook$lambda$3);
        ResourceLocation resourceLocation2 = ScriptorMod.INSTANCE.location("client_get_hitscan_data");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"location(...)");
        ScriptorNetworkS2C scriptorNetworkS2C = INSTANCE;
        extendedTrace = NetworkManager.INSTANCE.registerS2C(resourceLocation2, Reflection.getOrCreateKotlinClass(ExtendedTrace.class), new NetworkManager.S2CReceiver(scriptorNetworkS2C){
            final /* synthetic */ ScriptorNetworkS2C $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void receive(ExtendedTrace p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                this.$tmp0.extendedTraceCallback(p0);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, (Object)this.$tmp0, ScriptorNetworkS2C.class, "extendedTraceCallback", "extendedTraceCallback(Lcom/ssblur/scriptor/network/client/ScriptorNetworkS2C$ExtendedTrace;)V", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof NetworkManager.S2CReceiver ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        });
        ResourceLocation resourceLocation3 = ScriptorMod.INSTANCE.location("client_get_touch_data");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation3, (String)"location(...)");
        trace = NetworkManager.INSTANCE.registerS2C(resourceLocation3, Reflection.getOrCreateKotlinClass(Trace.class), ScriptorNetworkS2C::trace$lambda$5);
        ResourceLocation resourceLocation4 = ScriptorMod.INSTANCE.location("client_cursor_return_scrollc");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation4, (String)"location(...)");
        identify = NetworkManager.INSTANCE.registerS2C(resourceLocation4, Reflection.getOrCreateKotlinClass(Identify.class), ScriptorNetworkS2C::identify$lambda$6);
        ResourceLocation resourceLocation5 = ScriptorMod.INSTANCE.location("client_color_receivec");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation5, (String)"location(...)");
        color = NetworkManager.INSTANCE.registerS2C(resourceLocation5, Reflection.getOrCreateKotlinClass(Color.class), ScriptorNetworkS2C::color$lambda$7);
        ResourceLocation resourceLocation6 = ScriptorMod.INSTANCE.location("client_flag");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation6, (String)"location(...)");
        flag = NetworkManager.INSTANCE.registerS2C(resourceLocation6, Reflection.getOrCreateKotlinClass(Flag.class), ScriptorNetworkS2C::flag$lambda$8);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J;\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/ssblur/scriptor/network/client/ScriptorNetworkS2C$Color;", "", "name", "", "index", "", "r", "g", "b", "<init>", "(Ljava/lang/String;IIII)V", "getName", "()Ljava/lang/String;", "getIndex", "()I", "getR", "getG", "getB", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "scriptor"})
    public static final class Color {
        @NotNull
        private final String name;
        private final int index;
        private final int r;
        private final int g;
        private final int b;

        public Color(@NotNull String name, int index, int r, int g, int b) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.index = index;
            this.r = r;
            this.g = g;
            this.b = b;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final int getIndex() {
            return this.index;
        }

        public final int getR() {
            return this.r;
        }

        public final int getG() {
            return this.g;
        }

        public final int getB() {
            return this.b;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final int component2() {
            return this.index;
        }

        public final int component3() {
            return this.r;
        }

        public final int component4() {
            return this.g;
        }

        public final int component5() {
            return this.b;
        }

        @NotNull
        public final Color copy(@NotNull String name, int index, int r, int g, int b) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new Color(name, index, r, g, b);
        }

        public static /* synthetic */ Color copy$default(Color color, String string, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                string = color.name;
            }
            if ((n5 & 2) != 0) {
                n = color.index;
            }
            if ((n5 & 4) != 0) {
                n2 = color.r;
            }
            if ((n5 & 8) != 0) {
                n3 = color.g;
            }
            if ((n5 & 0x10) != 0) {
                n4 = color.b;
            }
            return color.copy(string, n, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "Color(name=" + this.name + ", index=" + this.index + ", r=" + this.r + ", g=" + this.g + ", b=" + this.b + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + Integer.hashCode(this.index);
            result = result * 31 + Integer.hashCode(this.r);
            result = result * 31 + Integer.hashCode(this.g);
            result = result * 31 + Integer.hashCode(this.b);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Color)) {
                return false;
            }
            Color color = (Color)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)color.name)) {
                return false;
            }
            if (this.index != color.index) {
                return false;
            }
            if (this.r != color.r) {
                return false;
            }
            if (this.g != color.g) {
                return false;
            }
            return this.b == color.b;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/ssblur/scriptor/network/client/ScriptorNetworkS2C$CreativeBook;", "", "components", "", "", "slot", "", "<init>", "(Ljava/util/List;I)V", "getComponents", "()Ljava/util/List;", "getSlot", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "scriptor"})
    public static final class CreativeBook {
        @NotNull
        private final List<String> components;
        private final int slot;

        public CreativeBook(@NotNull List<String> components, int slot) {
            Intrinsics.checkNotNullParameter(components, (String)"components");
            this.components = components;
            this.slot = slot;
        }

        @NotNull
        public final List<String> getComponents() {
            return this.components;
        }

        public final int getSlot() {
            return this.slot;
        }

        @NotNull
        public final List<String> component1() {
            return this.components;
        }

        public final int component2() {
            return this.slot;
        }

        @NotNull
        public final CreativeBook copy(@NotNull List<String> components, int slot) {
            Intrinsics.checkNotNullParameter(components, (String)"components");
            return new CreativeBook(components, slot);
        }

        public static /* synthetic */ CreativeBook copy$default(CreativeBook creativeBook, List list, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                list = creativeBook.components;
            }
            if ((n2 & 2) != 0) {
                n = creativeBook.slot;
            }
            return creativeBook.copy(list, n);
        }

        @NotNull
        public String toString() {
            return "CreativeBook(components=" + this.components + ", slot=" + this.slot + ")";
        }

        public int hashCode() {
            int result = ((Object)this.components).hashCode();
            result = result * 31 + Integer.hashCode(this.slot);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CreativeBook)) {
                return false;
            }
            CreativeBook creativeBook = (CreativeBook)other;
            if (!Intrinsics.areEqual(this.components, creativeBook.components)) {
                return false;
            }
            return this.slot == creativeBook.slot;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/ssblur/scriptor/network/client/ScriptorNetworkS2C$ExtendedTrace;", "", "uuid", "Ljava/util/UUID;", "collideWithWater", "", "scale", "", "<init>", "(Ljava/util/UUID;ZD)V", "getUuid", "()Ljava/util/UUID;", "getCollideWithWater", "()Z", "getScale", "()D", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "scriptor"})
    public static final class ExtendedTrace {
        @NotNull
        private final UUID uuid;
        private final boolean collideWithWater;
        private final double scale;

        public ExtendedTrace(@NotNull UUID uuid, boolean collideWithWater, double scale) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            this.uuid = uuid;
            this.collideWithWater = collideWithWater;
            this.scale = scale;
        }

        public /* synthetic */ ExtendedTrace(UUID uUID, boolean bl, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                d = 20.0;
            }
            this(uUID, bl, d);
        }

        @NotNull
        public final UUID getUuid() {
            return this.uuid;
        }

        public final boolean getCollideWithWater() {
            return this.collideWithWater;
        }

        public final double getScale() {
            return this.scale;
        }

        @NotNull
        public final UUID component1() {
            return this.uuid;
        }

        public final boolean component2() {
            return this.collideWithWater;
        }

        public final double component3() {
            return this.scale;
        }

        @NotNull
        public final ExtendedTrace copy(@NotNull UUID uuid, boolean collideWithWater, double scale) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            return new ExtendedTrace(uuid, collideWithWater, scale);
        }

        public static /* synthetic */ ExtendedTrace copy$default(ExtendedTrace extendedTrace2, UUID uUID, boolean bl, double d, int n, Object object) {
            if ((n & 1) != 0) {
                uUID = extendedTrace2.uuid;
            }
            if ((n & 2) != 0) {
                bl = extendedTrace2.collideWithWater;
            }
            if ((n & 4) != 0) {
                d = extendedTrace2.scale;
            }
            return extendedTrace2.copy(uUID, bl, d);
        }

        @NotNull
        public String toString() {
            return "ExtendedTrace(uuid=" + this.uuid + ", collideWithWater=" + this.collideWithWater + ", scale=" + this.scale + ")";
        }

        public int hashCode() {
            int result = this.uuid.hashCode();
            result = result * 31 + Boolean.hashCode(this.collideWithWater);
            result = result * 31 + Double.hashCode(this.scale);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExtendedTrace)) {
                return false;
            }
            ExtendedTrace extendedTrace2 = (ExtendedTrace)other;
            if (!Intrinsics.areEqual((Object)this.uuid, (Object)extendedTrace2.uuid)) {
                return false;
            }
            if (this.collideWithWater != extendedTrace2.collideWithWater) {
                return false;
            }
            return Double.compare(this.scale, extendedTrace2.scale) == 0;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/ssblur/scriptor/network/client/ScriptorNetworkS2C$FLAGS;", "", "<init>", "(Ljava/lang/String;I)V", "COMMUNITY", "INVERT_DO_NOT_PHASE", "scriptor"})
    public static final class FLAGS
    extends Enum<FLAGS> {
        public static final /* enum */ FLAGS COMMUNITY = new FLAGS();
        public static final /* enum */ FLAGS INVERT_DO_NOT_PHASE = new FLAGS();
        private static final /* synthetic */ FLAGS[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static FLAGS[] values() {
            return (FLAGS[])$VALUES.clone();
        }

        public static FLAGS valueOf(String value) {
            return Enum.valueOf(FLAGS.class, value);
        }

        @NotNull
        public static EnumEntries<FLAGS> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = fLAGSArray = new FLAGS[]{FLAGS.COMMUNITY, FLAGS.INVERT_DO_NOT_PHASE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/ssblur/scriptor/network/client/ScriptorNetworkS2C$Flag;", "", "key", "Lcom/ssblur/scriptor/network/client/ScriptorNetworkS2C$FLAGS;", "value", "", "<init>", "(Lcom/ssblur/scriptor/network/client/ScriptorNetworkS2C$FLAGS;Z)V", "getKey", "()Lcom/ssblur/scriptor/network/client/ScriptorNetworkS2C$FLAGS;", "getValue", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "scriptor"})
    public static final class Flag {
        @NotNull
        private final FLAGS key;
        private final boolean value;

        public Flag(@NotNull FLAGS key, boolean value) {
            Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
            this.key = key;
            this.value = value;
        }

        @NotNull
        public final FLAGS getKey() {
            return this.key;
        }

        public final boolean getValue() {
            return this.value;
        }

        @NotNull
        public final FLAGS component1() {
            return this.key;
        }

        public final boolean component2() {
            return this.value;
        }

        @NotNull
        public final Flag copy(@NotNull FLAGS key, boolean value) {
            Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
            return new Flag(key, value);
        }

        public static /* synthetic */ Flag copy$default(Flag flag, FLAGS fLAGS, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                fLAGS = flag.key;
            }
            if ((n & 2) != 0) {
                bl = flag.value;
            }
            return flag.copy(fLAGS, bl);
        }

        @NotNull
        public String toString() {
            return "Flag(key=" + this.key + ", value=" + this.value + ")";
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = result * 31 + Boolean.hashCode(this.value);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Flag)) {
                return false;
            }
            Flag flag = (Flag)other;
            if (this.key != flag.key) {
                return false;
            }
            return this.value == flag.value;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/ssblur/scriptor/network/client/ScriptorNetworkS2C$Identify;", "", "components", "", "", "slot", "", "<init>", "(Ljava/util/List;I)V", "getComponents", "()Ljava/util/List;", "getSlot", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "scriptor"})
    public static final class Identify {
        @NotNull
        private final List<String> components;
        private final int slot;

        public Identify(@NotNull List<String> components, int slot) {
            Intrinsics.checkNotNullParameter(components, (String)"components");
            this.components = components;
            this.slot = slot;
        }

        @NotNull
        public final List<String> getComponents() {
            return this.components;
        }

        public final int getSlot() {
            return this.slot;
        }

        @NotNull
        public final List<String> component1() {
            return this.components;
        }

        public final int component2() {
            return this.slot;
        }

        @NotNull
        public final Identify copy(@NotNull List<String> components, int slot) {
            Intrinsics.checkNotNullParameter(components, (String)"components");
            return new Identify(components, slot);
        }

        public static /* synthetic */ Identify copy$default(Identify identify, List list, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                list = identify.components;
            }
            if ((n2 & 2) != 0) {
                n = identify.slot;
            }
            return identify.copy(list, n);
        }

        @NotNull
        public String toString() {
            return "Identify(components=" + this.components + ", slot=" + this.slot + ")";
        }

        public int hashCode() {
            int result = ((Object)this.components).hashCode();
            result = result * 31 + Integer.hashCode(this.slot);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Identify)) {
                return false;
            }
            Identify identify = (Identify)other;
            if (!Intrinsics.areEqual(this.components, identify.components)) {
                return false;
            }
            return this.slot == identify.slot;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/ssblur/scriptor/network/client/ScriptorNetworkS2C$Trace;", "", "uuid", "Ljava/util/UUID;", "collideWithWater", "", "<init>", "(Ljava/util/UUID;Z)V", "getUuid", "()Ljava/util/UUID;", "getCollideWithWater", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "scriptor"})
    public static final class Trace {
        @NotNull
        private final UUID uuid;
        private final boolean collideWithWater;

        public Trace(@NotNull UUID uuid, boolean collideWithWater) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            this.uuid = uuid;
            this.collideWithWater = collideWithWater;
        }

        @NotNull
        public final UUID getUuid() {
            return this.uuid;
        }

        public final boolean getCollideWithWater() {
            return this.collideWithWater;
        }

        @NotNull
        public final UUID component1() {
            return this.uuid;
        }

        public final boolean component2() {
            return this.collideWithWater;
        }

        @NotNull
        public final Trace copy(@NotNull UUID uuid, boolean collideWithWater) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            return new Trace(uuid, collideWithWater);
        }

        public static /* synthetic */ Trace copy$default(Trace trace, UUID uUID, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                uUID = trace.uuid;
            }
            if ((n & 2) != 0) {
                bl = trace.collideWithWater;
            }
            return trace.copy(uUID, bl);
        }

        @NotNull
        public String toString() {
            return "Trace(uuid=" + this.uuid + ", collideWithWater=" + this.collideWithWater + ")";
        }

        public int hashCode() {
            int result = this.uuid.hashCode();
            result = result * 31 + Boolean.hashCode(this.collideWithWater);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Trace)) {
                return false;
            }
            Trace trace = (Trace)other;
            if (!Intrinsics.areEqual((Object)this.uuid, (Object)trace.uuid)) {
                return false;
            }
            return this.collideWithWater == trace.collideWithWater;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[HitResult.Type.values().length];
            try {
                nArray[HitResult.Type.BLOCK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HitResult.Type.ENTITY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[FLAGS.values().length];
            try {
                nArray[FLAGS.COMMUNITY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FLAGS.INVERT_DO_NOT_PHASE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

