/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.recipe;

import com.ssblur.scriptor.item.ScriptorItems;
import com.ssblur.scriptor.item.books.Spellbook;
import com.ssblur.scriptor.recipe.ScriptorRecipes;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0016\u0010\u0014\u001a\u0010\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00000\u00000\u0015H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u00182\u0006\u0010\u0019\u001a\u00020\tH\u0016\u00a8\u0006\u001a"}, d2={"Lcom/ssblur/scriptor/recipe/SpellbookCloningRecipe;", "Lnet/minecraft/world/item/crafting/CustomRecipe;", "category", "Lnet/minecraft/world/item/crafting/CraftingBookCategory;", "<init>", "(Lnet/minecraft/world/item/crafting/CraftingBookCategory;)V", "matches", "", "container", "Lnet/minecraft/world/item/crafting/CraftingInput;", "level", "Lnet/minecraft/world/level/Level;", "assemble", "Lnet/minecraft/world/item/ItemStack;", "access", "Lnet/minecraft/core/HolderLookup$Provider;", "canCraftInDimensions", "i", "", "j", "getSerializer", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "kotlin.jvm.PlatformType", "getRemainingItems", "Lnet/minecraft/core/NonNullList;", "craftingContainer", "scriptor"})
public final class SpellbookCloningRecipe
extends CustomRecipe {
    public SpellbookCloningRecipe(@NotNull CraftingBookCategory category) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        super(category);
    }

    public boolean matches(@NotNull CraftingInput container, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        int paperCount = 0;
        int binderCount = 0;
        int spellbookCount = 0;
        int n = container.size();
        for (int slot = 0; slot < n; ++slot) {
            if (container.getItem(slot).isEmpty()) continue;
            if (container.getItem(slot).getItem() == Items.PAPER) {
                ++paperCount;
                continue;
            }
            if (container.getItem(slot).getItem() instanceof Spellbook) {
                ItemStack item = container.getItem(slot);
                WrittenBookContent book = (WrittenBookContent)item.get(DataComponents.WRITTEN_BOOK_CONTENT);
                if (book == null || book.generation() >= 2) continue;
                ++spellbookCount;
                continue;
            }
            if (container.getItem(slot).getItem() != ScriptorItems.INSTANCE.getSPELLBOOK_BINDER().get()) continue;
            ++binderCount;
        }
        return spellbookCount == 1 && binderCount == 1 && paperCount == 3;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput container, @NotNull HolderLookup.Provider access) {
        WrittenBookContent book;
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        ItemStack spellbook = ItemStack.EMPTY;
        int n = container.size();
        for (int slot = 0; slot < n; ++slot) {
            if (!(container.getItem(slot).getItem() instanceof Spellbook)) continue;
            spellbook = container.getItem(slot);
        }
        ItemStack copy = spellbook.copyWithCount(1);
        WrittenBookContent writtenBookContent = book = (WrittenBookContent)copy.get(DataComponents.WRITTEN_BOOK_CONTENT);
        Intrinsics.checkNotNull((Object)writtenBookContent);
        copy.set(DataComponents.WRITTEN_BOOK_CONTENT, (Object)new WrittenBookContent(writtenBookContent.title(), book.author(), book.generation(), book.pages(), book.resolved()));
        Intrinsics.checkNotNull((Object)copy);
        return copy;
    }

    public boolean canCraftInDimensions(int i, int j) {
        return i * j >= 6;
    }

    @NotNull
    public RecipeSerializer<SpellbookCloningRecipe> getSerializer() {
        return (RecipeSerializer)ScriptorRecipes.INSTANCE.getSPELLBOOK_CLONING().get();
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingInput craftingContainer) {
        Intrinsics.checkNotNullParameter((Object)craftingContainer, (String)"craftingContainer");
        NonNullList nonNullList = NonNullList.withSize((int)craftingContainer.size(), (Object)ItemStack.EMPTY);
        int n = ((Collection)nonNullList).size();
        for (int i = 0; i < n; ++i) {
            ItemStack itemStack = craftingContainer.getItem(i);
            if (itemStack.getItem().hasCraftingRemainingItem()) {
                Item remainingItem = itemStack.getItem().getCraftingRemainingItem();
                if (remainingItem == null) continue;
                nonNullList.set(i, (Object)new ItemStack((ItemLike)remainingItem));
                continue;
            }
            if (!(itemStack.getItem() instanceof Spellbook)) continue;
            ItemStack itemStack2 = itemStack.copyWithCount(1);
            nonNullList.set(i, (Object)itemStack2);
        }
        Intrinsics.checkNotNull((Object)nonNullList);
        return nonNullList;
    }
}

